#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15504);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : tiff <= 3.6.1_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	tiff <= 3.6.1_2

tiff is a set of tools and libraries to handle .TIFF files.

The remote version of this software is vulnerable to numerous integer
overflow conditions which may allow a remote attacker to execute arbitrary 
code on the remote host.

Solution : http://www.vuxml.org/freebsd/3897a2f8-1d57-11d9-bc4a-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tiff package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^tiff-[0-3]", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"tiff-3.6.1_2") <= 0 )
	security_hole(0);
