#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15813);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 11355 );
 name["english"] = "FreeBSD Ports : squirrelmail <= 1.4.3a_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

ja-squirrelmail < 1.4.3a_4,2
squirrelmail < 1.4.3a_3

There is a cross site scripting issue in the decoding of  encoded text in 
certain headers. SquirrelMail correctly decodes the specially crafted header, 
but doesn't sanitize  the decoded strings.

See also : http://marc.theaimsgroup.com/?l=bugtraq&m=110012133608004
Solution : http://www.vuxml.org/freebsd/7fbfe159-3438-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squirrelmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^squirrelmail-[01]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"squirrelmail-1.4.3a_3") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^ja-squirrelmail-[01]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ja-squirrelmail-1.4.3a_4,2") < 0  )
	{
	security_hole(0);
	exit(0);
	}
