#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12615);
 script_bugtraq_id(9778);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0189");
 name["english"] = "FreeBSD Ports: squid < 2.5.5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of squid installed.

Squid is a Web proxy cache. There is a bug in the remote version of this
package in the way it processes %-encoded characters in URL, which may
allow an attacker to evade Squid's access control lists (ACLs) in order
to get access to web server he should not have access to.

Solution : http://www.vuxml.org/freebsd/705e003a-7f36-11d8-9645-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^squid-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"squid-2.5.5") < 0 ) 
	security_warning(0);
