#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13649);
 script_bugtraq_id(10724);
 script_version ("$Revision: 1.5 $");
 script_cve_id("CAN-2004-0594");
 script_cve_id("CAN-2004-0595");
 name["english"] = "FreeBSD Ports: php < 4.3.8 (or php5 < 5.0.0_1)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of PHP installed which is older than 4.3.8
or older than 5.0.0._1

PHP is a scripting language which acts as a module for Apache or as a standalone
interpreter. There is a bug in the remote version of this software which may
allow an attacker to execute arbitrary code on the remote host if the option
memory_limit is set. Another bug in the function strip_tags() may allow
an attacker to bypass content-restrictions when submitting data and may
lead to cross-site-scripting issues.

Solution : http://www.vuxml.org/freebsd/4764cfd6-d630-11d8-b479-02e0185c0b53.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^mod_php4-twig", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mod_php4-twig-4.3.8") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^php4-", string:pkgs);
foreach package (split(package, sep:'\n', keep:0))
{
 if ( "php4-extensions" >!< package )
 {
 if ( pkg_cmp(pkg:package, reference:"php4-4.3.8") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
 }
}

package = egrep(pattern:"^mod_php4-4", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mod_php4-4.3.8_1") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^php5-", string:pkgs);
foreach package (split(package, sep:'\n', keep:0))
{
 if ( "php5-extensions" >!< package )
 {
 if ( pkg_cmp(pkg:package, reference:"php5-5.0.0") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
 }
}

package = egrep(pattern:"^mod_php5-5", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mod_php5-5.0.0_1") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
