#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12590);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0686");
 name["english"] = "FreeBSD Ports : pam_smb < 1.9.9_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the pam_smb package installed.

pam_smb is a NetBIOS domain logon PAM module. There is a buffer overflow in
the remote version of this software which may allow an attacker to execute
arbitrary code with the superuser privileges. To exploit this flaw,
an attacker simply needs to be prompted for a password by a software using
PAM.

Solution : http://www.vuxml.org/freebsd/2bcd2d24-24ca-11d8-82e5-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pam_smb package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^pam_smb", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"pam_smb-1.9.9_3") < 0 ) 
	security_hole(0);
