#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15806);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : p5-Archive-Zip < 1.14";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

p5-Archive-Zip < 1.14

An AMaViS Security Announcement reports that a  vulnerability exist in the 
Archive::Zip Perl module which  may lead to bypass of malicious code in 
anti-virus programs  by creating specially crafted ZIP files.

Solution : http://www.vuxml.org/freebsd/a5742055-300a-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the p5-Archive-Zip package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^p5-Archive-Zip-[0-9]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"p5-Archive-Zip-1.14") < 0  )
	{
	security_hole(0);
	exit(0);
	}
