#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12578);
 script_bugtraq_id(9885);
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports : mod_security < 1.7.5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mod_security package installed.

mod_security is an intrusion detection and prevention engine for the Apache
web server. There is an off-by-one overflow in the remote version of this
software which may allow an attacker to execute arbitrary commands on the
remote host with the privileges of the httpd process.

Solution : http://www.vuxml.org/freebsd/c2e10368-77ab-11d8-b9e8-00e04ccb0a62.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mod_security package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^mod_security-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mod_security-1.7.5") < 0 ) 
	security_hole(0);

