#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14590);
 script_bugtraq_id(11084);
 script_cve_id("CAN-2004-0817", "CAN-2004-0802");
 name["english"] = "FreeBSD Ports : imlib2 <=  1.1.1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the imlib2 package which is
older or as old as version 1.1.1.

imlib2 an image manipulation library. There is a heap overflow
in the remote version of this package when it processes a specially
crafted BMP file. An attacker may exploit this flaw to execute arbitrary
code on the remote host.

To exploit this flaw, an attacker would need to craft a malformed image
file and to send it to a victim on the remote host, and have the victim
open the file with an imlib2-enabled software.

Solution : http://www.vuxml.org/freebsd/ba005226-fb5b-11d8-9837-000c41e2cdad.html
Risk Factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the imlib2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^imlib2-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"imlib2-1.1.1") <= 0 ) 
        {
        security_hole(0);
        exit(0);
        }
