#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12551);
 script_bugtraq_id(9715);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0159");
 name["english"] = "FreeBSD Ports : hsftp < 1.14";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the hsftp package which is older
than 1.14.

hsftp is a FTP emulator which uses ssh to transport commands. There is a 
format string issue in this software which may allow an attacker to 
execute arbitrary commands on this host. To exploit this flaw, an
attacker would need to set up a rogue server containing malformed
names in a directory, causing a format string issue when a user requests
the listing of the directory content.

Note that since hsftp is suid root, a local user could do the same thing
to elevate his privileges.

Solution : http://www.vuxml.org/freebsd/316e1c9b-671c-11d8-9aad-000a95bc6fae.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of several packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^hsftp-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"hsftp-1.14") < 0 ) 
	security_hole(0);
