#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14763);
 script_version ("$Revision: 1.4 $");
 script_bugtraq_id(11183);
 script_cve_id("CAN-2004-0809", "CAN-2004-0558");
 name["english"] = "FreeBSD Ports : CUPS < 1.1.21";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	cups-base < 1.1.21


CUPS is the 'Common UNIX Printing System', a replacement for lpr.

There is a flaw in the remote version of this package which may allow
an attacker to crash the queue browser service by sending a zero-length
UDP message to the remote host.

Solution : http://www.vuxml.org/freebsd/05dcf751-0733-11d9-b45d-000c41e2cdad.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cups-base package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^cups-base-[0-9]", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"cups-base-1.1.21.0") < 0 ) 
	{
	security_warning(0);
	exit(0);
	}
