#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14845);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0492");
 name["english"] = "FreeBSD Ports : Apache <= 1.3.31_6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed (older than
or as old as apache-1.3.31_6).


There is a buffer overflow in mod_proxy which may allow an attacker to launch
a local denial of service attack and possibly to execute arbitrary code.

Solution : http://www.vuxml.org/freebsd/ca6c8f35-0a5f-11d9-ad6f-00061bc2ad93.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^apache13-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache13-1.3.31_6") <= 0 ) 
	{
	security_warning(0);
	exit(0);
	}
