/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class PointList
implements Serializable,
Translatable {
    private int[] points = new int[0];
    private Rectangle bounds;
    private int size = 0;
    static final long serialVersionUID = 1L;

    public PointList() {
    }

    public PointList(int[] points) {
        this.points = points;
        this.size = points.length / 2;
    }

    public PointList(int size) {
        this.points = new int[size * 2];
    }

    public void addAll(PointList source) {
        this.ensureCapacity(this.size + source.size);
        System.arraycopy(source.points, 0, this.points, this.size * 2, source.size * 2);
        this.size += source.size;
    }

    public void addPoint(Point p) {
        this.addPoint(p.x, p.y);
    }

    public void addPoint(int x, int y) {
        this.bounds = null;
        int index = this.size * 2;
        this.ensureCapacity(this.size + 1);
        this.points[index] = x;
        this.points[index + 1] = y;
        ++this.size;
    }

    private void ensureCapacity(int newSize) {
        if (this.size < newSize) {
            int[] old = this.points;
            newSize = Math.max(newSize, this.size * 3 / 2);
            this.points = new int[newSize * 2];
            System.arraycopy(old, 0, this.points, 0, this.size * 2);
        }
    }

    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        this.bounds = new Rectangle();
        if (this.size > 0) {
            this.bounds.setLocation(this.getPoint(0));
            int i = 0;
            while (i < this.size) {
                this.bounds.union(this.getPoint(i));
                ++i;
            }
        }
        return this.bounds;
    }

    public PointList getCopy() {
        PointList result = new PointList(this.size);
        System.arraycopy(this.points, 0, result.points, 0, this.size * 2);
        result.size = this.size;
        result.bounds = null;
        return result;
    }

    public Point getFirstPoint() {
        return this.getPoint(0);
    }

    public Point getLastPoint() {
        return this.getPoint(this.size - 1);
    }

    public Point getMidpoint() {
        if (this.size() % 2 == 0) {
            return this.getPoint(this.size() / 2 - 1).getTranslated(this.getPoint(this.size() / 2)).scale(0.5);
        }
        return this.getPoint(this.size() / 2);
    }

    public Point getPoint(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return new Point(this.points[index *= 2], this.points[index + 1]);
    }

    public Point getPoint(Point p, int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        p.x = this.points[index *= 2];
        p.y = this.points[index + 1];
        return p;
    }

    public void insertPoint(Point p, int index) {
        if (this.bounds != null && !this.bounds.contains(p)) {
            this.bounds = null;
        }
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int length = this.points.length;
        int[] old = this.points;
        this.points = new int[length + 2];
        System.arraycopy(old, 0, this.points, 0, index *= 2);
        System.arraycopy(old, index, this.points, index + 2, length - index);
        this.points[index] = p.x;
        this.points[index + 1] = p.y;
        ++this.size;
    }

    public void performScale(double factor) {
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = (int)Math.floor((double)this.points[i] * factor);
            ++i;
        }
        this.bounds = null;
    }

    public void performTranslate(int dx, int dy) {
        int i = 0;
        while (i < this.size * 2) {
            int n = i;
            this.points[n] = this.points[n] + dx;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] + dy;
            i += 2;
        }
        if (this.bounds != null) {
            this.bounds.translate(dx, dy);
        }
    }

    public void removeAllPoints() {
        this.bounds = null;
        this.size = 0;
    }

    public Point removePoint(int index) {
        this.bounds = null;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Point pt = new Point(this.points[index *= 2], this.points[index + 1]);
        if (index != this.size * 2 - 2) {
            System.arraycopy(this.points, index + 2, this.points, index, this.size * 2 - index - 2);
        }
        --this.size;
        return pt;
    }

    public void setPoint(Point pt, int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (this.bounds == null || !this.bounds.contains(pt)) {
            // empty if block
        }
        this.bounds = null;
        this.points[index * 2] = pt.x;
        this.points[index * 2 + 1] = pt.y;
    }

    public void setSize(int newSize) {
        if (this.points.length > newSize * 2) {
            this.size = newSize;
            return;
        }
        int[] newArray = new int[newSize * 2];
        System.arraycopy(this.points, 0, newArray, 0, this.points.length);
        this.points = newArray;
        this.size = newSize;
    }

    public int size() {
        return this.size;
    }

    public int[] toIntArray() {
        if (this.points.length != this.size * 2) {
            int[] old = this.points;
            this.points = new int[this.size * 2];
            System.arraycopy(old, 0, this.points, 0, this.size * 2);
        }
        return this.points;
    }

    public final void translate(Point pt) {
        this.translate(pt.x, pt.y);
    }

    public void translate(int x, int y) {
        if (x == 0 && y == 0) {
            return;
        }
        if (this.bounds != null) {
            this.bounds.translate(x, y);
        }
        int i = 0;
        while (i < this.size * 2) {
            int n = i;
            this.points[n] = this.points[n] + x;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] + y;
            i += 2;
        }
    }
}

