/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;

public class SWTGraphics
extends Graphics {
    public static boolean debug = false;
    private final State appliedState = new State();
    private final State currentState = new State();
    private GC gc;
    private final Rectangle relativeClip;
    private List stack = new ArrayList();
    private int stackPointer = 0;
    private int translateX = 0;
    private int translateY = 0;

    public SWTGraphics(GC gc) {
        this.gc = gc;
        this.relativeClip = new Rectangle(gc.getClipping());
        this.init();
    }

    protected final void checkFill() {
        if (!this.appliedState.bgColor.equals((Object)this.currentState.bgColor)) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
        this.checkGC();
    }

    protected final void checkGC() {
        if (this.appliedState.xor != this.currentState.xor) {
            this.appliedState.xor = this.currentState.xor;
            this.gc.setXORMode(this.appliedState.xor);
        }
        if (this.appliedState.clipX != this.currentState.clipX || this.appliedState.clipY != this.currentState.clipY || this.appliedState.clipW != this.currentState.clipW || this.appliedState.clipH != this.currentState.clipH) {
            this.appliedState.clipX = this.currentState.clipX;
            this.appliedState.clipY = this.currentState.clipY;
            this.appliedState.clipW = this.currentState.clipW;
            this.appliedState.clipH = this.currentState.clipH;
            this.gc.setClipping(this.appliedState.clipX, this.appliedState.clipY, this.appliedState.clipW, this.appliedState.clipH);
        }
    }

    protected final void checkPaint() {
        this.checkGC();
        if (!this.appliedState.fgColor.equals((Object)this.currentState.fgColor)) {
            this.appliedState.fgColor = this.currentState.fgColor;
            this.gc.setForeground(this.appliedState.fgColor);
        }
        if (this.appliedState.lineStyle != this.currentState.lineStyle) {
            this.appliedState.lineStyle = this.currentState.lineStyle;
            this.gc.setLineStyle(this.appliedState.lineStyle);
        }
        if (this.appliedState.lineWidth != this.currentState.lineWidth) {
            this.appliedState.lineWidth = this.currentState.lineWidth;
            this.gc.setLineWidth(this.appliedState.lineWidth);
        }
        if (!this.appliedState.bgColor.equals((Object)this.currentState.bgColor)) {
            this.appliedState.bgColor = this.currentState.bgColor;
            this.gc.setBackground(this.appliedState.bgColor);
        }
    }

    protected final void checkText() {
        this.checkPaint();
        this.checkFill();
        if (!this.appliedState.font.equals((Object)this.currentState.font)) {
            this.appliedState.font = this.currentState.font;
            this.gc.setFont(this.appliedState.font);
        }
    }

    public void clipRect(Rectangle rect) {
        this.relativeClip.intersect(rect);
        this.setClipAbsolute(this.relativeClip.x + this.translateX, this.relativeClip.y + this.translateY, this.relativeClip.width, this.relativeClip.height);
    }

    public void dispose() {
        while (this.stackPointer > 0) {
            this.popState();
        }
    }

    public void drawArc(int x, int y, int width, int height, int offset, int length) {
        this.checkPaint();
        this.gc.drawArc(x + this.translateX, y + this.translateY, width, height, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.checkPaint();
        this.checkFill();
        this.gc.drawFocus(x + this.translateX, y + this.translateY, w + 1, h + 1);
    }

    public void drawImage(Image srcImage, int x, int y) {
        this.checkGC();
        this.gc.drawImage(srcImage, x + this.translateX, y + this.translateY);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        this.checkGC();
        this.gc.drawImage(srcImage, x1, y1, w1, h1, x2 + this.translateX, y2 + this.translateY, w2, h2);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkPaint();
        this.gc.drawLine(x1 + this.translateX, y1 + this.translateY, x2 + this.translateX, y2 + this.translateY);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawOval(x + this.translateX, y + this.translateY, width, height);
    }

    public void drawPoint(int x, int y) {
        this.checkPaint();
        this.gc.drawPoint(x + this.translateX, y + this.translateY);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawPolygon(int[] points) {
        this.checkPaint();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.drawPolygon(points);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void drawPolygon(PointList points) {
        this.drawPolygon(points.toIntArray());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawPolyline(int[] points) {
        this.checkPaint();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.drawPolyline(points);
            if (this.getLineWidth() == 1 && points.length >= 2) {
                int x = points[points.length - 2];
                int y = points[points.length - 1];
                this.gc.drawLine(x, y, x, y);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void drawPolyline(PointList points) {
        this.drawPolyline(points.toIntArray());
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.checkPaint();
        this.gc.drawRectangle(x + this.translateX, y + this.translateY, width, height);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkPaint();
        this.gc.drawRoundRectangle(r.x + this.translateX, r.y + this.translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void drawString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, true);
    }

    public void drawText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, true);
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.checkText();
        layout.draw(this.gc, x + this.translateX, y + this.translateY, selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    public void fillArc(int x, int y, int width, int height, int offset, int length) {
        this.checkFill();
        this.gc.fillArc(x + this.translateX, y + this.translateY, width, height, offset, length);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.checkFill();
        this.checkPaint();
        this.gc.fillGradientRectangle(x + this.translateX, y + this.translateY, w, h, vertical);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.checkFill();
        this.gc.fillOval(x + this.translateX, y + this.translateY, width, height);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillPolygon(int[] points) {
        this.checkFill();
        try {
            this.translatePointArray(points, this.translateX, this.translateY);
            this.gc.fillPolygon(points);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.translatePointArray(points, -this.translateX, -this.translateY);
            return;
        }
    }

    public void fillPolygon(PointList points) {
        this.fillPolygon(points.toIntArray());
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.checkFill();
        this.gc.fillRectangle(x + this.translateX, y + this.translateY, width, height);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.checkFill();
        this.gc.fillRoundRectangle(r.x + this.translateX, r.y + this.translateY, r.width, r.height, arcWidth, arcHeight);
    }

    public void fillString(String s, int x, int y) {
        this.checkText();
        this.gc.drawString(s, x + this.translateX, y + this.translateY, false);
    }

    public void fillText(String s, int x, int y) {
        this.checkText();
        this.gc.drawText(s, x + this.translateX, y + this.translateY, false);
    }

    public Color getBackgroundColor() {
        return this.currentState.bgColor;
    }

    public Rectangle getClip(Rectangle rect) {
        rect.setBounds(this.relativeClip);
        return rect;
    }

    public Font getFont() {
        return this.currentState.font;
    }

    public FontMetrics getFontMetrics() {
        this.checkText();
        return this.gc.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.currentState.fgColor;
    }

    public int getLineStyle() {
        return this.currentState.lineStyle;
    }

    public int getLineWidth() {
        return this.currentState.lineWidth;
    }

    public boolean getXORMode() {
        return this.currentState.xor;
    }

    protected void init() {
        this.currentState.bgColor = this.appliedState.bgColor = this.gc.getBackground();
        this.currentState.fgColor = this.appliedState.fgColor = this.gc.getForeground();
        this.currentState.font = this.appliedState.font = this.gc.getFont();
        this.currentState.lineWidth = this.appliedState.lineWidth = this.gc.getLineWidth();
        this.currentState.lineStyle = this.appliedState.lineStyle = this.gc.getLineStyle();
        this.currentState.clipX = this.appliedState.clipX = this.relativeClip.x;
        this.currentState.clipY = this.appliedState.clipY = this.relativeClip.y;
        this.currentState.clipW = this.appliedState.clipW = this.relativeClip.width;
        this.currentState.clipH = this.appliedState.clipH = this.relativeClip.height;
        this.currentState.xor = this.appliedState.xor = this.gc.getXORMode();
    }

    public void popState() {
        --this.stackPointer;
        this.restoreState((State)this.stack.get(this.stackPointer));
    }

    public void pushState() {
        try {
            if (this.stack.size() > this.stackPointer) {
                State s = (State)this.stack.get(this.stackPointer);
                s.copyFrom(this.currentState);
            } else {
                this.stack.add(this.currentState.clone());
            }
            ++this.stackPointer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void restoreState() {
        this.restoreState((State)this.stack.get(this.stackPointer - 1));
    }

    protected void restoreState(State s) {
        this.setBackgroundColor(s.bgColor);
        this.setForegroundColor(s.fgColor);
        this.setLineStyle(s.lineStyle);
        this.setLineWidth(s.lineWidth);
        this.setFont(s.font);
        this.setXORMode(s.xor);
        this.setClipAbsolute(s.clipX, s.clipY, s.clipW, s.clipH);
        this.translateX = this.currentState.dx = s.dx;
        this.translateY = this.currentState.dy = s.dy;
        this.relativeClip.x = s.clipX - this.translateX;
        this.relativeClip.y = s.clipY - this.translateY;
        this.relativeClip.width = s.clipW;
        this.relativeClip.height = s.clipH;
    }

    public void scale(double factor) {
    }

    public void setBackgroundColor(Color color) {
        if (this.currentState.bgColor.equals((Object)color)) {
            return;
        }
        this.currentState.bgColor = color;
    }

    public void setClip(Rectangle rect) {
        this.relativeClip.x = rect.x;
        this.relativeClip.y = rect.y;
        this.relativeClip.width = rect.width;
        this.relativeClip.height = rect.height;
        this.setClipAbsolute(rect.x + this.translateX, rect.y + this.translateY, rect.width, rect.height);
    }

    protected void setClipAbsolute(int x, int y, int w, int h) {
        if (this.currentState.clipW == w && this.currentState.clipH == h && this.currentState.clipX == x && this.currentState.clipY == y) {
            return;
        }
        this.currentState.clipX = x;
        this.currentState.clipY = y;
        this.currentState.clipW = w;
        this.currentState.clipH = h;
    }

    public void setFont(Font f) {
        if (this.currentState.font == f) {
            return;
        }
        this.currentState.font = f;
    }

    public void setForegroundColor(Color color) {
        if (this.currentState.fgColor.equals((Object)color)) {
            return;
        }
        this.currentState.fgColor = color;
    }

    public void setLineStyle(int style) {
        if (this.currentState.lineStyle == style) {
            return;
        }
        this.currentState.lineStyle = style;
    }

    public void setLineWidth(int width) {
        if (this.currentState.lineWidth == width) {
            return;
        }
        this.currentState.lineWidth = width;
    }

    protected void setTranslation(int x, int y) {
        this.translateX = this.currentState.dx = x;
        this.translateY = this.currentState.dy = y;
    }

    public void setXORMode(boolean b) {
        if (this.currentState.xor == b) {
            return;
        }
        this.currentState.xor = b;
    }

    private void translatePointArray(int[] points, int translateX, int translateY) {
        if (translateX == 0 && translateY == 0) {
            return;
        }
        int i = 0;
        while (i + 1 < points.length) {
            int n = i;
            points[n] = points[n] + translateX;
            int n2 = i + 1;
            points[n2] = points[n2] + translateY;
            i += 2;
        }
    }

    public void translate(int x, int y) {
        this.setTranslation(this.translateX + x, this.translateY + y);
        this.relativeClip.x -= x;
        this.relativeClip.y -= y;
    }

    protected static class State
    implements Cloneable {
        public Color bgColor;
        public Color fgColor;
        public int clipX;
        public int clipY;
        public int clipW;
        public int clipH;
        public Font font;
        public int lineWidth;
        public int lineStyle;
        public int dx;
        public int dy;
        public boolean xor;

        protected State() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public void copyFrom(State state) {
            this.bgColor = state.bgColor;
            this.fgColor = state.fgColor;
            this.lineStyle = state.lineStyle;
            this.lineWidth = state.lineWidth;
            this.dx = state.dx;
            this.dy = state.dy;
            this.font = state.font;
            this.clipX = state.clipX;
            this.clipY = state.clipY;
            this.clipW = state.clipW;
            this.clipH = state.clipH;
            this.xor = state.xor;
        }
    }
}

