##############################################################################
#
# Copyright (c) 2001 Zope Corporation and Contributors. All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
""" Catalog tool interface.

$Id: portal_catalog.py,v 1.7.14.2 2004/04/23 21:11:34 sidnei Exp $
"""

from Interface import Attribute
try:
    from Interface import Interface
except ImportError:
    # for Zope versions before 2.6.0
    from Interface import Base as Interface


class portal_catalog(Interface):
    '''This tool interacts with a customized ZCatalog.
    '''
    id = Attribute('id', 'Must be set to "portal_catalog"')

    # searchResults inherits security assertions from ZCatalog.
    def searchResults(REQUEST=None, **kw):
        '''Calls SiteIndex.searchResults() with extra arguments that
        limit the results to what the user is allowed to see.
        '''

    # __call__ inherits security assertions from ZCatalog.
    def __call__(REQUEST=None, **kw):
        '''Same as searchResults().'''

    # indexObject__roles__ = ()  # Called only by Python code.
    def indexObject(object):
        '''Add to catalog.
        '''

    # unindexObject__roles__ = ()
    def unindexObject(object):
        '''Remove from catalog.
        '''

    # reindexObject__roles__ = ()
    def reindexObject(object, idxs=[]):
        '''Update entry in catalog.
        The optional idxs argument is a list of specific indexes
        to update (all of them by default).
        '''

    # getpath inherits security assertions from ZCatalog.
    def getpath(data_record_id_):
        '''Calls ZCatalog.getpath().
        '''


class IndexableObjectWrapper(Interface):
    """ Indexable object wrapper interface.
    """

    def allowedRolesAndUsers():
        """
        Return a list of roles and users with View permission.
        Used by PortalCatalog to filter out items you're not allowed to see.
        """
