#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12625);
 script_bugtraq_id(9636, 9652, 9655);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0083", "CAN-2004-0084", "CAN-2004-0106");
 name["english"] = "FreeBSD Ports : XFree86-Server <= 4.3.0_13";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of XFree86-Server installed.

There are a number of buffer overflows which have been discovered in the 
font alias handling of the server, which may allow a local user to escalate
his privileges to gain super-user privileges.

Solution : http://www.vuxml.org/freebsd/3837f462-5d6b-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the XFree86-Server package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^XFree86-Server-4\.3\.99", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"XFree86-Server-4.3.99.15_2") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^XFree86-Server", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"XFree86-Server-4.3.0_14") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
