#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12552);
 script_bugtraq_id(2932, 2933, 4415, 4735, 4743);
 script_version ("$Revision: 1.5 $");
 script_cve_id("CVE-2001-0784", "CVE-2001-1083", "CAN-2001-1229", "CAN-2001-1230",  "CAN-2002-0177");
 name["english"] = "FreeBSD Ports : icecast < 1.3.12";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the icecast package which is older
than 1.3.12.

icecast is a streaming MP3/OggVorbis audio server. There are numerous security
problems in the remote version of this software which may allow an attacker
to execute arbitrary code on this host with the superuser privileges.

Solution : http://www.vuxml.org/freebsd/83119e27-5d7c-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the icecast package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^icecast-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"icecast-1.3.12") < 0 ) 
	security_hole(0);

