#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14341);
 script_bugtraq_id(11005);
 script_version ("$Revision: 1.4 $");
 name["english"] = "FreeBSD Ports : fidogate < 4.4.9_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the fidogate package which is older
than 4.4.9_3.

Fidogate is a Fido - Internet Gateway and tosser. There is a vulnerability
in this package, in the setuid 'news' binary, which might be used by a local
user to create or append to files with the privileges of the 'news' user.

Solution : http://www.vuxml.org/freebsd/3243e839-f489-11d8-9837-000c41e2cdad.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the fidogate package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^fidogate-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"fidogate-4.4.9_3") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
