#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# It is released under the GNU Public Licence.
#
#

if(description)
{
 script_id(14773);
 script_version ("$Revision: 1.6 $");
 
 name["english"] = "Identifies services like FTP, SMTP, NNTP...";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin is a complement of find_service.nes
It tries to identifies services that return 3 ASCII digits codes
(like FTP, SMTP, NNTP...)

Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Identifies services that return 3 ASCII digits codes";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO); 
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "Misc.";
 family["francais"] = "Divers";

 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 # "rpcinfo.nasl", "dcetest.nasl"

# Do *not* add a port dependency  on "Services/three_digits"
# find_service2 must run after this script even if there are no
# '3 digits' services

 exit(0);
}

#
include("misc_func.inc");
include("global_settings.inc");

port = get_kb_item("Services/three_digits");
if (! port) exit(0);
if (! get_port_state(port)) exit(0);
if (known_service(port: port)) exit(0);	

function read_answer(socket)
{
  local_var	r, answer;

  repeat
  {
   r = recv_line(socket: socket, length: 4096);
   answer += r;
  }
  until (! r || r =~ '^[0-9]{3}[^-]');
  return answer;
}

soc = open_sock_tcp(port);
if (! soc) exit(0);
banner = read_answer(socket: soc);

# 500 = Unknown command
# 502 = Command not implemented

# If HELP works, it is simpler than anything else
send(socket: soc, data: 'HELP\r\n');
r = read_answer(socket: soc);
if (r !~ '^50[0-9]')
{
 if ("ARTICLE" >< r || "NEWGROUPS" >< r || "XHDR" >< r || "XOVER" >< r)
 {
  report_service(port:port, svc: 'nntp', banner: r);
  exit(0);
 }
 if ("PORT" >< r || "PASV" >< r)
 {
  report_service(port:port, svc: 'ftp', banner: r); 
  exit(0);
 }
}

send(socket: soc, data: 'HELO mail.nessus.org\r\n');
r = read_answer(socket: soc);

if (! egrep(string: r, pattern: '^50[0-9]'))
{
 report_service(port:port, svc: 'smtp', banner: r);
 exit(0);
}


send(socket: soc, data: 'DATE\r\n');
r = read_answer(socket: soc);
if (r =~ '^111[ \t]+2[0-9]{3}[01][0-9][0-3][0-9][0-2][0-9][0-5][0-9][0-5][0-9]')
{
 report_service(port: port, svc: 'nntp', banner: r);
 exit(0);
}

# Code from find_service2.nasl:
# SNPP, HylaFax FTP, HylaFAX SPP, agobot.fo, IRC bots, WinSock server,
# Note: this code must remain in find_service2.nasl until we think that
# all find_service.nes are up to date
#

if (r =~ '^220 .* SNPP ' || egrep(string: r, pattern: '^214 .*PAGE'))
{
  report_service(port: port, svc: 'snpp', banner: r);
  exit(0);
}
if (egrep(string: r, pattern: '^214-? ') && 'MDMFMT' >< r)
{
  report_service(port: port, svc: 'hylafax-ftp', banner: r);
  exit(0);
}
if (egrep(string:r, pattern:"^220.*HylaFAX .*Version.*"))
{
  report_service(port: port, svc: 'hylafax', banner: r);
  exit(0);
}
if (egrep(pattern:"^220 Bot Server", string:r) ||
     raw_string(0xb0, 0x3e, 0xc3, 0x77, 0x4d, 0x5a, 0x90) >< r)
{
 report_service(port:port, svc:"agobot.fo", banner: r);
 exit(0);
}
if ("500 P-Error" >< r && "220 Hello" >< r)
{
 report_service(port:port, svc:'unknown_irc_bot', banner: r);
 exit(0);
}
if ("220 WinSock" >< r)
{
 report_service(port:port, svc:'winsock', banner: r);
 exit(0);
}

# Give it to find_service2 & others
register_service(port: port, proto: 'unknown');
set_unknown_banner(port: port, banner: banner);
