/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    private static final int DEFAULT = 512;
    protected Deflater def;
    protected byte[] buf;

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    protected void deflate() throws IOException {
        do {
            int n = this.def.deflate(this.buf, 0, this.buf.length);
            super.write(this.buf, 0, n);
        } while (!this.def.needsInput());
    }

    public void finish() throws IOException {
        this.def.finish();
        while (!this.def.finished()) {
            this.deflate();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.def.setInput(byArray, n, n2);
        this.deflate();
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public DeflaterOutputStream(OutputStream outputStream) {
        this(outputStream, new Deflater(), 512);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        this(outputStream, deflater, 512);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        if (deflater == null) {
            throw new NullPointerException("def");
        }
        this.def = deflater;
        if (n < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.buf = new byte[n];
    }
}

