/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public abstract class Calendar
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1807547505821590642L;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    private TimeZone zone;
    private Locale locale;
    private boolean lenient = true;
    private int firstdayofweek = 1;
    private int mindaysinfirstweek = 1;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    protected long time = 0L;
    protected boolean isTimeSet = false;
    protected boolean areFieldsSet = false;

    public abstract void add(int var1, int var2);

    public abstract boolean after(Object var1);

    public abstract boolean before(Object var1);

    public final void clear() {
        int n = 0;
        while (n < 17) {
            this.fields[n] = 0;
            this.isSet[n] = false;
            ++n;
        }
        this.areFieldsSet = false;
    }

    public final void clear(int n) {
        this.isSet[n] = false;
        this.fields[n] = 0;
        this.areFieldsSet = false;
    }

    public Object clone() {
        Calendar calendar = Calendar.getInstance(this.zone, this.locale);
        calendar.time = this.time;
        int n = 0;
        while (n < 17) {
            calendar.fields[n] = this.fields[n];
            calendar.isSet[n] = this.isSet[n];
            ++n;
        }
        calendar.isTimeSet = this.isTimeSet;
        calendar.areFieldsSet = this.areFieldsSet;
        return calendar;
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    public abstract boolean equals(Object var1);

    public final int get(int n) {
        this.complete();
        return this.fields[n];
    }

    public static synchronized Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    public int getFirstDayOfWeek() {
        return this.firstdayofweek;
    }

    public abstract int getGreatestMinimum(int var1);

    public static synchronized Calendar getInstance() {
        return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale2) {
        return Calendar.getInstance(TimeZone.getDefault(), locale2);
    }

    public static synchronized Calendar getInstance(TimeZone timeZone) {
        return Calendar.getInstance(timeZone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(TimeZone timeZone, Locale locale2) {
        return new GregorianCalendar(timeZone, locale2);
    }

    public abstract int getLeastMaximum(int var1);

    public abstract int getMaximum(int var1);

    public int getMinimalDaysInFirstWeek() {
        return this.mindaysinfirstweek;
    }

    public abstract int getMinimum(int var1);

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    protected long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final boolean isSet(int n) {
        return this.isSet[n];
    }

    public abstract void roll(int var1, boolean var2);

    public final void set(int n, int n2) {
        this.isSet[n] = true;
        this.fields[n] = n2;
        this.isTimeSet = false;
        this.areFieldsSet = false;
    }

    public final void set(int n, int n2, int n3) {
        this.fields[1] = n;
        this.fields[2] = n2;
        this.fields[5] = n3;
        this.isSet[1] = true;
        this.isSet[2] = true;
        this.isSet[5] = true;
        this.isTimeSet = false;
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.fields[1] = n;
        this.fields[2] = n2;
        this.fields[5] = n3;
        this.fields[11] = n4;
        this.fields[12] = n5;
        this.isSet[1] = true;
        this.isSet[2] = true;
        this.isSet[5] = true;
        this.isSet[11] = true;
        this.isSet[12] = true;
        this.isTimeSet = false;
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fields[1] = n;
        this.fields[2] = n2;
        this.fields[5] = n3;
        this.fields[11] = n4;
        this.fields[12] = n5;
        this.fields[13] = n6;
        this.isSet[1] = true;
        this.isSet[2] = true;
        this.isSet[5] = true;
        this.isSet[11] = true;
        this.isSet[12] = true;
        this.isSet[13] = true;
        this.isTimeSet = false;
    }

    public void setFirstDayOfWeek(int n) {
        this.firstdayofweek = n;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        this.mindaysinfirstweek = n;
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    protected void setTimeInMillis(long l) {
        this.time = l;
        this.isTimeSet = true;
        this.areFieldsSet = false;
        this.computeFields();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
    }

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale2) {
        this.zone = timeZone;
        this.locale = locale2;
    }
}

