/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import kaffe.lang.SystemClassLoader;

public final class Class
implements Serializable {
    public static Class forName(String string) throws ClassNotFoundException {
        Class clazz = Class.getStackClass(1);
        if (clazz != null && clazz.getName().equals("java.lang.reflect.Method")) {
            clazz = Class.getStackClass(2);
        }
        return Class.forName(string, true, clazz == null ? null : clazz.getClassLoader());
    }

    public static native Class forName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    private String fullResourceName(String string) {
        if (string.charAt(0) == '/') {
            return string.substring(1);
        }
        String string2 = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            stringBuffer.append(string2.substring(0, n + 1).replace('.', '/'));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader0();
    }

    private native ClassLoader getClassLoader0();

    public Class[] getClasses() {
        return this.getClasses0(false);
    }

    private native Class[] getClasses0(boolean var1);

    public native Class getComponentType();

    public Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 0);
        return this.getConstructor0(classArray, false);
    }

    private native Constructor getConstructor0(Class[] var1, boolean var2);

    public Constructor[] getConstructors() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 0);
        return this.getConstructors0(false);
    }

    private native Constructor[] getConstructors0(boolean var1);

    public Class[] getDeclaredClasses() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getClasses0(true);
    }

    public Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getConstructor0(classArray, true);
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getConstructors0(true);
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getField0(string, true);
    }

    public Field[] getDeclaredFields() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getFields0(true);
    }

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getMethod0(string, classArray, true);
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 1);
        return this.getMethods0(true);
    }

    public Class getDeclaringClass() {
        return null;
    }

    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 0);
        return this.getField0(string, false);
    }

    private native Field getField0(String var1, boolean var2);

    public Field[] getFields() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 0);
        return this.getFields0(false);
    }

    private native Field[] getFields0(boolean var1);

    public native Class[] getInterfaces();

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 0);
        return this.getMethod0(string, classArray, false);
    }

    private native Method getMethod0(String var1, Class[] var2, boolean var3);

    public Method[] getMethods() throws SecurityException {
        System.getSecurityManager().checkMemberAccess(this, 0);
        return this.getMethods0(false);
    }

    private native Method[] getMethods0(boolean var1);

    public native int getModifiers();

    public native String getName();

    static native Class getPrimitiveClass(String var0);

    public URL getResource(String string) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = SystemClassLoader.getClassLoader();
        }
        return classLoader.getResource(this.fullResourceName(string));
    }

    public InputStream getResourceAsStream(String string) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = SystemClassLoader.getClassLoader();
        }
        InputStream inputStream = classLoader.getResourceAsStream(this.fullResourceName(string));
        return inputStream;
    }

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public native Class getSuperclass();

    public native boolean isArray();

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public native boolean isPrimitive();

    public native Object newInstance() throws InstantiationException, IllegalAccessException;

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    static Class getStackClass(int n) {
        Class[] classArray = System.getSecurityManager().getClassContext();
        if ((n += 3) >= 0 && n < classArray.length) {
            return classArray[n];
        }
        return null;
    }

    private Class() {
    }
}

