/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.balancer.Rule;

public class RuleChain {
    private List rules = new ArrayList();

    protected List getRules() {
        return this.rules;
    }

    protected Iterator getRuleIterator() {
        return this.getRules().iterator();
    }

    public void addRule(Rule theRule) {
        if (theRule == null) {
            throw new IllegalArgumentException("The rule cannot be null.");
        }
        this.getRules().add(theRule);
    }

    public URL evaluate(HttpServletRequest request) {
        Iterator iter = this.getRuleIterator();
        Rule currentRule = null;
        boolean currentMatches = false;
        while (iter.hasNext()) {
            currentRule = (Rule)iter.next();
            currentMatches = currentRule.matches(request);
            if (!currentMatches) continue;
            try {
                return new URL(currentRule.getRedirectUrl());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        Iterator iter = this.getRuleIterator();
        Rule currentRule = null;
        while (iter.hasNext()) {
            currentRule = (Rule)iter.next();
            buffer.append(currentRule);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

