/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.users.UserForm;

public final class SaveUserAction
extends Action {
    private MessageResources resources = null;
    private MBeanServer mserver = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int i;
        Object[] addpar;
        String[] addsig;
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.isCancelled(request)) {
            return mapping.findForward("List Users Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, this.resources.getMessage(locale, "users.error.token"));
            return null;
        }
        UserForm userForm = (UserForm)form;
        String databaseName = URLDecoder.decode(userForm.getDatabaseName());
        String objectName = userForm.getObjectName();
        if (objectName == null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{userForm.getUsername(), userForm.getPassword(), userForm.getFullName()};
            ObjectName oname = null;
            try {
                oname = new ObjectName(databaseName);
                objectName = (String)this.mserver.invoke(oname, "createUser", params, signature);
            }
            catch (Exception e) {
                this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)"createUser"), (Throwable)e);
                response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)"createUser"));
                return null;
            }
        }
        ObjectName oname = null;
        String attribute = null;
        try {
            oname = new ObjectName(objectName);
            attribute = "fullName";
            this.mserver.setAttribute(oname, new Attribute(attribute, userForm.getFullName()));
            attribute = "password";
            this.mserver.setAttribute(oname, new Attribute(attribute, userForm.getPassword()));
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.set.attribute", (Object)attribute), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.set.attribute", (Object)attribute));
            return null;
        }
        try {
            oname = new ObjectName(objectName);
            this.mserver.invoke(oname, "removeGroups", new Object[0], new String[0]);
            String[] groups = userForm.getGroups();
            if (groups == null) {
                groups = new String[]{};
            }
            addsig = new String[]{"java.lang.String"};
            addpar = new Object[1];
            for (i = 0; i < groups.length; ++i) {
                addpar[0] = new ObjectName(groups[i]).getKeyProperty("groupname");
                this.mserver.invoke(oname, "addGroup", addpar, addsig);
            }
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)"addGroup"), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)"addGroup"));
            return null;
        }
        try {
            oname = new ObjectName(objectName);
            this.mserver.invoke(oname, "removeRoles", new Object[0], new String[0]);
            String[] roles = userForm.getRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            addsig = new String[]{"java.lang.String"};
            addpar = new Object[1];
            for (i = 0; i < roles.length; ++i) {
                addpar[0] = new ObjectName(roles[i]).getKeyProperty("rolename");
                this.mserver.invoke(oname, "addRole", addpar, addsig);
            }
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)"addRole"), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)"addRole"));
            return null;
        }
        try {
            ObjectName dname = new ObjectName(databaseName);
            this.mserver.invoke(dname, "save", new Object[0], new String[0]);
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)"save"), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)"save"));
            return null;
        }
        return mapping.findForward("Users List Setup");
    }
}

