/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.regexp.RegexpMatcher;

public class RegexpMatcherFactory {
    protected RegexpMatcher createInstance(String className) throws BuildException {
        try {
            Class<?> implClass = Class.forName(className);
            return (RegexpMatcher)implClass.newInstance();
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    public RegexpMatcher newRegexpMatcher() throws BuildException {
        String systemDefault = System.getProperty("ant.regexp.matcherimpl");
        if (systemDefault != null) {
            return this.createInstance(systemDefault);
        }
        try {
            return this.createInstance("org.apache.tools.ant.util.regexp.JakartaOroMatcher");
        }
        catch (BuildException buildException) {
            try {
                return this.createInstance("org.apache.tools.ant.util.regexp.JakartaRegexpMatcher");
            }
            catch (BuildException buildException2) {
                throw new BuildException("No supported regular expression matcher found");
            }
        }
    }
}

