/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class ExecuteOn
extends ExecTask {
    protected Vector filesets = new Vector();
    private boolean parallel = false;
    protected String type = "file";
    protected Commandline.Marker srcFilePos = null;

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.filesets.size() == 0) {
            throw new BuildException("no filesets specified", this.location);
        }
    }

    public Commandline.Marker createSrcfile() {
        if (this.srcFilePos != null) {
            throw new BuildException(String.valueOf(this.taskType) + " doesn't support multiple srcfile elements.", this.location);
        }
        this.srcFilePos = this.cmdl.createMarker();
        return this.srcFilePos;
    }

    protected String[] getCommandline(String srcFile, File baseDir) {
        return this.getCommandline(new String[]{srcFile}, baseDir);
    }

    protected String[] getCommandline(String[] srcFiles, File baseDir) {
        String[] orig = this.cmdl.getCommandline();
        String[] result = new String[orig.length + srcFiles.length];
        int index = orig.length;
        if (this.srcFilePos != null) {
            index = this.srcFilePos.getPosition();
        }
        System.arraycopy(orig, 0, result, 0, index);
        int i = 0;
        while (i < srcFiles.length) {
            result[index + i] = new File(baseDir, srcFiles[i]).getAbsolutePath();
            ++i;
        }
        System.arraycopy(orig, index, result, index + srcFiles.length, orig.length - index);
        return result;
    }

    protected String[] getDirs(File basedir, DirectoryScanner ds) {
        return ds.getIncludedDirectories();
    }

    protected String[] getFiles(File basedir, DirectoryScanner ds) {
        return ds.getIncludedFiles();
    }

    protected void runExec(Execute exe) throws BuildException {
        try {
            try {
                int i = 0;
                while (i < this.filesets.size()) {
                    int j;
                    Object[] s;
                    Vector<Object> v = new Vector<Object>();
                    FileSet fs = (FileSet)this.filesets.elementAt(i);
                    File base = fs.getDir(this.project);
                    DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                    if (!"dir".equals(this.type)) {
                        s = this.getFiles(base, ds);
                        j = 0;
                        while (j < s.length) {
                            v.addElement(s[j]);
                            ++j;
                        }
                    }
                    if (!"file".equals(this.type)) {
                        s = this.getDirs(base, ds);
                        j = 0;
                        while (j < s.length) {
                            v.addElement(s[j]);
                            ++j;
                        }
                    }
                    s = new String[v.size()];
                    v.copyInto(s);
                    int err = -1;
                    if (this.parallel) {
                        String[] command = this.getCommandline((String[])s, base);
                        this.log("Executing " + Commandline.toString(command), 3);
                        exe.setCommandline(command);
                        err = exe.execute();
                        if (err != 0) {
                            if (this.failOnError) {
                                throw new BuildException("Exec returned: " + err, this.location);
                            }
                            this.log("Result: " + err, 0);
                        }
                    } else {
                        int j2 = 0;
                        while (j2 < s.length) {
                            String[] command = this.getCommandline((String)s[j2], base);
                            this.log("Executing " + Commandline.toString(command), 3);
                            exe.setCommandline(command);
                            err = exe.execute();
                            if (err != 0) {
                                if (this.failOnError) {
                                    throw new BuildException("Exec returned: " + err, this.location);
                                }
                                this.log("Result: " + err, 0);
                            }
                            ++j2;
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                throw new BuildException("Execute failed: " + e, e, this.location);
            }
            Object var3_13 = null;
            this.logFlush();
        }
        catch (Throwable throwable) {
            Object var3_14 = null;
            this.logFlush();
            throw throwable;
        }
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setType(FileDirBoth type) {
        this.type = type.getValue();
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"file", "dir", "both"};
        }
    }
}

