/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;

public class DefaultLogger
implements BuildLogger {
    private static int LEFT_COLUMN_SIZE = 12;
    protected PrintStream out;
    protected PrintStream err;
    protected int msgOutputLevel;
    private long startTime = System.currentTimeMillis();
    protected static String lSep = System.getProperty("line.separator");
    protected boolean emacsMode = false;

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        if (error == null) {
            this.out.println(String.valueOf(lSep) + "BUILD SUCCESSFUL");
        } else {
            this.err.println(String.valueOf(lSep) + "BUILD FAILED" + lSep);
            if (error instanceof BuildException) {
                this.err.println(error.toString());
                Throwable nested = ((BuildException)error).getException();
                if (nested != null) {
                    nested.printStackTrace(this.err);
                }
            } else {
                error.printStackTrace(this.err);
            }
        }
        this.out.println(String.valueOf(lSep) + "Total time: " + DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    protected static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        if (minutes > 0L) {
            return String.valueOf(Long.toString(minutes)) + " minute" + (minutes == 1L ? " " : "s ") + Long.toString(seconds % 60L) + " second" + (seconds % 60L == 1L ? "" : "s");
        }
        return String.valueOf(Long.toString(seconds)) + " second" + (seconds % 60L == 1L ? "" : "s");
    }

    public void messageLogged(BuildEvent event) {
        PrintStream logTo;
        PrintStream printStream = logTo = event.getPriority() == 0 ? this.err : this.out;
        if (event.getPriority() <= this.msgOutputLevel) {
            if (event.getTask() != null) {
                String name = event.getTask().getTaskName();
                if (!this.emacsMode) {
                    String msg = "[" + name + "] ";
                    int i = 0;
                    while (i < LEFT_COLUMN_SIZE - msg.length()) {
                        logTo.print(" ");
                        ++i;
                    }
                    logTo.print(msg);
                }
            }
            logTo.println(event.getMessage());
        }
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void setErrorPrintStream(PrintStream err) {
        this.err = err;
    }

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = output;
    }

    public void targetFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
        if (this.msgOutputLevel >= 2) {
            this.out.println(String.valueOf(lSep) + event.getTarget().getName() + ":");
        }
    }

    public void taskFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }
}

