/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    int cursor;
    int lastCursor;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    Rectangle bounds;
    int cursorOrientation = 0;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        for (int i = 1; i < this.rectangles.length; ++i) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) <= yMax) continue;
            yMax = rectBottom;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        for (int i = 0; i < rects.length; ++i) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.bounds.width != 0) {
                x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                width = rects[i].width * 100 / this.bounds.width;
            } else {
                width = 100;
            }
            if (this.bounds.height != 0) {
                y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                height = rects[i].height * 100 / this.bounds.height;
            } else {
                height = 100;
            }
            result[i] = new Rectangle(x, y, width, height);
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects) {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
        int window = OS.GDK_ROOT_PARENT();
        if (this.parent != null) {
            window = OS.GTK_WIDGET_WINDOW((int)this.parent.paintHandle());
        }
        if (window == 0) {
            return;
        }
        int gc = OS.gdk_gc_new((int)window);
        if (gc == 0) {
            return;
        }
        int colormap = OS.gdk_colormap_get_system();
        GdkColor color = new GdkColor();
        OS.gdk_color_white((int)colormap, (GdkColor)color);
        OS.gdk_gc_set_foreground((int)gc, (GdkColor)color);
        OS.gdk_gc_set_subwindow((int)gc, (int)1);
        OS.gdk_gc_set_function((int)gc, (int)2);
        for (int i = 0; i < rects.length; ++i) {
            Rectangle rect = rects[i];
            OS.gdk_draw_rectangle((int)window, (int)gc, (int)0, (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
        }
        OS.g_object_unref((int)gc);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        int length = 0;
        if (this.rectangles != null) {
            length = this.rectangles.length;
        }
        Rectangle[] result = new Rectangle[length];
        for (int i = 0; i < length; ++i) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        for (int i = 0; i < this.rectangles.length; ++i) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean open() {
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        window = OS.GDK_ROOT_PARENT();
        if (this.parent != null) {
            window = OS.GTK_WIDGET_WINDOW((int)this.parent.paintHandle());
        }
        if (window == 0) {
            return false;
        }
        cancelled = false;
        this.tracking = true;
        this.drawRectangles(this.rectangles);
        oldX = new int[1];
        oldY = new int[1];
        state = new int[1];
        OS.gdk_window_get_pointer((int)window, (int[])oldX, (int[])oldY, (int[])state);
        vStyle = this.style & 1152;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 147456) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        gdkEvent = new GdkEvent();
        keyEvent = new GdkEventKey();
        newX = new int[1];
        newY = new int[1];
        grabMask = 516;
        ptrGrabResult = OS.gdk_pointer_grab((int)window, (boolean)false, (int)grabMask, (int)window, (int)this.cursor, (int)0);
        this.lastCursor = this.cursor;
        while (this.tracking && (this.parent == null || !this.parent.isDisposed())) {
            while ((eventPtr = OS.gdk_event_get()) == 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception ex) {}
            }
            OS.memmove((GdkEvent)gdkEvent, (int)eventPtr, (int)GdkEvent.sizeof);
            eventType = gdkEvent.type;
            switch (eventType) {
                case 3: {
                    if (this.cursor != this.lastCursor) {
                        if (ptrGrabResult == 0) {
                            OS.gdk_pointer_ungrab((int)0);
                        }
                        ptrGrabResult = OS.gdk_pointer_grab((int)window, (boolean)false, (int)grabMask, (int)window, (int)this.cursor, (int)0);
                    }
                }
                case 7: {
                    OS.gdk_window_get_pointer((int)window, (int[])newX, (int[])newY, null);
                    if (oldX[0] == newX[0] && oldY[0] == newY[0]) ** GOTO lbl106
                    oldRectangles = this.rectangles;
                    rectsToErase = new Rectangle[this.rectangles.length];
                    for (i = 0; i < this.rectangles.length; ++i) {
                        current = this.rectangles[i];
                        rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                    }
                    event = new Event();
                    if (this.parent == null) {
                        event.x = newX[0];
                        event.y = newY[0];
                    } else {
                        screenCoord = this.display.map(this.parent, null, newX[0], newY[0]);
                        event.x = screenCoord.x;
                        event.y = screenCoord.y;
                    }
                    if ((this.style & 16) == 0) ** GOTO lbl84
                    this.resizeRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                    this.sendEvent(11, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl79
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl74
                    draw = true;
                    ** GOTO lbl80
lbl74:
                    // 2 sources

                    for (i = 0; i < length; ++i) {
                        if (this.rectangles[i].equals(rectsToErase[i])) continue;
                        draw = true;
                        ** GOTO lbl80
                    }
                    ** GOTO lbl80
lbl79:
                    // 1 sources

                    draw = true;
lbl80:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase);
                        this.drawRectangles(this.rectangles);
                    }
                    ** GOTO lbl104
lbl84:
                    // 1 sources

                    this.moveRectangles(newX[0] - oldX[0], newY[0] - oldY[0]);
                    this.sendEvent(10, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl100
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl95
                    draw = true;
                    ** GOTO lbl101
lbl95:
                    // 2 sources

                    for (i = 0; i < length; ++i) {
                        if (this.rectangles[i].equals(rectsToErase[i])) continue;
                        draw = true;
                        ** GOTO lbl101
                    }
                    ** GOTO lbl101
lbl100:
                    // 1 sources

                    draw = true;
lbl101:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase);
                        this.drawRectangles(this.rectangles);
                    }
lbl104:
                    // 4 sources

                    oldX[0] = newX[0];
                    oldY[0] = newY[0];
lbl106:
                    // 2 sources

                    this.tracking = eventType != 7;
                    break;
                }
                case 8: {
                    OS.memmove((GdkEventKey)keyEvent, (int)eventPtr, (int)GdkEventKey.sizeof);
                    stepSize = (keyEvent.state & 4) != 0 ? 1 : 9;
                    xChange = 0;
                    yChange = 0;
                    switch (keyEvent.keyval) {
                        case 65307: {
                            cancelled = true;
                        }
                        case 65293: {
                            this.tracking = false;
                            break;
                        }
                        case 65361: {
                            xChange = -stepSize;
                            break;
                        }
                        case 65363: {
                            xChange = stepSize;
                            break;
                        }
                        case 65362: {
                            yChange = -stepSize;
                            break;
                        }
                        case 65364: {
                            yChange = stepSize;
                        }
                    }
                    if (xChange == 0 && yChange == 0) break;
                    oldRectangles = this.rectangles;
                    rectsToErase = new Rectangle[this.rectangles.length];
                    for (i = 0; i < this.rectangles.length; ++i) {
                        current = this.rectangles[i];
                        rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                    }
                    event = new Event();
                    event.x = oldX[0] + xChange;
                    event.y = oldY[0] + yChange;
                    if ((this.style & 16) == 0) ** GOTO lbl162
                    this.resizeRectangles(xChange, yChange);
                    this.sendEvent(11, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl157
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl152
                    draw = true;
                    ** GOTO lbl158
lbl152:
                    // 2 sources

                    for (i = 0; i < length; ++i) {
                        if (this.rectangles[i].equals(rectsToErase[i])) continue;
                        draw = true;
                        ** GOTO lbl158
                    }
                    ** GOTO lbl158
lbl157:
                    // 1 sources

                    draw = true;
lbl158:
                    // 4 sources

                    if (!draw) break;
                    this.drawRectangles(rectsToErase);
                    this.drawRectangles(this.rectangles);
                    break;
lbl162:
                    // 1 sources

                    this.moveRectangles(xChange, yChange);
                    this.sendEvent(10, event);
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl178
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl173
                    draw = true;
                    ** GOTO lbl179
lbl173:
                    // 2 sources

                    for (i = 0; i < length; ++i) {
                        if (this.rectangles[i].equals(rectsToErase[i])) continue;
                        draw = true;
                        ** GOTO lbl179
                    }
                    ** GOTO lbl179
lbl178:
                    // 1 sources

                    draw = true;
lbl179:
                    // 4 sources

                    if (!draw) break;
                    this.drawRectangles(rectsToErase);
                    this.drawRectangles(this.rectangles);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    OS.gtk_main_do_event((int)eventPtr);
                }
            }
            OS.gdk_event_free((int)eventPtr);
        }
        if (!this.isDisposed()) {
            this.drawRectangles(this.rectangles);
        }
        if (ptrGrabResult == 0) {
            OS.gdk_pointer_ungrab((int)0);
        }
        return cancelled == false;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    for (i = 0; i < this.proportions.length; ++i) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                for (i = 0; i < this.proportions.length; ++i) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    for (i = 0; i < this.proportions.length; ++i) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                for (i = 0; i < this.proportions.length; ++i) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        for (int i2 = 0; i2 < this.rectangles.length; ++i2) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor value) {
        this.checkWidget();
        this.cursor = 0;
        if (value != null) {
            this.cursor = value.handle;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        for (int i = 0; i < length; ++i) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

