/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int bufferHandle;
    int tabs = 8;
    int lastEventTime = 0;
    boolean doubleClick;
    static final int INNER_BORDER = 2;
    static final int ITER_SIZEOF = OS.GtkTextIter_sizeof();
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    void createHandle(int index) {
        int window;
        this.state |= 0x28;
        int parentHandle = this.parent.parentingHandle();
        if ((this.style & 4) != 0) {
            this.handle = OS.gtk_entry_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)parentHandle, (int)this.handle);
            OS.gtk_editable_set_editable((int)this.handle, ((this.style & 8) == 0 ? 1 : 0) != 0);
            OS.gtk_entry_set_has_frame((int)this.handle, ((this.style & 0x800) != 0 ? 1 : 0) != 0);
            OS.gtk_entry_set_visibility((int)this.handle, ((this.style & 0x400000) == 0 ? 1 : 0) != 0);
            float alignment = 0.0f;
            if ((this.style & 0x1000000) != 0) {
                alignment = 0.5f;
            }
            if ((this.style & 0x20000) != 0) {
                alignment = 1.0f;
            }
            if (alignment > 0.0f) {
                OS.gtk_entry_set_alignment((int)this.handle, (float)alignment);
            }
        } else {
            this.fixedHandle = OS.gtk_fixed_new();
            if (this.fixedHandle == 0) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
            this.scrolledHandle = OS.gtk_scrolled_window_new((int)0, (int)0);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            this.handle = OS.gtk_text_view_new();
            if (this.handle == 0) {
                this.error(2);
            }
            this.bufferHandle = OS.gtk_text_view_get_buffer((int)this.handle);
            if (this.bufferHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
            OS.gtk_container_add((int)this.fixedHandle, (int)this.scrolledHandle);
            OS.gtk_container_add((int)this.scrolledHandle, (int)this.handle);
            OS.gtk_widget_show((int)this.fixedHandle);
            OS.gtk_widget_show((int)this.scrolledHandle);
            OS.gtk_text_view_set_editable((int)this.handle, ((this.style & 8) == 0 ? 1 : 0) != 0);
            if ((this.style & 0x40) != 0) {
                OS.gtk_text_view_set_wrap_mode((int)this.handle, (int)2);
            }
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy((int)this.scrolledHandle, (int)hsp, (int)vsp);
            if ((this.style & 0x800) != 0) {
                OS.gtk_scrolled_window_set_shadow_type((int)this.scrolledHandle, (int)3);
            }
            int just = 0;
            if ((this.style & 0x1000000) != 0) {
                just = 2;
            }
            if ((this.style & 0x20000) != 0) {
                just = 1;
            }
            OS.gtk_text_view_set_justification((int)this.handle, (int)just);
        }
        OS.gtk_widget_show((int)this.handle);
        if ((this.style & 2) != 0 && (window = OS.gtk_text_view_get_window((int)this.handle, (int)2)) != 0) {
            int mask = 12288;
            OS.gdk_window_set_events((int)window, (int)(OS.gdk_window_get_events((int)window) | mask));
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.doubleClick = true;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer, (int)buffer.length, (int[])new int[]{-1});
            OS.gtk_editable_set_position((int)this.handle, (int)-1);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_end_iter((int)this.bufferHandle, (byte[])position);
            OS.gtk_text_buffer_insert((int)this.bufferHandle, (byte[])position, (byte[])buffer, (int)buffer.length);
            OS.gtk_text_buffer_place_cursor((int)this.bufferHandle, (byte[])position);
            int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int position = OS.gtk_editable_get_position((int)this.handle);
            OS.gtk_editable_select_region((int)this.handle, (int)position, (int)position);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            int insertMark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound((int)this.bufferHandle);
            OS.gtk_text_buffer_get_iter_at_mark((int)this.bufferHandle, (byte[])position, (int)insertMark);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)selectionMark, (byte[])position);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)insertMark, (byte[])position);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int xborder = 0;
        int yborder = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        if ((this.style & 4) != 0) {
            int layout = OS.gtk_entry_get_layout((int)this.handle);
            OS.pango_layout_get_size((int)layout, (int[])w, (int[])h);
            if ((this.style & 0x800) != 0) {
                int style = OS.gtk_widget_get_style((int)this.handle);
                xborder += OS.gtk_style_get_xthickness((int)style);
                yborder += OS.gtk_style_get_ythickness((int)style);
            }
            xborder += 2;
            yborder += 2;
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds((int)this.bufferHandle, (byte[])start, (byte[])end);
            int text = OS.gtk_text_buffer_get_text((int)this.bufferHandle, (byte[])start, (byte[])end, (boolean)true);
            int layout = OS.gtk_widget_create_pango_layout((int)this.handle, (int)text);
            OS.g_free((int)text);
            OS.pango_layout_set_width((int)layout, (int)(wHint * 1024));
            OS.pango_layout_get_size((int)layout, (int[])w, (int[])h);
            OS.g_object_unref((int)layout);
            int borderWidth = OS.gtk_container_get_border_width((int)this.handle);
            xborder += borderWidth;
            yborder += borderWidth;
        }
        int[] property = new int[1];
        OS.gtk_widget_style_get((int)this.handle, (byte[])OS.interior_focus, (int[])property, (int)0);
        if (property[0] != 0) {
            OS.gtk_widget_style_get((int)this.handle, (byte[])OS.focus_line_width, (int[])property, (int)0);
            xborder += property[0];
            yborder += property[0];
        }
        int width = OS.PANGO_PIXELS((int)w[0]);
        int height = OS.PANGO_PIXELS((int)h[0]);
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        Rectangle trim = this.computeTrim(0, 0, width += 2 * xborder, height += 2 * yborder);
        return new Point(trim.width, trim.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_copy_clipboard((int)this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get((int)0);
            OS.gtk_text_buffer_copy_clipboard((int)this.bufferHandle, (int)clipboard);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_cut_clipboard((int)this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get((int)0);
            OS.gtk_text_buffer_cut_clipboard((int)this.bufferHandle, (int)clipboard, (boolean)OS.gtk_text_view_get_editable((int)this.handle));
        }
    }

    void deregister() {
        int imContext;
        super.deregister();
        if (this.bufferHandle != 0) {
            this.display.removeWidget(this.bufferHandle);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.removeWidget(imContext);
        }
    }

    boolean filterKey(int keyval, int event) {
        boolean isTab = keyval == 65289 || keyval == 65056;
        int time = OS.gdk_event_get_time((int)event);
        if (time != this.lastEventTime || isTab) {
            this.lastEventTime = time;
            int imContext = this.imContext();
            if (imContext != 0) {
                return OS.gtk_im_context_filter_keypress((int)imContext, (int)event);
            }
        }
        return false;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        byte[] position = new byte[ITER_SIZEOF];
        int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark((int)this.bufferHandle, (byte[])position, (int)mark);
        return OS.gtk_text_iter_get_line((byte[])position);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return new Point(0, 0);
        }
        byte[] position = new byte[ITER_SIZEOF];
        int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark((int)this.bufferHandle, (byte[])position, (int)mark);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_iter_location((int)this.handle, (byte[])position, (GdkRectangle)rect);
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_text_view_buffer_to_window_coords((int)this.handle, (int)2, (int)rect.x, (int)rect.y, (int[])x, (int[])y);
        return new Point(x[0], y[0]);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_position((int)this.handle);
        }
        byte[] position = new byte[ITER_SIZEOF];
        int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark((int)this.bufferHandle, (byte[])position, (int)mark);
        return OS.gtk_text_iter_get_offset((byte[])position);
    }

    public int getCharCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.getText().length();
        }
        return OS.gtk_text_buffer_get_char_count((int)this.bufferHandle);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !OS.gtk_entry_get_visibility((int)this.handle)) {
            return OS.gtk_entry_get_invisible_char((int)this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_editable((int)this.handle);
        }
        return OS.gtk_text_view_get_editable((int)this.handle);
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return OS.gtk_text_buffer_get_line_count((int)this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds((int)this.handle, (int[])start, (int[])end);
            return new Point(start[0], end[0]);
        }
        byte[] start = new byte[ITER_SIZEOF];
        byte[] end = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_selection_bounds((int)this.bufferHandle, (byte[])start, (byte[])end);
        return new Point(OS.gtk_text_iter_get_offset((byte[])start), OS.gtk_text_iter_get_offset((byte[])end));
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return Math.abs(selection.y - selection.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point selection = this.getSelection();
        return this.getText().substring(selection.x, selection.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int tabs) {
        byte[] buffer = Converter.wcsToMbcs(null, " ", true);
        int layout = OS.gtk_widget_create_pango_layout((int)this.handle, (byte[])buffer);
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size((int)layout, (int[])width, (int[])height);
        OS.g_object_unref((int)layout);
        return width[0] * tabs;
    }

    public String getText() {
        int address;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            address = OS.gtk_entry_get_text((int)this.handle);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds((int)this.bufferHandle, (byte[])start, (byte[])end);
            address = OS.gtk_text_buffer_get_text((int)this.bufferHandle, (byte[])start, (byte[])end, (boolean)true);
        }
        if (address == 0) {
            return "";
        }
        int length = OS.strlen((int)address);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)address, (int)length);
        if ((this.style & 2) != 0) {
            OS.g_free((int)address);
        }
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public String getText(int start, int end) {
        int length;
        int address;
        this.checkWidget();
        if (start > end || 0 > end) {
            return "";
        }
        start = Math.max(0, start);
        if ((this.style & 4) != 0) {
            address = OS.gtk_editable_get_chars((int)this.handle, (int)start, (int)(end + 1));
        } else {
            length = OS.gtk_text_buffer_get_char_count((int)this.bufferHandle);
            end = Math.min(end, length - 1);
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])startIter, (int)start);
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])endIter, (int)(end + 1));
            address = OS.gtk_text_buffer_get_text((int)this.bufferHandle, (byte[])startIter, (byte[])endIter, (boolean)true);
        }
        if (address == 0) {
            this.error(12);
        }
        length = OS.strlen((int)address);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)address, (int)length);
        OS.g_free((int)address);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int limit = OS.gtk_entry_get_max_length((int)this.handle);
        return limit == 0 ? 65535 : limit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect((int)this.handle, (GdkRectangle)rect);
        OS.gtk_text_view_get_line_at_y((int)this.handle, (byte[])position, (int)rect.y, null);
        return OS.gtk_text_iter_get_line((byte[])position);
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect((int)this.handle, (GdkRectangle)rect);
        int[] lineTop = new int[1];
        OS.gtk_text_view_get_line_at_y((int)this.handle, (byte[])position, (int)rect.y, (int[])lineTop);
        return lineTop[0];
    }

    int gtk_activate(int widget) {
        this.postEvent(14);
        return 0;
    }

    int gtk_button_press_event(int widget, int event) {
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
        if (!this.doubleClick) {
            switch (gdkEvent.type) {
                case 5: 
                case 6: {
                    return 1;
                }
            }
        }
        return result;
    }

    int gtk_changed(int widget) {
        this.sendEvent(24);
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if ((this.style & 4) != 0 && !OS.gtk_editable_get_editable((int)this.handle)) {
            return 0;
        }
        int length = OS.strlen((int)text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)text, (int)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        OS.g_signal_handlers_block_matched((int)imContext, (int)16, (int)0, (int)0, (int)0, (int)0, (int)6);
        int id = OS.g_signal_lookup((byte[])OS.commit, (int)OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name((int)imContext, (byte[])OS.commit, (int)text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name((int)imContext, (byte[])OS.commit, (byte[])buffer);
        }
        OS.g_signal_handlers_unblock_matched((int)imContext, (int)16, (int)0, (int)0, (int)0, (int)0, (int)6);
        OS.g_signal_handlers_block_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        return 0;
    }

    int gtk_delete_range(int widget, int iter1, int iter2) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        byte[] startIter = new byte[ITER_SIZEOF];
        byte[] endIter = new byte[ITER_SIZEOF];
        OS.memmove((byte[])startIter, (int)iter1, (int)startIter.length);
        OS.memmove((byte[])endIter, (int)iter2, (int)endIter.length);
        int start = OS.gtk_text_iter_get_offset((byte[])startIter);
        int end = OS.gtk_text_iter_get_offset((byte[])endIter);
        String newText = this.verifyText("", start, end);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name((int)this.bufferHandle, (byte[])OS.delete_range);
            return 0;
        }
        if (newText.length() > 0) {
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_signal_handlers_block_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)9);
            OS.gtk_text_buffer_delete((int)this.bufferHandle, (byte[])startIter, (byte[])endIter);
            OS.g_signal_handlers_unblock_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)9);
            OS.g_signal_handlers_unblock_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_signal_handlers_block_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
            OS.gtk_text_buffer_insert((int)this.bufferHandle, (byte[])startIter, (byte[])buffer, (int)buffer.length);
            OS.g_signal_handlers_unblock_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
            OS.g_signal_stop_emission_by_name((int)this.bufferHandle, (byte[])OS.delete_range);
        }
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        String newText = this.verifyText("", start_pos, end_pos);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.delete_text);
            return 0;
        }
        if (newText.length() > 0) {
            int[] pos = new int[]{end_pos};
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer, (int)buffer.length, (int[])pos);
            OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
            OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.gtk_editable_set_position((int)this.handle, (int)pos[0]);
        }
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if ((this.style & 4) != 0) {
            String newText;
            if (new_text == 0 || new_text_length == 0) {
                return 0;
            }
            byte[] buffer = new byte[new_text_length];
            OS.memmove((byte[])buffer, (int)new_text, (int)buffer.length);
            String oldText = new String(Converter.mbcsToWcs(null, buffer));
            int[] pos = new int[1];
            OS.memmove((int[])pos, (int)position, (int)4);
            if (pos[0] == -1) {
                pos[0] = this.getCharCount();
            }
            if ((newText = this.verifyText(oldText, pos[0], pos[0])) == null) {
                OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.insert_text);
                return 0;
            }
            if (newText != oldText) {
                byte[] buffer3 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
                OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer3, (int)buffer3.length, (int[])pos);
                OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
                OS.g_signal_stop_emission_by_name((int)this.handle, (byte[])OS.insert_text);
                OS.memmove((int)position, (int[])pos, (int)4);
                return 0;
            }
        } else {
            byte[] iter = new byte[ITER_SIZEOF];
            OS.memmove((byte[])iter, (int)new_text, (int)iter.length);
            int start = OS.gtk_text_iter_get_offset((byte[])iter);
            byte[] buffer = new byte[position];
            OS.memmove((byte[])buffer, (int)new_text_length, (int)buffer.length);
            String oldText = new String(Converter.mbcsToWcs(null, buffer));
            String newText = this.verifyText(oldText, start, start);
            if (newText == null) {
                OS.g_signal_stop_emission_by_name((int)this.bufferHandle, (byte[])OS.insert_text);
                return 0;
            }
            if (newText != oldText) {
                byte[] buffer1 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
                OS.gtk_text_buffer_insert((int)this.bufferHandle, (int)new_text, (byte[])buffer1, (int)buffer1.length);
                OS.g_signal_handlers_unblock_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
                OS.g_signal_stop_emission_by_name((int)this.bufferHandle, (byte[])OS.insert_text);
                return 0;
            }
        }
        return 0;
    }

    int gtk_popup_menu(int widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer((int)0, (int[])x, (int[])y, null);
        return this.showMenu(x[0], y[0]) ? 1 : 0;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc2 = this.display.windowProc2;
        int windowProc3 = this.display.windowProc3;
        int windowProc4 = this.display.windowProc4;
        int windowProc5 = this.display.windowProc5;
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_after((int)this.handle, (byte[])OS.changed, (int)windowProc2, (int)4);
            OS.g_signal_connect((int)this.handle, (byte[])OS.insert_text, (int)windowProc5, (int)19);
            OS.g_signal_connect((int)this.handle, (byte[])OS.delete_text, (int)windowProc4, (int)10);
            OS.g_signal_connect((int)this.handle, (byte[])OS.activate, (int)windowProc2, (int)1);
        } else {
            OS.g_signal_connect((int)this.bufferHandle, (byte[])OS.changed, (int)windowProc2, (int)4);
            OS.g_signal_connect((int)this.bufferHandle, (byte[])OS.insert_text, (int)windowProc5, (int)19);
            OS.g_signal_connect((int)this.bufferHandle, (byte[])OS.delete_range, (int)windowProc4, (int)9);
        }
        int imContext = this.imContext();
        if (imContext != 0) {
            OS.g_signal_connect((int)imContext, (byte[])OS.commit, (int)windowProc3, (int)6);
            int id = OS.g_signal_lookup((byte[])OS.commit, (int)OS.gtk_im_context_get_type());
            int mask = 17;
            OS.g_signal_handlers_block_matched((int)imContext, (int)mask, (int)id, (int)0, (int)0, (int)0, (int)this.handle);
        }
    }

    int imContext() {
        return (this.style & 4) != 0 ? OS.GTK_ENTRY_IM_CONTEXT((int)this.handle) : OS.GTK_TEXTVIEW_IM_CONTEXT((int)this.handle);
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds((int)this.handle, (int[])start, (int[])end);
            OS.gtk_editable_delete_selection((int)this.handle);
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer, (int)buffer.length, (int[])start);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            if (OS.gtk_text_buffer_get_selection_bounds((int)this.bufferHandle, (byte[])start, (byte[])end)) {
                OS.gtk_text_buffer_delete((int)this.bufferHandle, (byte[])start, (byte[])end);
            }
            OS.gtk_text_buffer_insert((int)this.bufferHandle, (byte[])start, (byte[])buffer, (int)buffer.length);
            OS.gtk_text_buffer_place_cursor((int)this.bufferHandle, (byte[])start);
            int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        }
    }

    int paintWindow() {
        if ((this.style & 4) != 0) {
            int window = super.paintWindow();
            int children = OS.gdk_window_get_children((int)window);
            if (children != 0) {
                window = OS.g_list_data((int)children);
            }
            OS.g_list_free((int)children);
            return window;
        }
        OS.gtk_widget_realize((int)this.handle);
        return OS.gtk_text_view_get_window((int)this.handle, (int)2);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_paste_clipboard((int)this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get((int)0);
            OS.gtk_text_buffer_paste_clipboard((int)this.bufferHandle, (int)clipboard, null, (boolean)OS.gtk_text_view_get_editable((int)this.handle));
        }
    }

    void register() {
        int imContext;
        super.register();
        if (this.bufferHandle != 0) {
            this.display.addWidget(this.bufferHandle, this);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_select_region((int)this.handle, (int)0, (int)-1);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])start, (int)0);
            OS.gtk_text_buffer_get_end_iter((int)this.bufferHandle, (byte[])end);
            int insertMark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound((int)this.bufferHandle);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)selectionMark, (byte[])start);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)insertMark, (byte[])end);
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base((int)this.handle, (int)0, (GdkColor)color);
    }

    void setCursor(int cursor) {
        int defaultCursor = 0;
        if (cursor == 0) {
            defaultCursor = OS.gdk_cursor_new((int)152);
        }
        super.setCursor(cursor != 0 ? cursor : defaultCursor);
        if (cursor == 0) {
            OS.gdk_cursor_destroy((int)defaultCursor);
        }
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_visibility((int)this.handle, (echo == '\u0000' ? 1 : 0) != 0);
            OS.gtk_entry_set_invisible_char((int)this.handle, (char)echo);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_editable((int)this.handle, (boolean)editable);
        } else {
            OS.gtk_text_view_set_editable((int)this.handle, (boolean)editable);
        }
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        this.setTabStops(this.tabs);
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_text((int)this.handle, (int)0, (GdkColor)color);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(int start) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_position((int)this.handle, (int)start);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])position, (int)start);
            OS.gtk_text_buffer_place_cursor((int)this.bufferHandle, (byte[])position);
            int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_position((int)this.handle, (int)start);
            OS.gtk_editable_select_region((int)this.handle, (int)start, (int)end);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])startIter, (int)start);
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])endIter, (int)end);
            int insertMark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound((int)this.bufferHandle);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)selectionMark, (byte[])startIter);
            OS.gtk_text_buffer_move_mark((int)this.bufferHandle, (int)insertMark, (byte[])endIter);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
        this.tabs = tabs;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int tabs) {
        if ((this.style & 4) != 0) {
            return;
        }
        int tabWidth = this.getTabWidth(tabs);
        int tabArray = OS.pango_tab_array_new((int)1, (boolean)false);
        OS.pango_tab_array_set_tab((int)tabArray, (int)0, (int)0, (int)tabWidth);
        OS.gtk_text_view_set_tabs((int)this.handle, (int)tabArray);
        OS.pango_tab_array_free((int)tabArray);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount())) == null) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)10);
            OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
            OS.gtk_editable_delete_text((int)this.handle, (int)0, (int)-1);
            int[] position = new int[1];
            OS.gtk_editable_insert_text((int)this.handle, (byte[])buffer, (int)buffer.length, (int[])position);
            OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)10);
            OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
            OS.gtk_editable_set_position((int)this.handle, (int)0);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            OS.g_signal_handlers_block_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_signal_handlers_block_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)9);
            OS.g_signal_handlers_block_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
            OS.gtk_text_buffer_set_text((int)this.bufferHandle, (byte[])buffer, (int)buffer.length);
            OS.g_signal_handlers_unblock_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)4);
            OS.g_signal_handlers_unblock_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)9);
            OS.g_signal_handlers_unblock_matched((int)this.bufferHandle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)19);
            OS.gtk_text_buffer_get_iter_at_offset((int)this.bufferHandle, (byte[])position, (int)0);
            OS.gtk_text_buffer_place_cursor((int)this.bufferHandle, (byte[])position);
            int mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        }
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_max_length((int)this.handle, (int)limit);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] position = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_line((int)this.bufferHandle, (byte[])position, (int)index);
        OS.gtk_text_view_scroll_to_iter((int)this.handle, (byte[])position, (double)0.0, (boolean)true, (double)0.0, (double)0.0);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int mark = OS.gtk_text_buffer_get_selection_bound((int)this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
        mark = OS.gtk_text_buffer_get_insert((int)this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen((int)this.handle, (int)mark);
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string((int)imContext, (int[])preeditString, null, null);
                if (preeditString[0] == 0) break;
                int length = OS.strlen((int)preeditString[0]);
                OS.g_free((int)preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    int traversalCode(int key, GdkEventKey event) {
        int bits = super.traversalCode(key, event);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 65289 && event != null) {
                boolean next;
                boolean bl = next = (event.state & 1) == 0;
                if (next && (event.state & 4) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    String verifyText(String string, int start, int end) {
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove((GdkEventKey)gdkEvent, (int)eventPtr, (int)GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            OS.gdk_event_free((int)eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

