/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if ((this.style & 0x100) != 0) {
            if (wHint == -1) {
                size.x = 2 * size.x;
            }
        } else if (hHint == -1) {
            size.y = 2 * size.y;
        }
        return size;
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.gtk_fixed_new();
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        int hAdjustment = OS.gtk_adjustment_new((double)0.0, (double)0.0, (double)100.0, (double)1.0, (double)10.0, (double)0.0);
        if (hAdjustment == 0) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? OS.gtk_hscale_new((int)hAdjustment) : OS.gtk_vscale_new((int)hAdjustment);
        if (this.handle == 0) {
            this.error(2);
        }
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        OS.gtk_widget_show((int)this.fixedHandle);
        OS.gtk_widget_show((int)this.handle);
        OS.gtk_scale_set_digits((int)this.handle, (int)0);
        OS.gtk_scale_set_draw_value((int)this.handle, (boolean)false);
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect((int)this.handle, (byte[])OS.value_changed, (int)this.display.windowProc2, (int)42);
    }

    public int getIncrement() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.page_increment;
    }

    public int getSelection() {
        this.checkWidget();
        int hAdjustment = OS.gtk_range_get_adjustment((int)this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove((GtkAdjustment)adjustment, (int)hAdjustment);
        return (int)adjustment.value;
    }

    int gtk_value_changed(int adjustment) {
        this.postEvent(13);
        return 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
        OS.gtk_range_set_increments((int)this.handle, (double)value, (double)this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = this.getMinimum();
        if (value <= minimum) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
        OS.gtk_range_set_range((int)this.handle, (double)minimum, (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int maximum = this.getMaximum();
        if (value >= maximum) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
        OS.gtk_range_set_range((int)this.handle, (double)value, (double)maximum);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
        OS.gtk_range_set_increments((int)this.handle, (double)this.getIncrement(), (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
        OS.gtk_range_set_value((int)this.handle, (double)value);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)42);
    }
}

