/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkFixed;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    public int embeddedHandle;
    int imHandle;
    int socketHandle;
    Layout layout;
    Control[] tabList;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    Control[] _getChildren() {
        int i;
        int parentHandle = this.parentingHandle();
        int list = OS.gtk_container_get_children((int)parentHandle);
        if (list == 0) {
            return new Control[0];
        }
        list = OS.g_list_reverse((int)list);
        int count = OS.g_list_length((int)list);
        Control[] children = new Control[count];
        int j = 0;
        for (i = 0; i < count; ++i) {
            Widget widget;
            int handle = OS.g_list_nth_data((int)list, (int)i);
            if (handle == 0 || (widget = this.display.getWidget(handle)) == null || widget == this || !(widget instanceof Control)) continue;
            children[j++] = (Control)widget;
        }
        OS.g_list_free((int)list);
        if (i == j) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            ++count;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            newList[index++] = this.tabList[i];
        }
        this.tabList = newList;
        return this.tabList;
    }

    protected void checkSubclass() {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.layout != null ? (wHint == -1 || hHint == -1 ? this.layout.computeSize(this, wHint, hHint, changed) : new Point(wHint, hHint)) : this.minimumSize();
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        for (int i = 0; i < list.length; ++i) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length == 0) continue;
            Control[] newResult = new Control[result.length + childList.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(childList, 0, newResult, result.length, childList.length);
            result = newResult;
        }
        return result;
    }

    void createHandle(int index) {
        this.state |= 0xA;
        boolean scrolled = (this.style & 0xB00) != 0;
        this.createHandle(index, this.parent.parentingHandle(), scrolled);
    }

    void createHandle(int index, int parentHandle, boolean scrolled) {
        int window;
        if (scrolled) {
            int hadj;
            this.fixedHandle = OS.gtk_fixed_new();
            if (this.fixedHandle == 0) {
                this.error(2);
            }
            OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
            int vadj = OS.gtk_adjustment_new((double)0.0, (double)0.0, (double)100.0, (double)1.0, (double)10.0, (double)10.0);
            if (vadj == 0) {
                this.error(2);
            }
            if ((hadj = OS.gtk_adjustment_new((double)0.0, (double)0.0, (double)100.0, (double)1.0, (double)10.0, (double)10.0)) == 0) {
                this.error(2);
            }
            this.scrolledHandle = OS.gtk_scrolled_window_new((int)hadj, (int)vadj);
            if (this.scrolledHandle == 0) {
                SWT.error(2);
            }
        }
        this.handle = OS.gtk_fixed_new();
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.handle, (boolean)true);
        OS.GTK_WIDGET_SET_FLAGS((int)this.handle, (int)2048);
        if ((this.style & 0x1000000) == 0 && (this.state & 2) != 0 && (this.style & 0x80000) == 0) {
            this.imHandle = OS.gtk_im_multicontext_new();
            if (this.imHandle == 0) {
                this.error(2);
            }
        }
        if (scrolled) {
            OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
            OS.gtk_container_add((int)this.fixedHandle, (int)this.scrolledHandle);
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.gtk_container_add((int)this.scrolledHandle, (int)this.handle);
            this.display.setWarnings(warnings);
            OS.gtk_widget_show((int)this.fixedHandle);
            OS.gtk_widget_show((int)this.scrolledHandle);
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy((int)this.scrolledHandle, (int)hsp, (int)vsp);
            if (this.hasBorder()) {
                OS.gtk_scrolled_window_set_shadow_type((int)this.scrolledHandle, (int)3);
            }
        } else {
            OS.gtk_container_add((int)parentHandle, (int)this.handle);
        }
        OS.gtk_widget_show((int)this.handle);
        if ((this.style & 0x1000000) != 0) {
            this.socketHandle = OS.gtk_socket_new();
            if (this.socketHandle == 0) {
                SWT.error(2);
            }
            OS.gtk_container_add((int)this.handle, (int)this.socketHandle);
            OS.gtk_widget_show((int)this.socketHandle);
            this.embeddedHandle = OS.gtk_socket_get_id((int)this.socketHandle);
        }
        if (this.imHandle != 0 && (window = OS.GTK_WIDGET_WINDOW((int)this.handle)) != 0) {
            OS.gtk_im_context_set_client_window((int)this.imHandle, (int)window);
        }
        if ((this.style & 0x100000) != 0) {
            OS.gtk_widget_set_redraw_on_allocate((int)this.handle, (boolean)false);
        }
    }

    void deregister() {
        super.deregister();
        if (this.socketHandle != 0) {
            this.display.removeWidget(this.socketHandle);
        }
    }

    void enableWidget(boolean enabled) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.enableWidget(enabled);
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length == 0) continue;
            Menu[] newResult = new Menu[result.length + menuList.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
            result = newResult;
        }
        return result;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i] != control) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            for (int i = 0; i < this.tabList.length; ++i) {
                if (this.tabList[i] == control) continue;
                newList[index++] = this.tabList[i];
            }
        }
        this.tabList = newList;
    }

    int focusHandle() {
        if (this.socketHandle != 0) {
            return this.socketHandle;
        }
        return super.focusHandle();
    }

    boolean forceFocus(int focusHandle) {
        if (this.socketHandle != 0) {
            OS.GTK_WIDGET_SET_FLAGS((int)focusHandle, (int)2048);
        }
        boolean result = super.forceFocus(focusHandle);
        if (this.socketHandle != 0) {
            OS.GTK_WIDGET_UNSET_FLAGS((int)focusHandle, (int)2048);
        }
        return result;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int list = OS.gtk_container_get_children((int)this.handle);
        if (list == 0) {
            return 0;
        }
        int count = OS.g_list_length((int)list);
        OS.g_list_free((int)list);
        return count;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isTabGroup()) continue;
                ++count;
            }
            tabList = new Control[count];
            int index = 0;
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isTabGroup()) continue;
                tabList[index++] = list[i];
            }
        }
        return tabList;
    }

    int gtk_button_press_event(int widget, int event) {
        int result = super.gtk_button_press_event(widget, event);
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove((GdkEventButton)gdkEvent, (int)event, (int)GdkEventButton.sizeof);
            if (gdkEvent.button == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
        }
        return result;
    }

    int gtk_expose_event(int widget, int eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if ((this.state & 2) == 0) {
            return super.gtk_expose_event(widget, eventPtr);
        }
        if ((this.style & 0x200000) == 0) {
            return super.gtk_expose_event(widget, eventPtr);
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove((GdkEventExpose)gdkEvent, (int)eventPtr, (int)GdkEventExpose.sizeof);
        int[] rectangles = new int[1];
        int[] n_rectangles = new int[1];
        OS.gdk_region_get_rectangles((int)gdkEvent.region, (int[])rectangles, (int[])n_rectangles);
        GdkRectangle rect = new GdkRectangle();
        for (int i = 0; i < n_rectangles[0]; ++i) {
            Event event = new Event();
            OS.memmove((GdkRectangle)rect, (int)(rectangles[0] + i * GdkRectangle.sizeof), (int)GdkRectangle.sizeof);
            event.x = rect.x;
            event.y = rect.y;
            event.width = rect.width;
            event.height = rect.height;
            GC gc = event.gc = new GC(this);
            gc.setClipping(event.x, event.y, event.width, event.height);
            this.sendEvent(9, event);
            gc.dispose();
            event.gc = null;
        }
        OS.g_free((int)rectangles[0]);
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.state & 2) != 0) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove((GdkEventKey)keyEvent, (int)event, (int)GdkEventKey.sizeof);
            int key = keyEvent.keyval;
            switch (key) {
                case 65293: 
                case 65421: {
                    return 1;
                }
            }
        }
        return result;
    }

    int gtk_focus(int widget, int directionType) {
        if (widget == this.socketHandle) {
            return 0;
        }
        return super.gtk_focus(widget, directionType);
    }

    int gtk_focus_in_event(int widget, int event) {
        int result = super.gtk_focus_in_event(widget, event);
        return (this.state & 2) != 0 ? 1 : result;
    }

    int gtk_focus_out_event(int widget, int event) {
        int result = super.gtk_focus_out_event(widget, event);
        return (this.state & 2) != 0 ? 1 : result;
    }

    int gtk_realize(int widget) {
        int window;
        int result = super.gtk_realize(widget);
        if ((this.style & 0x40000) != 0 && (window = OS.GTK_WIDGET_WINDOW((int)this.paintHandle())) != 0) {
            OS.gdk_window_set_back_pixmap((int)window, (int)0, (boolean)false);
        }
        return result;
    }

    int gtk_scroll_child(int widget, int scrollType, int horizontal) {
        OS.g_signal_stop_emission_by_name((int)widget, (byte[])OS.scroll_child);
        return 1;
    }

    int gtk_style_set(int widget, int previousStyle) {
        int window;
        if ((this.style & 0x40000) != 0 && (window = OS.GTK_WIDGET_WINDOW((int)this.paintHandle())) != 0) {
            OS.gdk_window_set_back_pixmap((int)window, (int)0, (boolean)false);
        }
        return 0;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            OS.gtk_widget_add_events((int)this.handle, (int)8);
            if (this.scrolledHandle != 0) {
                OS.g_signal_connect((int)this.scrolledHandle, (byte[])OS.scroll_child, (int)this.display.windowProc4, (int)30);
            }
            if ((this.style & 0x40000) != 0) {
                OS.g_signal_connect((int)this.handle, (byte[])OS.style_set, (int)this.display.windowProc3, (int)35);
            }
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    int imHandle() {
        return this.imHandle;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout.layout(this, changed);
    }

    void moveAbove(int child, int sibling) {
        if (child == sibling) {
            return;
        }
        int parentHandle = this.parentingHandle();
        GtkFixed fixed = new GtkFixed();
        OS.memmove((GtkFixed)fixed, (int)parentHandle);
        int children = fixed.children;
        if (children == 0) {
            return;
        }
        int[] data = new int[1];
        int[] widget = new int[1];
        int childData = 0;
        int childLink = 0;
        int siblingLink = 0;
        int temp = children;
        while (temp != 0) {
            OS.memmove((int[])data, (int)temp, (int)OS.PTR_SIZEOF);
            OS.memmove((int[])widget, (int)data[0], (int)OS.PTR_SIZEOF);
            if (child == widget[0]) {
                childLink = temp;
                childData = data[0];
            } else if (sibling == widget[0]) {
                siblingLink = temp;
            }
            if (childData != 0 && (sibling == 0 || siblingLink != 0)) break;
            temp = OS.g_list_next((int)temp);
        }
        children = OS.g_list_remove_link((int)children, (int)childLink);
        if (siblingLink == 0 || OS.g_list_next((int)siblingLink) == 0) {
            OS.g_list_free_1((int)childLink);
            children = OS.g_list_append((int)children, (int)childData);
        } else {
            temp = OS.g_list_next((int)siblingLink);
            OS.g_list_set_next((int)childLink, (int)temp);
            OS.g_list_set_previous((int)temp, (int)childLink);
            OS.g_list_set_previous((int)childLink, (int)siblingLink);
            OS.g_list_set_next((int)siblingLink, (int)childLink);
        }
        fixed.children = children;
        OS.memmove((int)parentHandle, (GtkFixed)fixed);
    }

    void moveBelow(int child, int sibling) {
        if (child == sibling) {
            return;
        }
        int parentHandle = this.parentingHandle();
        if (sibling == 0 && parentHandle == this.fixedHandle) {
            this.moveAbove(child, this.handle);
            return;
        }
        GtkFixed fixed = new GtkFixed();
        OS.memmove((GtkFixed)fixed, (int)parentHandle);
        int children = fixed.children;
        if (children == 0) {
            return;
        }
        int[] data = new int[1];
        int[] widget = new int[1];
        int childData = 0;
        int childLink = 0;
        int siblingLink = 0;
        int temp = children;
        while (temp != 0) {
            OS.memmove((int[])data, (int)temp, (int)OS.PTR_SIZEOF);
            OS.memmove((int[])widget, (int)data[0], (int)OS.PTR_SIZEOF);
            if (child == widget[0]) {
                childLink = temp;
                childData = data[0];
            } else if (sibling == widget[0]) {
                siblingLink = temp;
            }
            if (childData != 0 && (sibling == 0 || siblingLink != 0)) break;
            temp = OS.g_list_next((int)temp);
        }
        children = OS.g_list_remove_link((int)children, (int)childLink);
        if (siblingLink == 0 || OS.g_list_previous((int)siblingLink) == 0) {
            OS.g_list_free_1((int)childLink);
            children = OS.g_list_prepend((int)children, (int)childData);
        } else {
            temp = OS.g_list_previous((int)siblingLink);
            OS.g_list_set_previous((int)childLink, (int)temp);
            OS.g_list_set_next((int)temp, (int)childLink);
            OS.g_list_set_next((int)childLink, (int)siblingLink);
            OS.g_list_set_previous((int)siblingLink, (int)childLink);
        }
        fixed.children = children;
        OS.memmove((int)parentHandle, (GtkFixed)fixed);
    }

    Point minimumSize() {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        for (int i = 0; i < children.length; ++i) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
        }
        return new Point(width, height);
    }

    int parentingHandle() {
        if ((this.state & 2) != 0) {
            return this.handle;
        }
        return this.fixedHandle != 0 ? this.fixedHandle : this.handle;
    }

    void register() {
        super.register();
        if (this.socketHandle != 0) {
            this.display.addWidget(this.socketHandle, this);
        }
    }

    void releaseChildren() {
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child == null || child.isDisposed()) continue;
            child.releaseResources();
        }
    }

    void releaseWidget() {
        this.releaseChildren();
        super.releaseWidget();
        if (this.imHandle != 0) {
            OS.g_object_unref((int)this.imHandle);
        }
        this.imHandle = 0;
        this.layout = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void resizeHandle(int width, int height) {
        super.resizeHandle(width, height);
        if (this.socketHandle != 0) {
            OS.gtk_widget_set_size_request((int)this.socketHandle, (int)width, (int)height);
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize && this.layout != null) {
            this.layout.layout(this, false);
        }
        return changed;
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (!child.getVisible() || !child.setFocus()) continue;
            return true;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    boolean setTabGroupFocus(boolean next) {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus(next);
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (this.socketHandle != 0) {
            takeFocus = true;
        }
        if (takeFocus && this.setTabItemFocus(next)) {
            return true;
        }
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (!child.isTabItem() || !child.setTabItemFocus(next)) continue;
            return true;
        }
        return false;
    }

    boolean setTabItemFocus(boolean next) {
        if (!super.setTabItemFocus(next)) {
            return false;
        }
        if (this.socketHandle != 0) {
            int direction = next ? 0 : 1;
            OS.GTK_WIDGET_UNSET_FLAGS((int)this.socketHandle, (int)4096);
            OS.gtk_widget_child_focus((int)this.socketHandle, (int)direction);
            OS.GTK_WIDGET_SET_FLAGS((int)this.socketHandle, (int)4096);
        }
        return true;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent == this) continue;
                this.error(32);
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control child = children[i];
                if (!child.translateMnemonic(event, control)) continue;
                return true;
            }
        }
        return false;
    }

    int traversalCode(int key, GdkEventKey event) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, event);
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        if (this.socketHandle != 0) {
            return false;
        }
        return super.translateTraversal(keyEvent);
    }
}

