/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gnome.GNOME;
import org.eclipse.swt.internal.gnome.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name;
    String command;
    ImageData imageData;
    Display display;
    boolean gnomeExpectUri;
    static final String DESKTOP_DATA = "Program_DESKTOP";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_KDE = 1;
    static final int DESKTOP_GNOME = 2;
    static final int PREFERRED_ICON_SIZE = 16;

    Program() {
    }

    static int getDesktop(Display display) {
        if (display == null) {
            return 0;
        }
        Integer desktopValue = (Integer)display.getData(DESKTOP_DATA);
        if (desktopValue != null) {
            return desktopValue;
        }
        int desktop = 0;
        if (Program.isGnomeDesktop() && Program.gnome_init()) {
            desktop = 2;
        }
        display.setData(DESKTOP_DATA, new Integer(desktop));
        return desktop;
    }

    public static Program findProgram(String extension) {
        return Program.findProgram(Display.getCurrent(), extension);
    }

    static Program findProgram(Display display, String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        String name = null;
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo(display);
        }
        if (mimeInfo == null) {
            return null;
        }
        Enumeration keys = mimeInfo.keys();
        block0: while (name == null && keys.hasMoreElements()) {
            String mimeType = (String)keys.nextElement();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            for (int index = 0; index < mimeExts.size(); ++index) {
                if (!extension.equals(mimeExts.elementAt(index))) continue;
                name = mimeType;
                continue block0;
            }
        }
        if (name == null) {
            return null;
        }
        Program program = null;
        if (desktop == 2) {
            program = Program.gnome_getProgram(display, name);
        }
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    static String[] getExtensions(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo(display);
        }
        if (mimeInfo == null) {
            return new String[0];
        }
        Vector extensions = new Vector();
        Enumeration keys = mimeInfo.keys();
        while (keys.hasMoreElements()) {
            String mimeType = (String)keys.nextElement();
            Vector mimeExts = (Vector)mimeInfo.get(mimeType);
            for (int index = 0; index < mimeExts.size(); ++index) {
                if (extensions.contains(mimeExts.elementAt(index))) continue;
                extensions.addElement(mimeExts.elementAt(index));
            }
        }
        String[] extStrings = new String[extensions.size()];
        for (int index = 0; index < extensions.size(); ++index) {
            extStrings[index] = (String)extensions.elementAt(index);
        }
        return extStrings;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    static Program[] getPrograms(Display display) {
        int desktop = Program.getDesktop(display);
        Hashtable mimeInfo = null;
        if (desktop == 2) {
            mimeInfo = Program.gnome_getMimeInfo(display);
        }
        if (mimeInfo == null) {
            return new Program[0];
        }
        Vector<Program> programs = new Vector<Program>();
        Enumeration keys = mimeInfo.keys();
        while (keys.hasMoreElements()) {
            String mimeType = (String)keys.nextElement();
            Program program = null;
            if (desktop == 2) {
                program = Program.gnome_getProgram(display, mimeType);
            }
            if (program == null) continue;
            programs.addElement(program);
        }
        Program[] programList = new Program[programs.size()];
        for (int index = 0; index < programList.length; ++index) {
            programList[index] = (Program)programs.elementAt(index);
        }
        return programList;
    }

    static Hashtable gnome_getMimeInfo(Display display) {
        int mimeList;
        Hashtable mimeInfo = new Hashtable();
        int[] mimeData = new int[1];
        int[] extensionData = new int[1];
        int mimeElement = mimeList = GNOME.gnome_vfs_get_registered_mime_types();
        while (mimeElement != 0) {
            OS.memmove((int[])mimeData, (int)mimeElement, (int)OS.PTR_SIZEOF);
            int mimePtr = mimeData[0];
            int mimeLength = OS.strlen((int)mimePtr);
            byte[] mimeTypeBuffer = new byte[mimeLength];
            OS.memmove((byte[])mimeTypeBuffer, (int)mimePtr, (int)mimeLength);
            String mimeType = new String(Converter.mbcsToWcs(null, mimeTypeBuffer));
            int extensionList = GNOME.gnome_vfs_mime_get_extensions_list((int)mimePtr);
            if (extensionList != 0) {
                Vector<String> extensions = new Vector<String>();
                int extensionElement = extensionList;
                while (extensionElement != 0) {
                    OS.memmove((int[])extensionData, (int)extensionElement, (int)OS.PTR_SIZEOF);
                    int extensionPtr = extensionData[0];
                    int extensionLength = OS.strlen((int)extensionPtr);
                    byte[] extensionBuffer = new byte[extensionLength];
                    OS.memmove((byte[])extensionBuffer, (int)extensionPtr, (int)extensionLength);
                    String extension = new String(Converter.mbcsToWcs(null, extensionBuffer));
                    extension = '.' + extension;
                    extensions.addElement(extension);
                    extensionElement = GNOME.g_list_next((int)extensionElement);
                }
                GNOME.gnome_vfs_mime_extensions_list_free((int)extensionList);
                if (extensions.size() > 0) {
                    mimeInfo.put(mimeType, extensions);
                }
            }
            mimeElement = GNOME.g_list_next((int)mimeElement);
        }
        if (mimeList != 0) {
            GNOME.gnome_vfs_mime_registered_mime_type_list_free((int)mimeList);
        }
        return mimeInfo;
    }

    static Program gnome_getProgram(Display display, String mimeType) {
        Program program = null;
        GnomeVFSMimeApplication application = new GnomeVFSMimeApplication();
        byte[] mimeTypeBuffer = Converter.wcsToMbcs(null, mimeType, true);
        int ptr = GNOME.gnome_vfs_mime_get_default_application((byte[])mimeTypeBuffer);
        if (ptr != 0) {
            program = new Program();
            program.display = display;
            program.name = mimeType;
            GNOME.memmove((GnomeVFSMimeApplication)application, (int)ptr, (int)GnomeVFSMimeApplication.sizeof);
            int length = OS.strlen((int)application.command);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)application.command, (int)length);
            program.command = new String(Converter.mbcsToWcs(null, buffer));
            program.gnomeExpectUri = application.expects_uris == 0;
            length = OS.strlen((int)application.id);
            buffer = new byte[length + 1];
            OS.memmove((byte[])buffer, (int)application.id, (int)length);
            int icon_theme = GNOME.gnome_icon_theme_new();
            int icon_name = GNOME.gnome_icon_lookup((int)icon_theme, (int)0, null, (byte[])buffer, (int)0, (byte[])mimeTypeBuffer, (int)0, null);
            int path = 0;
            if (icon_name != 0) {
                path = GNOME.gnome_icon_theme_lookup_icon((int)icon_theme, (int)icon_name, (int)16, null, null);
            }
            GNOME.g_object_unref((int)icon_theme);
            if (path != 0) {
                length = OS.strlen((int)path);
                if (length > 0) {
                    buffer = new byte[length];
                    OS.memmove((byte[])buffer, (int)path, (int)length);
                    String result = new String(Converter.mbcsToWcs(null, buffer));
                    try {
                        program.imageData = new ImageData(result);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                GNOME.g_free((int)icon_name);
                GNOME.g_free((int)path);
            }
            GNOME.gnome_vfs_mime_application_free((int)ptr);
        }
        return program;
    }

    static boolean gnome_init() {
        try {
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean isGnomeDesktop() {
        byte[] name = Converter.wcsToMbcs(null, "_WIN_SUPPORTING_WM_CHECK", true);
        int atom = OS.gdk_atom_intern((byte[])name, (boolean)true);
        if (atom == 0) {
            return false;
        }
        int[] actualType = new int[1];
        int[] actualFormat = new int[1];
        int[] actualLength = new int[1];
        int[] data = new int[1];
        if (!OS.gdk_property_get((int)OS.GDK_ROOT_PARENT(), (int)atom, (int)6, (int)0, (int)1, (int)0, (int[])actualType, (int[])actualFormat, (int[])actualLength, (int[])data)) {
            return false;
        }
        if (data[0] != 0) {
            OS.g_free((int)data[0]);
        }
        return actualLength[0] > 0;
    }

    public static boolean launch(String fileName) {
        return Program.launch(Display.getCurrent(), fileName);
    }

    static boolean launch(Display display, String fileName) {
        String extension;
        Program program;
        int index;
        if (fileName == null) {
            SWT.error(4);
        }
        if ((index = fileName.lastIndexOf(46)) > 0 && (program = Program.findProgram(display, extension = fileName.substring(index))) != null && program.execute(fileName)) {
            return true;
        }
        try {
            Compatibility.exec(fileName);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static String[] parseCommand(String cmd) {
        Vector<String> args = new Vector<String>();
        int sIndex = 0;
        while (sIndex < cmd.length()) {
            int eIndex;
            while (sIndex < cmd.length() && Compatibility.isWhitespace(cmd.charAt(sIndex))) {
                ++sIndex;
            }
            if (sIndex >= cmd.length()) continue;
            if (cmd.charAt(sIndex) == '\"' || cmd.charAt(sIndex) == '\'') {
                for (eIndex = sIndex + 1; eIndex < cmd.length() && cmd.charAt(eIndex) != cmd.charAt(sIndex); ++eIndex) {
                }
                if (eIndex >= cmd.length()) {
                    args.addElement(cmd.substring(sIndex, eIndex));
                } else {
                    args.addElement(cmd.substring(sIndex + 1, eIndex));
                }
                sIndex = eIndex + 1;
                continue;
            }
            for (eIndex = sIndex; eIndex < cmd.length() && !Compatibility.isWhitespace(cmd.charAt(eIndex)); ++eIndex) {
            }
            args.addElement(cmd.substring(sIndex, eIndex));
            sIndex = eIndex + 1;
        }
        String[] strings = new String[args.size()];
        for (int index = 0; index < args.size(); ++index) {
            strings[index] = (String)args.elementAt(index);
        }
        return strings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command);
        }
        return false;
    }

    public boolean execute(String fileName) {
        int desktop;
        if (fileName == null) {
            SWT.error(4);
        }
        if ((desktop = Program.getDesktop(this.display)) == 2) {
            int index;
            if (this.gnomeExpectUri) {
                fileName = "file://" + fileName;
            }
            String[] args = Program.parseCommand(this.command);
            int fileArg = -1;
            for (index = 0; index < args.length; ++index) {
                int j = args[index].indexOf("%f");
                if (j == -1) continue;
                String value = args[index];
                fileArg = index;
                args[index] = value.substring(0, j) + fileName + value.substring(j + 2);
            }
            if (fileName.length() > 0 && fileArg < 0) {
                String[] newArgs = new String[args.length + 1];
                for (index = 0; index < args.length; ++index) {
                    newArgs[index] = args[index];
                }
                newArgs[args.length] = fileName;
                args = newArgs;
            }
            try {
                Compatibility.exec(args);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

