/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
implements Drawable {
    public int type;
    public int pixmap;
    public int mask;
    Device device;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
    }

    public Image(Device device, int width, int height) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, width, height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image srcImage, int flag) {
        int pixmap;
        int gdkGC;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.device = device;
        this.type = srcImage.type;
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size((int)srcImage.pixmap, (int[])w, (int[])h);
        int width = w[0];
        int height = h[0];
        if (srcImage.mask != 0 || srcImage.transparentPixel != -1) {
            int mask;
            if (srcImage.transparentPixel != -1) {
                srcImage.createMask();
            }
            if ((mask = OS.gdk_pixmap_new((int)0, (int)width, (int)height, (int)1)) == 0) {
                SWT.error(2);
            }
            if ((gdkGC = OS.gdk_gc_new((int)mask)) == 0) {
                SWT.error(2);
            }
            OS.gdk_draw_drawable((int)mask, (int)gdkGC, (int)srcImage.mask, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height);
            OS.g_object_unref((int)gdkGC);
            this.mask = mask;
            if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
                srcImage.destroyMask();
            }
        }
        if (flag != 1) {
            this.transparentPixel = srcImage.transparentPixel;
            this.alpha = srcImage.alpha;
            if (srcImage.alphaData != null) {
                this.alphaData = new byte[srcImage.alphaData.length];
                System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
        }
        if ((pixmap = OS.gdk_pixmap_new((int)OS.GDK_ROOT_PARENT(), (int)width, (int)height, (int)-1)) == 0) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new((int)pixmap)) == 0) {
            SWT.error(2);
        }
        this.pixmap = pixmap;
        if (flag == 0) {
            OS.gdk_draw_drawable((int)pixmap, (int)gdkGC, (int)srcImage.pixmap, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height);
            OS.g_object_unref((int)gdkGC);
            if (device.tracking) {
                device.new_Object(this);
            }
            return;
        }
        int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)false, (int)8, (int)width, (int)height);
        if (pixbuf == 0) {
            SWT.error(2);
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)srcImage.pixmap, (int)colormap, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height);
        int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
        switch (flag) {
            case 1: {
                Color zeroColor = device.getSystemColor(18);
                RGB zeroRGB = zeroColor.getRGB();
                byte zeroRed = (byte)zeroRGB.red;
                byte zeroGreen = (byte)zeroRGB.green;
                byte zeroBlue = (byte)zeroRGB.blue;
                Color oneColor = device.getSystemColor(22);
                RGB oneRGB = oneColor.getRGB();
                byte oneRed = (byte)oneRGB.red;
                byte oneGreen = (byte)oneRGB.green;
                byte oneBlue = (byte)oneRGB.blue;
                byte[] line = new byte[stride];
                for (int y = 0; y < height; ++y) {
                    OS.memmove((byte[])line, (int)(pixels + y * stride), (int)stride);
                    for (int x = 0; x < width; ++x) {
                        int offset = x * 3;
                        int red = line[offset] & 0xFF;
                        int green = line[offset + 1] & 0xFF;
                        int blue = line[offset + 2] & 0xFF;
                        int intensity = red * red + green * green + blue * blue;
                        if (intensity < 98304) {
                            line[offset] = zeroRed;
                            line[offset + 1] = zeroGreen;
                            line[offset + 2] = zeroBlue;
                            continue;
                        }
                        line[offset] = oneRed;
                        line[offset + 1] = oneGreen;
                        line[offset + 2] = oneBlue;
                    }
                    OS.memmove((int)(pixels + y * stride), (byte[])line, (int)stride);
                }
                break;
            }
            case 2: {
                byte[] line = new byte[stride];
                for (int y = 0; y < height; ++y) {
                    OS.memmove((byte[])line, (int)(pixels + y * stride), (int)stride);
                    for (int x = 0; x < width; ++x) {
                        byte intensity;
                        int offset = x * 3;
                        int red = line[offset] & 0xFF;
                        int green = line[offset + 1] & 0xFF;
                        int blue = line[offset + 2] & 0xFF;
                        byte by = intensity = (byte)(red + red + green + green + green + green + green + blue >> 3);
                        line[offset + 2] = by;
                        line[offset + 1] = by;
                        line[offset] = by;
                    }
                    OS.memmove((int)(pixels + y * stride), (byte[])line, (int)stride);
                }
                this.transparentPixel = srcImage.transparentPixel;
                this.alpha = srcImage.alpha;
                if (srcImage.alphaData == null) break;
                this.alphaData = new byte[srcImage.alphaData.length];
                System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                break;
            }
        }
        OS.gdk_pixbuf_render_to_drawable((int)pixbuf, (int)pixmap, (int)gdkGC, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height, (int)1, (int)0, (int)0);
        OS.g_object_unref((int)pixbuf);
        OS.g_object_unref((int)gdkGC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Rectangle bounds) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(device, bounds.width, bounds.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData data) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, data);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData source, ImageData mask) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        if (mask.depth != 1) {
            SWT.error(5);
        }
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(device, image);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream stream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(stream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String filename) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(filename));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void createMask() {
        if (this.mask != 0) {
            return;
        }
        this.mask = this.createMask(this.getImageData(), false);
        if (this.mask == 0) {
            SWT.error(2);
        }
    }

    int createMask(ImageData image, boolean copy) {
        ImageData mask = image.getTransparencyMask();
        byte[] data = mask.data;
        byte[] maskData = copy ? new byte[data.length] : data;
        for (int i = 0; i < maskData.length; ++i) {
            byte s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        return OS.gdk_bitmap_create_from_data((int)0, (byte[])maskData, (int)mask.width, (int)mask.height);
    }

    void destroyMask() {
        if (this.mask == 0) {
            return;
        }
        OS.g_object_unref((int)this.mask);
        this.mask = 0;
    }

    public void dispose() {
        if (this.pixmap == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.pixmap != 0) {
            OS.g_object_unref((int)this.pixmap);
        }
        if (this.mask != 0) {
            OS.g_object_unref((int)this.mask);
        }
        this.mask = 0;
        this.pixmap = 0;
        this.memGC = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.gdk_drawable_get_size((int)this.pixmap, (int[])width, (int[])height);
        return new Rectangle(0, 0, width[0], height[0]);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size((int)this.pixmap, (int[])w, (int[])h);
        int width = w[0];
        int height = h[0];
        int pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)false, (int)8, (int)width, (int)height);
        if (pixbuf == 0) {
            SWT.error(2);
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable((int)pixbuf, (int)this.pixmap, (int)colormap, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height);
        int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels((int)pixbuf);
        byte[] srcData = new byte[stride * height];
        OS.memmove((byte[])srcData, (int)pixels, (int)srcData.length);
        OS.g_object_unref((int)pixbuf);
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(width, height, 24, palette);
        data.data = srcData;
        data.bytesPerLine = stride;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0) {
            int bpl;
            int maskPad;
            int gdkImagePtr = OS.gdk_drawable_get_image((int)this.mask, (int)0, (int)0, (int)width, (int)height);
            if (gdkImagePtr == 0) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove((GdkImage)gdkImage, (int)gdkImagePtr);
            byte[] maskData = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove((byte[])maskData, (int)gdkImage.mem, (int)maskData.length);
            OS.g_object_unref((int)gdkImagePtr);
            for (maskPad = 1; maskPad < 128 && gdkImage.bpl != (bpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad); ++maskPad) {
            }
            data.maskPad = 2;
            maskData = ImageData.convertPad(maskData, width, height, 1, maskPad, data.maskPad);
            if (gdkImage.byte_order == 0) {
                for (int i = 0; i < maskData.length; ++i) {
                    byte b = maskData[i];
                    maskData[i] = (byte)((b & 1) << 7 | (b & 2) << 5 | (b & 4) << 3 | (b & 8) << 1 | (b & 0x10) >> 1 | (b & 0x20) >> 3 | (b & 0x40) >> 5 | (b & 0x80) >> 7);
                }
            }
            data.maskData = maskData;
        }
        data.transparentPixel = this.transparentPixel;
        data.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            data.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, data.alphaData, 0, this.alphaData.length);
        }
        return data;
    }

    public static Image gtk_new(Device device, int type, int pixmap, int mask) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.type = type;
        image.pixmap = pixmap;
        image.mask = mask;
        image.device = device;
        return image;
    }

    public int hashCode() {
        return this.pixmap;
    }

    void init(Device device, int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        this.pixmap = OS.gdk_pixmap_new((int)OS.GDK_ROOT_PARENT(), (int)width, (int)height, (int)-1);
        if (this.pixmap == 0) {
            SWT.error(2);
        }
        GdkColor white = new GdkColor();
        white.red = (short)-1;
        white.green = (short)-1;
        white.blue = (short)-1;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color((int)colormap, (GdkColor)white, (boolean)true, (boolean)true);
        int gdkGC = OS.gdk_gc_new((int)this.pixmap);
        OS.gdk_gc_set_foreground((int)gdkGC, (GdkColor)white);
        OS.gdk_draw_rectangle((int)this.pixmap, (int)gdkGC, (int)1, (int)0, (int)0, (int)width, (int)height);
        OS.g_object_unref((int)gdkGC);
        OS.gdk_colormap_free_colors((int)colormap, (GdkColor)white, (int)1);
    }

    void init(Device device, ImageData image) {
        boolean isIcon;
        int gdkGC;
        int pixbuf;
        if (image == null) {
            SWT.error(4);
        }
        this.device = device;
        int width = image.width;
        int height = image.height;
        PaletteData palette = image.palette;
        if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        if ((pixbuf = OS.gdk_pixbuf_new((int)0, (boolean)false, (int)8, (int)width, (int)height)) == 0) {
            SWT.error(2);
        }
        int stride = OS.gdk_pixbuf_get_rowstride((int)pixbuf);
        int data = OS.gdk_pixbuf_get_pixels((int)pixbuf);
        byte[] buffer = image.data;
        if (!palette.isDirect || image.depth != 24 || stride != image.bytesPerLine || palette.redMask != 0xFF0000 || palette.greenMask != 65280 || palette.blueMask != 255) {
            buffer = new byte[stride * height];
            if (palette.isDirect) {
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 24, stride, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                for (int i = 0; i < rgbs.length; ++i) {
                    RGB rgb = rgbs[i];
                    if (rgb == null) continue;
                    srcReds[i] = (byte)rgb.red;
                    srcGreens[i] = (byte)rgb.green;
                    srcBlues[i] = (byte)rgb.blue;
                }
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 24, stride, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
            }
        }
        OS.memmove((int)data, (byte[])buffer, (int)buffer.length);
        int pixmap = OS.gdk_pixmap_new((int)OS.GDK_ROOT_PARENT(), (int)width, (int)height, (int)-1);
        if (pixmap == 0) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new((int)pixmap)) == 0) {
            SWT.error(2);
        }
        OS.gdk_pixbuf_render_to_drawable((int)pixbuf, (int)pixmap, (int)gdkGC, (int)0, (int)0, (int)0, (int)0, (int)width, (int)height, (int)1, (int)0, (int)0);
        OS.g_object_unref((int)gdkGC);
        OS.g_object_unref((int)pixbuf);
        boolean bl = isIcon = image.getTransparencyType() == 2;
        if (isIcon || image.transparentPixel != -1) {
            int mask;
            if (image.transparentPixel != -1) {
                RGB rgb = null;
                if (palette.isDirect) {
                    rgb = palette.getRGB(image.transparentPixel);
                } else if (image.transparentPixel < palette.colors.length) {
                    rgb = palette.getRGB(image.transparentPixel);
                }
                if (rgb != null) {
                    this.transparentPixel = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                }
            }
            if ((mask = this.createMask(image, isIcon)) == 0) {
                SWT.error(2);
            }
            this.mask = mask;
            this.type = isIcon ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0;
            this.alpha = image.alpha;
            if (image.alpha == -1 && image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
        }
        this.pixmap = pixmap;
    }

    public int internal_new_GC(GCData data) {
        if (this.pixmap == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int gdkGC = OS.gdk_gc_new((int)this.pixmap);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.drawable = this.pixmap;
            data.font = this.device.systemFont.handle;
            data.image = this;
        }
        return gdkGC;
    }

    public void internal_dispose_GC(int gdkGC, GCData data) {
        OS.g_object_unref((int)gdkGC);
    }

    public boolean isDisposed() {
        return this.pixmap == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

