/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class TableDragUnderEffect
extends DragUnderEffect {
    private Table table;
    private int currentEffect = 0;
    private TableItem scrollItem;
    private long scrollBeginTime;
    private static final int SCROLL_HYSTERESIS = 600;

    TableDragUnderEffect(Table table) {
        this.table = table;
    }

    void show(int effect, int x, int y) {
        TableItem item = this.findItem(x, y);
        if (item == null) {
            effect = 0;
        }
        this.scrollHover(effect, item, x, y);
        this.setDragUnderEffect(effect, item);
        this.currentEffect = effect;
    }

    private TableItem findItem(int x, int y) {
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        Rectangle area = this.table.getClientArea();
        if (!area.contains(coordinates)) {
            return null;
        }
        TableItem item = this.table.getItem(coordinates);
        if (item != null) {
            return item;
        }
        for (int x1 = area.x; x1 < area.x + area.width; ++x1) {
            Point pt = new Point(x1, coordinates.y);
            item = this.table.getItem(pt);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private void setDragUnderEffect(int effect, TableItem item) {
        if ((effect & 1) != 0) {
            this.setDropSelection(item);
            return;
        }
        if ((this.currentEffect & 1) != 0) {
            this.setDropSelection(null);
        }
    }

    private void setDropSelection(TableItem item) {
        if (item == null) {
            OS.gtk_tree_view_unset_rows_drag_dest((int)this.table.handle);
            return;
        }
        Rectangle rect = item.getBounds(0);
        int[] path = new int[1];
        if (!OS.gtk_tree_view_get_path_at_pos((int)this.table.handle, (int)rect.x, (int)rect.y, (int[])path, null, null, null)) {
            return;
        }
        if (path[0] == 0) {
            return;
        }
        OS.gtk_tree_view_set_drag_dest_row((int)this.table.handle, (int)path[0], (int)2);
        OS.gtk_tree_path_free((int)path[0]);
    }

    private void scrollHover(int effect, TableItem item, int x, int y) {
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
            return;
        }
        if (this.scrollItem == item && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                this.scroll(item, x, y);
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
            return;
        }
        this.scrollBeginTime = System.currentTimeMillis() + 600L;
        this.scrollItem = item;
    }

    private void scroll(TableItem item, int x, int y) {
        if (item == null) {
            return;
        }
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        Rectangle area = this.table.getClientArea();
        int top = this.table.getTopIndex();
        int newTop = -1;
        int scroll_width = 2 * this.table.getItemHeight();
        if (coordinates.y < area.y + scroll_width) {
            newTop = Math.max(0, top - 1);
        } else if (coordinates.y > area.y + area.height - scroll_width) {
            newTop = Math.min(this.table.getItemCount() - 1, top + 1);
        }
        if (newTop != -1 && newTop != top) {
            this.table.setTopIndex(newTop);
        }
    }
}

