/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private int targetList;
    private boolean moveData = false;
    private static final String DRAGSOURCEID = "DragSource";
    private static Callback DragGetData = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragGetData", 5);
    private static Callback DragEnd = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragEnd", 2);
    private static Callback DragDataDelete = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragDataDelete", 2);
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DragSource;

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (DragGetData == null || DragEnd == null || DragDataDelete == null) {
            DND.error(2000);
        }
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        byte[] buffer = Converter.wcsToMbcs(null, "drag_data_get", true);
        OS.g_signal_connect((int)control.handle, (byte[])buffer, (int)DragGetData.getAddress(), (int)0);
        buffer = Converter.wcsToMbcs(null, "drag_end", true);
        OS.g_signal_connect((int)control.handle, (byte[])buffer, (int)DragEnd.getAddress(), (int)0);
        buffer = Converter.wcsToMbcs(null, "drag_data_delete", true);
        OS.g_signal_connect((int)control.handle, (byte[])buffer, (int)DragDataDelete.getAddress(), (int)0);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    static int DragDataDelete(int widget, int context) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        source.dragDataDelete(widget, context);
        return 0;
    }

    static int DragEnd(int widget, int context) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        source.dragEnd(widget, context);
        return 0;
    }

    static int DragGetData(int widget, int context, int selection_data, int info, int time) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0;
        }
        source.dragGetData(widget, context, selection_data, info, time);
        return 0;
    }

    static DragSource FindDragSource(int handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData(DRAGSOURCEID);
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    private void drag(Event dragEvent) {
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = dragEvent.time;
        event.doit = true;
        try {
            this.notifyListeners(2008, event);
        }
        catch (Throwable e) {
            event.doit = false;
        }
        if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        if (this.targetList == 0) {
            return;
        }
        int actions = this.opToOsOp(this.getStyle());
        OS.gtk_drag_begin((int)this.control.handle, (int)this.targetList, (int)actions, (int)1, (int)0);
    }

    void dragEnd(int widget, int context) {
        OS.gdk_pointer_ungrab((int)0);
        OS.gdk_keyboard_ungrab((int)0);
        int operation = 0;
        if (context != 0) {
            GdkDragContext gdkDragContext = new GdkDragContext();
            OS.memmove((GdkDragContext)gdkDragContext, (int)context, (int)GdkDragContext.sizeof);
            if (gdkDragContext.dest_window != 0) {
                if (this.moveData) {
                    operation = 2;
                } else {
                    operation = this.osOpToOp(gdkDragContext.action);
                    if (operation == 2) {
                        operation = 0;
                    }
                }
            }
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.doit = operation != 0;
        event.detail = operation;
        try {
            this.notifyListeners(2000, event);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.moveData = false;
    }

    void dragGetData(int widget, int context, int selection_data, int info, int time) {
        if (selection_data == 0) {
            return;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove((GtkSelectionData)gtkSelectionData, (int)selection_data, (int)GtkSelectionData.sizeof);
        if (gtkSelectionData.target == 0) {
            return;
        }
        TransferData transferData = new TransferData();
        transferData.type = gtkSelectionData.target;
        transferData.pValue = gtkSelectionData.data;
        transferData.length = gtkSelectionData.length;
        transferData.format = gtkSelectionData.format;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = time;
        event.dataType = transferData;
        try {
            this.notifyListeners(2001, event);
        }
        catch (Throwable e) {
            return;
        }
        if (event.data == null) {
            return;
        }
        Transfer transfer = null;
        for (int i = 0; i < this.transferAgents.length; ++i) {
            if (!this.transferAgents[i].isSupportedType(transferData)) continue;
            transfer = this.transferAgents[i];
            break;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(event.data, transferData);
        if (transferData.result != 1) {
            return;
        }
        OS.gtk_selection_data_set((int)selection_data, (int)transferData.type, (int)transferData.format, (int)transferData.pValue, (int)transferData.length);
    }

    void dragDataDelete(int widget, int context) {
        this.moveData = true;
    }

    public Control getControl() {
        return this.control;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.targetList != 0) {
            OS.gtk_target_list_unref((int)this.targetList);
        }
        this.targetList = 0;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    private int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation |= 2;
        }
        if ((operation & 2) == 2) {
            osOperation |= 4;
        }
        if ((operation & 4) == 4) {
            osOperation |= 8;
        }
        return osOperation;
    }

    private int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 4) == 4) {
            operation |= 2;
        }
        if ((osOperation & 8) == 8) {
            operation |= 4;
        }
        return operation;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setTransfer(Transfer[] transferAgents) {
        int i;
        if (this.targetList != 0) {
            OS.gtk_target_list_unref((int)this.targetList);
            this.targetList = 0;
        }
        this.transferAgents = transferAgents;
        if (transferAgents == null || transferAgents.length == 0) {
            return;
        }
        GtkTargetEntry[] targets = new GtkTargetEntry[]{};
        for (int i2 = 0; i2 < transferAgents.length; ++i2) {
            Transfer transfer = transferAgents[i2];
            int[] typeIds = transfer.getTypeIds();
            String[] typeNames = transfer.getTypeNames();
            for (int j = 0; j < typeIds.length; ++j) {
                GtkTargetEntry entry = new GtkTargetEntry();
                byte[] buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                entry.target = OS.g_malloc((int)buffer.length);
                OS.memmove((int)entry.target, (byte[])buffer, (int)buffer.length);
                entry.info = typeIds[j];
                GtkTargetEntry[] newTargets = new GtkTargetEntry[targets.length + 1];
                System.arraycopy(targets, 0, newTargets, 0, targets.length);
                newTargets[targets.length] = entry;
                targets = newTargets;
            }
        }
        int pTargets = OS.g_malloc((int)(targets.length * GtkTargetEntry.sizeof));
        for (i = 0; i < targets.length; ++i) {
            OS.memmove((int)(pTargets + i * GtkTargetEntry.sizeof), (GtkTargetEntry)targets[i], (int)GtkTargetEntry.sizeof);
        }
        this.targetList = OS.gtk_target_list_new((int)pTargets, (int)targets.length);
        for (i = 0; i < targets.length; ++i) {
            OS.g_free((int)targets[i].target);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

