/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Object[] data;
    Transfer[] dataTypes;
    Display display;
    boolean onPrimary = false;
    boolean onClipboard = false;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy proxy = (ClipboardProxy)display.getData(ID);
        if (proxy != null) {
            return proxy;
        }
        proxy = new ClipboardProxy(display);
        display.setData(ID, proxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipbordProxy = (ClipboardProxy)display.getData(ID);
                if (clipbordProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipbordProxy.dispose();
            }
        });
        return proxy;
    }

    private ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        this.clearFunc = new Callback(this, "clearFunc", 2);
    }

    private int clearFunc(int clipboard, int user_data_or_owner) {
        if (clipboard == Clipboard.GTKCLIPBOARD) {
            this.onClipboard = false;
        }
        if (clipboard == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.onPrimary = false;
        }
        if (!this.onClipboard && !this.onPrimary) {
            this.data = null;
            this.dataTypes = null;
        }
        return 1;
    }

    private void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.onPrimary) {
            OS.gtk_clipboard_clear((int)Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.onPrimary = false;
        if (this.onClipboard) {
            OS.gtk_clipboard_clear((int)Clipboard.GTKCLIPBOARD);
        }
        this.onClipboard = false;
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.data = null;
        this.dataTypes = null;
    }

    private int getFunc(int clipboard, int selection_data, int info, int user_data_or_owner) {
        if (selection_data == 0) {
            return 0;
        }
        GtkSelectionData selectionData = new GtkSelectionData();
        OS.memmove((GtkSelectionData)selectionData, (int)selection_data, (int)GtkSelectionData.sizeof);
        TransferData tdata = new TransferData();
        tdata.type = selectionData.target;
        int index = -1;
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (!this.dataTypes[i].isSupportedType(tdata)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return 0;
        }
        this.dataTypes[index].javaToNative(this.data[index], tdata);
        if (tdata.format < 8 || tdata.format % 8 != 0) {
            return 0;
        }
        OS.gtk_selection_data_set((int)selection_data, (int)tdata.type, (int)tdata.format, (int)tdata.pValue, (int)tdata.length);
        return 1;
    }

    boolean setData(Object[] data, Transfer[] dataTypes) {
        int i;
        if (this.onClipboard) {
            OS.gtk_clipboard_clear((int)Clipboard.GTKCLIPBOARD);
        }
        if (this.onPrimary) {
            OS.gtk_clipboard_clear((int)Clipboard.GTKPRIMARYCLIPBOARD);
        }
        GtkTargetEntry[] entries = new GtkTargetEntry[]{};
        for (int i2 = 0; i2 < dataTypes.length; ++i2) {
            Transfer transfer = dataTypes[i2];
            int[] typeIds = transfer.getTypeIds();
            String[] typeNames = transfer.getTypeNames();
            for (int j = 0; j < typeIds.length; ++j) {
                GtkTargetEntry entry = new GtkTargetEntry();
                entry.info = typeIds[j];
                byte[] buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                int pName = OS.g_malloc((int)buffer.length);
                OS.memmove((int)pName, (byte[])buffer, (int)buffer.length);
                entry.target = pName;
                GtkTargetEntry[] tmp = new GtkTargetEntry[entries.length + 1];
                System.arraycopy(entries, 0, tmp, 0, entries.length);
                tmp[entries.length] = entry;
                entries = tmp;
            }
        }
        int pTargetsList = OS.g_malloc((int)(GtkTargetEntry.sizeof * entries.length));
        int offset = 0;
        for (i = 0; i < entries.length; ++i) {
            OS.memmove((int)(pTargetsList + offset), (GtkTargetEntry)entries[i], (int)GtkTargetEntry.sizeof);
            offset += GtkTargetEntry.sizeof;
        }
        this.data = data;
        this.dataTypes = dataTypes;
        this.onPrimary = OS.gtk_clipboard_set_with_data((int)Clipboard.GTKPRIMARYCLIPBOARD, (int)pTargetsList, (int)entries.length, (int)this.getFunc.getAddress(), (int)this.clearFunc.getAddress(), (int)0);
        this.onClipboard = OS.gtk_clipboard_set_with_data((int)Clipboard.GTKCLIPBOARD, (int)pTargetsList, (int)entries.length, (int)this.getFunc.getAddress(), (int)this.clearFunc.getAddress(), (int)0);
        for (i = 0; i < entries.length; ++i) {
            GtkTargetEntry entry = entries[i];
            if (entry.target == 0) continue;
            OS.g_free((int)entry.target);
        }
        if (pTargetsList != 0) {
            OS.g_free((int)pTargetsList);
        }
        return this.onClipboard && this.onPrimary;
    }
}

