/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static int GTKCLIPBOARD = OS.gtk_clipboard_get((int)0);
    static int GTKPRIMARYCLIPBOARD;
    private static int TARGET;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$Clipboard;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$Clipboard == null ? (class$org$eclipse$swt$dnd$Clipboard = Clipboard.class$("org.eclipse.swt.dnd.Clipboard")) : class$org$eclipse$swt$dnd$Clipboard).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        int i;
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        int selection_data = 0;
        int[] typeIds = transfer.getTypeIds();
        for (i = 0; i < typeIds.length && (selection_data = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, typeIds[i])) == 0; ++i) {
        }
        if (selection_data == 0) {
            for (i = 0; i < typeIds.length && (selection_data = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, typeIds[i])) == 0; ++i) {
            }
        }
        if (selection_data == 0) {
            return null;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove((GtkSelectionData)gtkSelectionData, (int)selection_data, (int)GtkSelectionData.sizeof);
        TransferData tdata = new TransferData();
        tdata.type = gtkSelectionData.target;
        tdata.pValue = gtkSelectionData.data;
        tdata.length = gtkSelectionData.length;
        tdata.format = gtkSelectionData.format;
        Object result = transfer.nativeToJava(tdata);
        OS.gtk_selection_data_free((int)selection_data);
        return result;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length) {
            DND.error(5);
        }
        if (dataTypes.length == 0) {
            return;
        }
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        if (!proxy.setData(data, dataTypes)) {
            DND.error(2002);
        }
    }

    public TransferData[] getAvailableTypes() {
        this.checkWidget();
        int[] types = this._getAvailableTypes();
        TransferData[] result = new TransferData[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = new TransferData();
            result[i].type = types[i];
        }
        return result;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        int[] types = this._getAvailableTypes();
        String[] result = new String[types.length];
        int count = 0;
        for (int i = 0; i < types.length; ++i) {
            int pName = OS.gdk_atom_name((int)types[i]);
            if (pName == 0) continue;
            byte[] buffer = new byte[OS.strlen((int)pName)];
            OS.memmove((byte[])buffer, (int)pName, (int)buffer.length);
            OS.g_free((int)pName);
            result[count++] = new String(Converter.mbcsToWcs(null, buffer));
        }
        if (count < types.length) {
            String[] temp = new String[count];
            System.arraycopy(result, 0, temp, 0, count);
            result = temp;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] _getAvailableTypes() {
        GtkSelectionData gtkSelectionData;
        int[] types = new int[]{};
        int selection_data = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, TARGET);
        if (selection_data != 0) {
            try {
                gtkSelectionData = new GtkSelectionData();
                OS.memmove((GtkSelectionData)gtkSelectionData, (int)selection_data, (int)GtkSelectionData.sizeof);
                if (gtkSelectionData.length == 0) {
                    int[] nArray = types;
                    return nArray;
                }
                types = new int[gtkSelectionData.length * 8 / gtkSelectionData.format];
                OS.memmove((int[])types, (int)gtkSelectionData.data, (int)gtkSelectionData.length);
            }
            finally {
                OS.gtk_selection_data_free((int)selection_data);
            }
        }
        if ((selection_data = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, TARGET)) != 0) {
            try {
                gtkSelectionData = new GtkSelectionData();
                OS.memmove((GtkSelectionData)gtkSelectionData, (int)selection_data, (int)GtkSelectionData.sizeof);
                if (gtkSelectionData.length == 0) {
                    int[] nArray = types;
                    return nArray;
                }
                int[] temp = new int[gtkSelectionData.length * 8 / gtkSelectionData.format];
                OS.memmove((int[])temp, (int)gtkSelectionData.data, (int)gtkSelectionData.length);
                int[] newTypes = new int[types.length + temp.length];
                System.arraycopy(types, 0, newTypes, 0, types.length);
                System.arraycopy(temp, 0, newTypes, types.length, temp.length);
                types = newTypes;
            }
            finally {
                OS.gtk_selection_data_free((int)selection_data);
            }
        }
        return types;
    }

    int gtk_clipboard_wait_for_contents(int clipboard, int target) {
        String key = "org.eclipse.swt.internal.gtk.dispatchEvent";
        this.display.setData(key, new int[]{16, 17, 18, 19});
        int selection_data = OS.gtk_clipboard_wait_for_contents((int)clipboard, (int)target);
        this.display.setData(key, null);
        return selection_data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        byte[] buffer = Converter.wcsToMbcs(null, "PRIMARY", true);
        int primary = OS.gdk_atom_intern((byte[])buffer, (boolean)false);
        GTKPRIMARYCLIPBOARD = OS.gtk_clipboard_get((int)primary);
        buffer = Converter.wcsToMbcs(null, "TARGETS", true);
        TARGET = OS.gdk_atom_intern((byte[])buffer, (boolean)false);
    }
}

