/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.GObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

class AccessibleObject {
    int handle;
    int parentType;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    Hashtable children = new Hashtable(9);
    boolean isLightweight = false;
    static int actionNamePtr = -1;
    static int descriptionPtr = -1;
    static int keybindingPtr = -1;
    static int namePtr = -1;
    static final Hashtable AccessibleObjects = new Hashtable(9);
    static final int ATK_ACTION_TYPE = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, "AtkAction", true));
    static final int ATK_COMPONENT_TYPE = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, "AtkComponent", true));
    static final int ATK_HYPERTEXT_TYPE = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, "AtkHypertext", true));
    static final int ATK_SELECTION_TYPE = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, "AtkSelection", true));
    static final int ATK_TEXT_TYPE = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, "AtkText", true));
    static final boolean DEBUG = Display.DEBUG;

    AccessibleObject(int type, int widget, Accessible accessible, int parentType, boolean isLightweight) {
        this.handle = ATK.g_object_new((int)type, (int)0);
        this.parentType = parentType;
        ATK.atk_object_initialize((int)this.handle, (int)widget);
        this.accessible = accessible;
        this.isLightweight = isLightweight;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            System.out.println("new AccessibleObject: " + this.handle);
        }
    }

    void addChild(AccessibleObject child) {
        this.children.put(new LONG(child.handle), child);
        child.setParent(this);
    }

    static int atkAction_get_keybinding(int atkObject, int index) {
        AccessibleListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkAction_get_keybinding");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_ACTION_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_ACTION_GET_IFACE((int)object.handle));
            AtkActionIface actionIface = new AtkActionIface();
            ATK.memmove((AtkActionIface)actionIface, (int)superType);
            if (actionIface.get_keybinding != 0) {
                parentResult = ATK.call((int)actionIface.get_keybinding, (int)object.handle, (int)index);
            }
        }
        if ((listeners = object.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(object);
        event.childID = object.id;
        if (parentResult != 0) {
            int length = OS.strlen((int)parentResult);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)parentResult, (int)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getKeyboardShortcut(event);
        }
        if (event.result == null) {
            return parentResult;
        }
        if (keybindingPtr != -1) {
            OS.g_free((int)keybindingPtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        keybindingPtr = OS.g_malloc((int)name.length);
        OS.memmove((int)keybindingPtr, (byte[])name, (int)name.length);
        return keybindingPtr;
    }

    static int atkAction_get_name(int atkObject, int index) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkAction_get_name");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_ACTION_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_ACTION_GET_IFACE((int)object.handle));
            AtkActionIface actionIface = new AtkActionIface();
            ATK.memmove((AtkActionIface)actionIface, (int)superType);
            if (actionIface.get_name != 0) {
                parentResult = ATK.call((int)actionIface.get_name, (int)object.handle, (int)index);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        if (parentResult != 0) {
            int length = OS.strlen((int)parentResult);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)parentResult, (int)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getDefaultAction(event);
        }
        if (event.result == null) {
            return parentResult;
        }
        if (actionNamePtr != -1) {
            OS.g_free((int)actionNamePtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        actionNamePtr = OS.g_malloc((int)name.length);
        OS.memmove((int)actionNamePtr, (byte[])name, (int)name.length);
        return actionNamePtr;
    }

    static int atkComponent_get_extents(int atkObject, int x, int y, int width, int height, int coord_type) {
        int[] topWindowY;
        int[] topWindowX;
        int window;
        int topLevel;
        GtkAccessible gtkAccessible;
        int gtkAccessibleHandle;
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_extents");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        OS.memmove((int)x, (int[])new int[]{0}, (int)4);
        OS.memmove((int)y, (int[])new int[]{0}, (int)4);
        OS.memmove((int)width, (int[])new int[]{0}, (int)4);
        OS.memmove((int)height, (int[])new int[]{0}, (int)4);
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_COMPONENT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_COMPONENT_GET_IFACE((int)object.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)componentIface, (int)superType);
            if (componentIface.get_extents != 0) {
                ATK.call((int)componentIface.get_extents, (int)object.handle, (int)x, (int)y, (int)width, (int)height, (int)coord_type);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return 0;
        }
        int[] parentX = new int[1];
        int[] parentY = new int[1];
        int[] parentWidth = new int[1];
        int[] parentHeight = new int[1];
        OS.memmove((int[])parentX, (int)x, (int)4);
        OS.memmove((int[])parentY, (int)y, (int)4);
        OS.memmove((int[])parentWidth, (int)width, (int)4);
        OS.memmove((int[])parentHeight, (int)height, (int)4);
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.x = parentX[0];
        event.y = parentY[0];
        event.width = parentWidth[0];
        event.height = parentHeight[0];
        if (coord_type == 1) {
            gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)object.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getLocation(event);
        }
        if (coord_type == 1) {
            gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)object.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x -= topWindowX[0];
            event.y -= topWindowY[0];
        }
        OS.memmove((int)x, (int[])new int[]{event.x}, (int)4);
        OS.memmove((int)y, (int[])new int[]{event.y}, (int)4);
        OS.memmove((int)width, (int[])new int[]{event.width}, (int)4);
        OS.memmove((int)height, (int[])new int[]{event.height}, (int)4);
        return 0;
    }

    static int atkComponent_get_position(int atkObject, int x, int y, int coord_type) {
        int[] topWindowY;
        int[] topWindowX;
        int window;
        int topLevel;
        GtkAccessible gtkAccessible;
        int gtkAccessibleHandle;
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_position, object: " + atkObject + " x: " + x + " y: " + y + " coord: " + coord_type);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        OS.memmove((int)x, (int[])new int[]{0}, (int)4);
        OS.memmove((int)y, (int[])new int[]{0}, (int)4);
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_COMPONENT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_COMPONENT_GET_IFACE((int)object.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)componentIface, (int)superType);
            if (componentIface.get_extents != 0) {
                ATK.call((int)componentIface.get_position, (int)object.handle, (int)x, (int)y, (int)coord_type);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return 0;
        }
        int[] parentX = new int[1];
        int[] parentY = new int[1];
        OS.memmove((int[])parentX, (int)x, (int)4);
        OS.memmove((int[])parentY, (int)y, (int)4);
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.x = parentX[0];
        event.y = parentY[0];
        if (coord_type == 1) {
            gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)object.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getLocation(event);
        }
        if (coord_type == 1) {
            gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)object.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            topWindowX = new int[1];
            topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x -= topWindowX[0];
            event.y -= topWindowY[0];
        }
        OS.memmove((int)x, (int[])new int[]{event.x}, (int)4);
        OS.memmove((int)y, (int[])new int[]{event.y}, (int)4);
        return 0;
    }

    static int atkComponent_get_size(int atkObject, int width, int height, int coord_type) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_size");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        OS.memmove((int)width, (int[])new int[]{0}, (int)4);
        OS.memmove((int)height, (int[])new int[]{0}, (int)4);
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_COMPONENT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_COMPONENT_GET_IFACE((int)object.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)componentIface, (int)superType);
            if (componentIface.get_extents != 0) {
                ATK.call((int)componentIface.get_size, (int)object.handle, (int)width, (int)height, (int)coord_type);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return 0;
        }
        int[] parentWidth = new int[1];
        int[] parentHeight = new int[1];
        OS.memmove((int[])parentWidth, (int)width, (int)4);
        OS.memmove((int[])parentHeight, (int)height, (int)4);
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.width = parentWidth[0];
        event.height = parentHeight[0];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getLocation(event);
        }
        OS.memmove((int)width, (int[])new int[]{event.width}, (int)4);
        OS.memmove((int)height, (int[])new int[]{event.height}, (int)4);
        return 0;
    }

    static int atkComponent_ref_accessible_at_point(int atkObject, int x, int y, int coord_type) {
        AccessibleObject accObj;
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkComponent_ref_accessible_at_point");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_COMPONENT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_COMPONENT_GET_IFACE((int)object.handle));
            AtkComponentIface componentIface = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)componentIface, (int)superType);
            if (componentIface.ref_accessible_at_point != 0) {
                parentResult = ATK.call((int)componentIface.ref_accessible_at_point, (int)object.handle, (int)x, (int)y, (int)coord_type);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.x = x;
        event.y = y;
        if (coord_type == 1) {
            int gtkAccessibleHandle = ATK.GTK_ACCESSIBLE((int)object.handle);
            GtkAccessible gtkAccessible = new GtkAccessible();
            ATK.memmove((GtkAccessible)gtkAccessible, (int)gtkAccessibleHandle);
            int topLevel = ATK.gtk_widget_get_toplevel((int)gtkAccessible.widget);
            int window = OS.GTK_WIDGET_WINDOW((int)topLevel);
            int[] topWindowX = new int[1];
            int[] topWindowY = new int[1];
            OS.gdk_window_get_origin((int)window, (int[])topWindowX, (int[])topWindowY);
            event.x += topWindowX[0];
            event.y += topWindowY[0];
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getChildAtPoint(event);
        }
        if (event.childID == object.id) {
            event.childID = -1;
        }
        if ((accObj = object.getChildByID(event.childID)) != null) {
            if (parentResult > 0) {
                OS.g_object_unref((int)parentResult);
            }
            OS.g_object_ref((int)accObj.handle);
            return accObj.handle;
        }
        return parentResult;
    }

    static int atkHypertext_get_link(int atkObject, int link_index) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_link");
        }
        return 0;
    }

    static int atkHypertext_get_n_links(int atkObject) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_n_links");
        }
        return 1;
    }

    static int atkHypertext_get_link_index(int atkObject, int char_index) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_link_index");
        }
        return 0;
    }

    static int atkObject_get_description(int atkObject) {
        AccessibleListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_description");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        int superType = ATK.g_type_class_peek((int)object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_description != 0) {
            parentResult = ATK.call((int)objectClass.get_description, (int)object.handle);
        }
        if ((listeners = object.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(object);
        event.childID = object.id;
        if (parentResult != 0) {
            int length = OS.strlen((int)parentResult);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)parentResult, (int)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getDescription(event);
        }
        if (event.result == null) {
            return parentResult;
        }
        if (descriptionPtr != -1) {
            OS.g_free((int)descriptionPtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        descriptionPtr = OS.g_malloc((int)name.length);
        OS.memmove((int)descriptionPtr, (byte[])name, (int)name.length);
        return descriptionPtr;
    }

    static int atkObject_get_name(int atkObject) {
        AccessibleListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_name: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        int superType = ATK.g_type_class_peek((int)object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_name != 0) {
            parentResult = ATK.call((int)objectClass.get_name, (int)object.handle);
        }
        if ((listeners = object.getAccessibleListeners()).length == 0) {
            return parentResult;
        }
        AccessibleEvent event = new AccessibleEvent(object);
        event.childID = object.id;
        if (parentResult != 0) {
            int length = OS.strlen((int)parentResult);
            byte[] buffer = new byte[length];
            OS.memmove((byte[])buffer, (int)parentResult, (int)length);
            event.result = new String(Converter.mbcsToWcs(null, buffer));
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getName(event);
        }
        if (event.result == null) {
            return parentResult;
        }
        if (namePtr != -1) {
            OS.g_free((int)namePtr);
        }
        byte[] name = Converter.wcsToMbcs(null, event.result, true);
        namePtr = OS.g_malloc((int)name.length);
        OS.memmove((int)namePtr, (byte[])name, (int)name.length);
        return namePtr;
    }

    static int atkObject_get_n_children(int atkObject) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_n_children: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        int superType = ATK.g_type_class_peek((int)object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_n_children != 0) {
            parentResult = ATK.call((int)objectClass.get_n_children, (int)object.handle);
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.detail = parentResult;
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getChildCount(event);
        }
        return event.detail;
    }

    static int atkObject_get_index_in_parent(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObjectCB_get_index_in_parent.  ");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        if (object.index != -1) {
            return object.index;
        }
        int superType = ATK.g_type_class_peek((int)object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_index_in_parent == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.get_index_in_parent, (int)object.handle);
    }

    static int atkObject_get_parent(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_parent: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        if (object.parent != null) {
            return object.parent.handle;
        }
        int superType = ATK.g_type_class_peek((int)object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_parent == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.get_parent, (int)object.handle);
    }

    static int atkObject_get_role(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_get_role: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        if (object.getAccessibleListeners().length != 0) {
            AccessibleControlListener[] listeners = object.getControlListeners();
            AccessibleControlEvent event = new AccessibleControlEvent(object);
            event.childID = object.id;
            event.detail = -1;
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].getRole(event);
            }
            if (event.detail != -1) {
                switch (event.detail) {
                    case 44: {
                        return 7;
                    }
                    case 10: {
                        return 18;
                    }
                    case 46: {
                        return 11;
                    }
                    case 18: {
                        return 16;
                    }
                    case 41: {
                        return 28;
                    }
                    case 30: {
                        return 60;
                    }
                    case 33: {
                        return 30;
                    }
                    case 34: {
                        return 31;
                    }
                    case 11: {
                        return 32;
                    }
                    case 2: {
                        return 33;
                    }
                    case 12: {
                        return 34;
                    }
                    case 48: {
                        return 41;
                    }
                    case 43: {
                        return 42;
                    }
                    case 3: {
                        return 47;
                    }
                    case 21: {
                        return 49;
                    }
                    case 51: {
                        return 50;
                    }
                    case 24: {
                        return 54;
                    }
                    case 29: {
                        return 55;
                    }
                    case 25: {
                        return 56;
                    }
                    case 26: {
                        return 57;
                    }
                    case 60: {
                        return 37;
                    }
                    case 37: {
                        return 36;
                    }
                    case 42: {
                        return 60;
                    }
                    case 22: {
                        return 62;
                    }
                    case 13: {
                        return 63;
                    }
                    case 35: {
                        return 64;
                    }
                    case 36: {
                        return 31;
                    }
                    case 45: {
                        return 43;
                    }
                    case 9: {
                        return 68;
                    }
                }
            }
        }
        int superType = ATK.g_type_class_peek((int)object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.get_role == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.get_role, (int)object.handle);
    }

    static int atkObject_ref_child(int atkObject, int index) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_ref_child: " + index + " of: " + atkObject);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        object.updateChildren();
        AccessibleObject accObject = object.getChildByIndex(index);
        if (accObject != null) {
            OS.g_object_ref((int)accObject.handle);
            return accObject.handle;
        }
        int superType = ATK.g_type_class_peek((int)object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.ref_child == 0) {
            return 0;
        }
        return ATK.call((int)objectClass.ref_child, (int)object.handle, (int)index);
    }

    static int atkObject_ref_state_set(int atkObject) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkObject_ref_state_set");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        int superType = ATK.g_type_class_peek((int)object.parentType);
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)superType);
        if (objectClass.ref_state_set != 0) {
            parentResult = ATK.call((int)objectClass.ref_state_set, (int)object.handle);
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        int set = parentResult;
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        event.detail = -1;
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getState(event);
        }
        if (event.detail != -1) {
            int state = event.detail;
            if ((state & 0x800) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)3);
            }
            if ((state & 0x10) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)4);
            }
            if ((state & 0x200) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)9);
            }
            if ((state & 0x100000) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)10);
            }
            if ((state & 4) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)11);
            }
            if ((state & 0x80) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)2);
            }
            if ((state & 0x8000) == 0) {
                ATK.atk_state_set_add_state((int)set, (int)28);
            }
            if ((state & 0x1000000) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)16);
            }
            if ((state & 0x10000) == 0) {
                ATK.atk_state_set_add_state((int)set, (int)23);
            }
            if ((state & 8) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)18);
            }
            if ((state & 0x40) == 0) {
                ATK.atk_state_set_add_state((int)set, (int)6);
            }
            if ((state & 0x200000) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)20);
            }
            if ((state & 2) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)21);
            }
            if ((state & 0x20000) != 0) {
                ATK.atk_state_set_add_state((int)set, (int)19);
            }
        }
        return set;
    }

    static int atkSelection_is_child_selected(int atkObject, int index) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkSelection_is_child_selected");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_SELECTION_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_SELECTION_GET_IFACE((int)object.handle));
            AtkSelectionIface selectionIface = new AtkSelectionIface();
            ATK.memmove((AtkSelectionIface)selectionIface, (int)superType);
            if (selectionIface.is_child_selected != 0) {
                parentResult = ATK.call((int)selectionIface.is_child_selected, (int)object.handle, (int)index);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getSelection(event);
        }
        AccessibleObject accessibleObject = object.getChildByID(event.childID);
        if (accessibleObject != null) {
            return accessibleObject.index == index ? 1 : 0;
        }
        return parentResult;
    }

    static int atkSelection_ref_selection(int atkObject, int index) {
        AccessibleControlListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkSelection_ref_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_SELECTION_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_SELECTION_GET_IFACE((int)object.handle));
            AtkSelectionIface selectionIface = new AtkSelectionIface();
            ATK.memmove((AtkSelectionIface)selectionIface, (int)superType);
            if (selectionIface.ref_selection != 0) {
                parentResult = ATK.call((int)selectionIface.ref_selection, (int)object.handle, (int)index);
            }
        }
        if ((listeners = object.getControlListeners()).length == 0) {
            return parentResult;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(object);
        event.childID = object.id;
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getSelection(event);
        }
        AccessibleObject accObj = object.getChildByID(event.childID);
        if (accObj != null) {
            if (parentResult > 0) {
                OS.g_object_unref((int)parentResult);
            }
            OS.g_object_ref((int)accObj.handle);
            return accObj.handle;
        }
        return parentResult;
    }

    static int atkText_get_caret_offset(int atkObject) {
        AccessibleTextListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_caret_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_TEXT_GET_IFACE((int)object.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_caret_offset != 0) {
                parentResult = ATK.call((int)textIface.get_caret_offset, (int)object.handle);
            }
        }
        if ((listeners = object.getTextListeners()).length == 0) {
            return parentResult;
        }
        AccessibleTextEvent event = new AccessibleTextEvent(object);
        event.childID = object.id;
        event.offset = parentResult;
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getCaretOffset(event);
        }
        return event.offset;
    }

    static int atkText_get_character_at_offset(int atkObject, int offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_character_at_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        String text = object.getText();
        if (text != null) {
            return text.charAt(offset);
        }
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_class_peek((int)object.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_character_at_offset != 0) {
                return ATK.call((int)textIface.get_character_at_offset, (int)object.handle, (int)offset);
            }
        }
        return 0;
    }

    static int atkText_get_character_count(int atkObject) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_character_count");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        String text = object.getText();
        if (text != null) {
            return text.length();
        }
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_class_peek((int)object.parentType);
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_character_count != 0) {
                return ATK.call((int)textIface.get_character_count, (int)object.handle);
            }
        }
        return 0;
    }

    static int atkText_get_n_selections(int atkObject) {
        AccessibleTextListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_n_selections");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int parentResult = 0;
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_TEXT_GET_IFACE((int)object.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_n_selections != 0) {
                parentResult = ATK.call((int)textIface.get_n_selections, (int)object.handle);
            }
        }
        if ((listeners = object.getTextListeners()).length == 0) {
            return parentResult;
        }
        AccessibleTextEvent event = new AccessibleTextEvent(object);
        event.childID = object.id;
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getSelectionRange(event);
        }
        return event.length == 0 ? parentResult : 1;
    }

    static int atkText_get_selection(int atkObject, int selection_num, int start_offset, int end_offset) {
        AccessibleTextListener[] listeners;
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_selection");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        OS.memmove((int)start_offset, (int[])new int[]{0}, (int)4);
        OS.memmove((int)end_offset, (int[])new int[]{0}, (int)4);
        if (ATK.g_type_is_a((int)object.parentType, (int)ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_TEXT_GET_IFACE((int)object.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            if (textIface.get_selection != 0) {
                ATK.call((int)textIface.get_selection, (int)object.handle, (int)selection_num, (int)start_offset, (int)end_offset);
            }
        }
        if ((listeners = object.getTextListeners()).length == 0) {
            return 0;
        }
        AccessibleTextEvent event = new AccessibleTextEvent(object);
        event.childID = object.id;
        int[] parentStart = new int[1];
        int[] parentEnd = new int[1];
        OS.memmove((int[])parentStart, (int)start_offset, (int)4);
        OS.memmove((int[])parentEnd, (int)end_offset, (int)4);
        event.offset = parentStart[0];
        event.length = parentEnd[0] - parentStart[0];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getSelectionRange(event);
        }
        OS.memmove((int)start_offset, (int[])new int[]{event.offset}, (int)4);
        OS.memmove((int)end_offset, (int[])new int[]{event.offset + event.length}, (int)4);
        return 0;
    }

    static int atkText_get_text(int atkObject, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_text: " + start_offset + "," + end_offset);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        String text = object.getText();
        if (text.length() > 0) {
            end_offset = end_offset == -1 ? text.length() : Math.min(end_offset, text.length());
            start_offset = Math.min(start_offset, end_offset);
            text = text.substring(start_offset, end_offset);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            int result = OS.g_malloc((int)bytes.length);
            OS.memmove((int)result, (byte[])bytes, (int)bytes.length);
            return result;
        }
        return 0;
    }

    static int atkText_get_text_after_offset(int atkObject, int offset_value, int boundary_type, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_after_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int offset = offset_value;
        String text = object.getText();
        if (text.length() > 0) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch (boundary_type) {
                case 0: {
                    if (length <= offset) break;
                    break;
                }
                case 1: {
                    int wordStart1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset - 1);
                    if (wordStart1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = wordStart1;
                    int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                    if (wordStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                    break;
                }
                case 2: {
                    int previousWordEnd = AccessibleObject.previousIndexOfNotChar(text, " \n", offset);
                    if (previousWordEnd == -1 || previousWordEnd != offset - 1) {
                        offset = AccessibleObject.nextIndexOfNotChar(text, " \n", offset);
                    }
                    if (offset == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    int wordEnd1 = AccessibleObject.nextIndexOfChar(text, " !?.\n", offset);
                    if (wordEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = wordEnd1;
                    int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", wordEnd1);
                    if (wordEnd2 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                    break;
                }
                case 3: {
                    int previousSentenceEnd = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                    int previousText = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                    int sentenceStart1 = 0;
                    if (previousSentenceEnd >= previousText) {
                        sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", offset);
                    } else {
                        sentenceStart1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                        if (sentenceStart1 == -1) {
                            startBounds = endBounds = length;
                            break;
                        }
                        sentenceStart1 = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart1);
                    }
                    if (sentenceStart1 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = sentenceStart1;
                    int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceStart1);
                    if (sentenceStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                    break;
                }
                case 4: {
                    int sentenceEnd1 = AccessibleObject.nextIndexOfChar(text, "!?.", offset);
                    if (sentenceEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((sentenceEnd1 = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = sentenceEnd1;
                    int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceEnd1);
                    if (sentenceEnd2 == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                    break;
                }
                case 5: {
                    int lineStart1 = text.indexOf(10, offset - 1);
                    if (lineStart1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    if ((lineStart1 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart1)) == length) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = lineStart1;
                    int lineStart2 = text.indexOf(10, lineStart1);
                    if (lineStart2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = lineStart2 = AccessibleObject.nextIndexOfNotChar(text, "\n", lineStart2);
                    break;
                }
                case 6: {
                    int lineEnd1 = AccessibleObject.nextIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        startBounds = endBounds = length;
                        break;
                    }
                    startBounds = lineEnd1;
                    if (startBounds == length) {
                        endBounds = length;
                        break;
                    }
                    int lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1);
                    if (lineEnd2 == -1) {
                        endBounds = length;
                        break;
                    }
                    endBounds = lineEnd2;
                    break;
                }
            }
            OS.memmove((int)start_offset, (int[])new int[]{startBounds}, (int)4);
            OS.memmove((int)end_offset, (int[])new int[]{++endBounds}, (int)4);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            int result = OS.g_malloc((int)bytes.length);
            OS.memmove((int)result, (byte[])bytes, (int)bytes.length);
            return result;
        }
        return 0;
    }

    static int atkText_get_text_at_offset(int atkObject, int offset_value, int boundary_type, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_at_offset: " + offset_value + " start: " + start_offset + " end: " + end_offset);
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int offset = offset_value;
        String text = object.getText();
        if (text.length() > 0) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch (boundary_type) {
                case 0: {
                    if (length <= offset) break;
                    break;
                }
                case 1: {
                    int wordStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset);
                    if (wordStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart1) + 1) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = wordStart1;
                    int wordStart2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordStart1);
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", wordStart2);
                    break;
                }
                case 2: {
                    int wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                    wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd1);
                    wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1);
                    if (wordEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = wordEnd1 + 1;
                    int wordEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                    if (wordEnd2 == length) {
                        endBounds = startBounds;
                        break;
                    }
                    if ((wordEnd2 = AccessibleObject.nextIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        endBounds = startBounds;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", wordEnd2);
                    break;
                }
                case 3: {
                    int sentenceStart1 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", offset + 1);
                    if (sentenceStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart1) + 1;
                    startBounds = AccessibleObject.nextIndexOfNotChar(text, " \n", sentenceStart1);
                    int sentenceStart2 = AccessibleObject.nextIndexOfChar(text, "!?.", startBounds);
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, " !?.\n", sentenceStart2);
                    break;
                }
                case 4: {
                    int sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, "!?.", offset + 1);
                    sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd1);
                    sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1);
                    if (sentenceEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = sentenceEnd1 + 1;
                    int sentenceEnd2 = AccessibleObject.nextIndexOfNotChar(text, " \n", startBounds);
                    if (sentenceEnd2 == length) {
                        endBounds = startBounds;
                        break;
                    }
                    if ((sentenceEnd2 = AccessibleObject.nextIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        endBounds = startBounds;
                        break;
                    }
                    endBounds = AccessibleObject.nextIndexOfNotChar(text, "!?.", sentenceEnd2);
                    break;
                }
                case 5: {
                    startBounds = AccessibleObject.previousIndexOfChar(text, "\n", offset) + 1;
                    int lineEnd2 = AccessibleObject.nextIndexOfChar(text, "\n", startBounds);
                    if (lineEnd2 < length) {
                        ++lineEnd2;
                    }
                    endBounds = lineEnd2;
                    break;
                }
                case 6: {
                    int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    startBounds = lineEnd1;
                    endBounds = AccessibleObject.nextIndexOfChar(text, "\n", lineEnd1 + 1);
                }
            }
            OS.memmove((int)start_offset, (int[])new int[]{startBounds}, (int)4);
            OS.memmove((int)end_offset, (int[])new int[]{++endBounds}, (int)4);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            int result = OS.g_malloc((int)bytes.length);
            OS.memmove((int)result, (byte[])bytes, (int)bytes.length);
            return result;
        }
        return 0;
    }

    static int atkText_get_text_before_offset(int atkObject, int offset_value, int boundary_type, int start_offset, int end_offset) {
        AccessibleObject object;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_before_offset");
        }
        if ((object = AccessibleObject.getAccessibleObject(atkObject)) == null) {
            return 0;
        }
        int offset = offset_value;
        String text = object.getText();
        if (text.length() > 0) {
            int length = text.length();
            int startBounds = offset = Math.min(offset, length - 1);
            int endBounds = offset;
            switch (boundary_type) {
                case 0: {
                    if (length < offset || offset <= 0) break;
                    break;
                }
                case 1: {
                    int wordStart1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset - 1);
                    if (wordStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    int wordStart2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", wordStart1);
                    if (wordStart2 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = wordStart1 + 1;
                    startBounds = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordStart2) + 1;
                    break;
                }
                case 2: {
                    int wordEnd1 = AccessibleObject.previousIndexOfChar(text, " !?.\n", offset);
                    if (wordEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((wordEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd1 + 1)) == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = wordEnd1 + 1;
                    int wordEnd2 = AccessibleObject.previousIndexOfNotChar(text, " !?.\n", endBounds);
                    if ((wordEnd2 = AccessibleObject.previousIndexOfChar(text, " !?.\n", wordEnd2)) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", wordEnd2 + 1) + 1;
                    break;
                }
                case 3: {
                    int sentenceStart1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                    if (sentenceStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    int sentenceStart2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", sentenceStart1);
                    if (sentenceStart2 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = sentenceStart1 + 1;
                    startBounds = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceStart2) + 1;
                    break;
                }
                case 4: {
                    int sentenceEnd1 = AccessibleObject.previousIndexOfChar(text, "!?.", offset);
                    if (sentenceEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    if ((sentenceEnd1 = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd1 + 1)) == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = sentenceEnd1 + 1;
                    int sentenceEnd2 = AccessibleObject.previousIndexOfNotChar(text, "!?.", endBounds);
                    if ((sentenceEnd2 = AccessibleObject.previousIndexOfChar(text, "!?.", sentenceEnd2)) == -1) {
                        startBounds = 0;
                        break;
                    }
                    startBounds = AccessibleObject.previousIndexOfNotChar(text, " \n", sentenceEnd2 + 1) + 1;
                    break;
                }
                case 5: {
                    int lineStart1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                    if (lineStart1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = lineStart1 + 1;
                    startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineStart1) + 1;
                    break;
                }
                case 6: {
                    int lineEnd1 = AccessibleObject.previousIndexOfChar(text, "\n", offset);
                    if (lineEnd1 == -1) {
                        endBounds = 0;
                        startBounds = 0;
                        break;
                    }
                    endBounds = lineEnd1;
                    startBounds = AccessibleObject.previousIndexOfChar(text, "\n", lineEnd1);
                    if (startBounds != -1) break;
                    startBounds = 0;
                    break;
                }
            }
            OS.memmove((int)start_offset, (int[])new int[]{--startBounds}, (int)4);
            OS.memmove((int)end_offset, (int[])new int[]{endBounds}, (int)4);
            text = text.substring(startBounds, endBounds);
            byte[] bytes = Converter.wcsToMbcs(null, text, true);
            int result = OS.g_malloc((int)bytes.length);
            OS.memmove((int)result, (byte[])bytes, (int)bytes.length);
            return result;
        }
        return 0;
    }

    AccessibleListener[] getAccessibleListeners() {
        if (this.accessible == null) {
            return new AccessibleListener[0];
        }
        return this.accessible.getAccessibleListeners();
    }

    static AccessibleObject getAccessibleObject(int atkObject) {
        return (AccessibleObject)AccessibleObjects.get(new LONG(atkObject));
    }

    AccessibleObject getChildByHandle(int handle) {
        return (AccessibleObject)this.children.get(new LONG(handle));
    }

    AccessibleObject getChildByID(int childId) {
        if (childId == -1) {
            return this;
        }
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject object = (AccessibleObject)elements.nextElement();
            if (object.id != childId) continue;
            return object;
        }
        return null;
    }

    AccessibleObject getChildByIndex(int childIndex) {
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject object = (AccessibleObject)elements.nextElement();
            if (object.index != childIndex) continue;
            return object;
        }
        return null;
    }

    AccessibleControlListener[] getControlListeners() {
        if (this.accessible == null) {
            return new AccessibleControlListener[0];
        }
        return this.accessible.getControlListeners();
    }

    String getText() {
        AccessibleControlListener[] controlListeners;
        int parentResult = 0;
        String parentText = "";
        if (ATK.g_type_is_a((int)this.parentType, (int)ATK_TEXT_TYPE)) {
            int superType = ATK.g_type_interface_peek_parent((int)ATK.ATK_TEXT_GET_IFACE((int)this.handle));
            AtkTextIface textIface = new AtkTextIface();
            ATK.memmove((AtkTextIface)textIface, (int)superType);
            int characterCount = 0;
            if (textIface.get_character_count != 0) {
                characterCount = ATK.call((int)textIface.get_character_count, (int)this.handle);
            }
            if (characterCount > 0 && textIface.get_text != 0 && (parentResult = ATK.call((int)textIface.get_text, (int)this.handle, (int)0, (int)characterCount)) != 0) {
                int length = OS.strlen((int)parentResult);
                byte[] buffer = new byte[length];
                OS.memmove((byte[])buffer, (int)parentResult, (int)length);
                parentText = new String(Converter.mbcsToWcs(null, buffer));
            }
        }
        if ((controlListeners = this.getControlListeners()).length == 0) {
            return parentText;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = this.id;
        event.result = parentText;
        for (int i = 0; i < controlListeners.length; ++i) {
            controlListeners[i].getValue(event);
        }
        return event.result;
    }

    AccessibleTextListener[] getTextListeners() {
        if (this.accessible == null) {
            return new AccessibleTextListener[0];
        }
        return this.accessible.getTextListeners();
    }

    static int gObjectClass_finalize(int atkObject) {
        int superType = ATK.g_type_class_peek_parent((int)ATK.G_OBJECT_GET_CLASS((int)atkObject));
        int gObjectClass = ATK.G_OBJECT_CLASS((int)superType);
        GObjectClass objectClassStruct = new GObjectClass();
        ATK.memmove((GObjectClass)objectClassStruct, (int)gObjectClass);
        ATK.call((int)objectClassStruct.finalize, (int)atkObject);
        AccessibleObject object = AccessibleObject.getAccessibleObject(atkObject);
        if (object != null) {
            AccessibleObjects.remove(new LONG(atkObject));
            object.release();
        }
        return 0;
    }

    static int nextIndexOfChar(String string, String searchChars, int startIndex) {
        int result = string.length();
        for (int i = 0; i < searchChars.length(); ++i) {
            char current = searchChars.charAt(i);
            int index = string.indexOf(current, startIndex);
            if (index == -1) continue;
            result = Math.min(result, index);
        }
        return result;
    }

    static int nextIndexOfNotChar(String string, String searchChars, int startIndex) {
        char current;
        int index;
        int length = string.length();
        for (index = startIndex; index < length && searchChars.indexOf(current = string.charAt(index)) != -1; ++index) {
        }
        return index;
    }

    static int previousIndexOfChar(String string, String searchChars, int startIndex) {
        int result = -1;
        if (startIndex < 0) {
            return result;
        }
        string = string.substring(0, startIndex);
        for (int i = 0; i < searchChars.length(); ++i) {
            char current = searchChars.charAt(i);
            int index = string.lastIndexOf(current);
            if (index == -1) continue;
            result = Math.max(result, index);
        }
        return result;
    }

    static int previousIndexOfNotChar(String string, String searchChars, int startIndex) {
        char current;
        int index;
        if (startIndex < 0) {
            return -1;
        }
        for (index = startIndex - 1; index >= 0 && searchChars.indexOf(current = string.charAt(index)) != -1; --index) {
        }
        return index;
    }

    void release() {
        if (DEBUG) {
            System.out.println("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        Enumeration elements = this.children.elements();
        while (elements.hasMoreElements()) {
            AccessibleObject child = (AccessibleObject)elements.nextElement();
            if (!child.isLightweight) continue;
            OS.g_object_unref((int)child.handle);
        }
        if (this.parent != null) {
            this.parent.removeChild(this, false);
        }
    }

    void removeChild(AccessibleObject child, boolean unref) {
        this.children.remove(new LONG(child.handle));
        if (unref && child.isLightweight) {
            OS.g_object_unref((int)child.handle);
        }
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name((int)this.handle, (byte[])ATK.selection_changed);
    }

    void setFocus(int childID) {
        this.updateChildren();
        AccessibleObject accObject = this.getChildByID(childID);
        if (accObject != null) {
            ATK.atk_focus_tracker_notify((int)accObject.handle);
        }
    }

    void setParent(AccessibleObject parent) {
        this.parent = parent;
    }

    void textCaretMoved(int index) {
        OS.g_signal_emit_by_name((int)this.handle, (byte[])ATK.text_caret_moved, (int)index);
    }

    void textChanged(int type, int startIndex, int length) {
        if (type == 1) {
            OS.g_signal_emit_by_name((int)this.handle, (byte[])ATK.text_changed_delete, (int)startIndex, (int)length);
        } else {
            OS.g_signal_emit_by_name((int)this.handle, (byte[])ATK.text_changed_insert, (int)startIndex, (int)length);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name((int)this.handle, (byte[])ATK.text_selection_changed);
    }

    void updateChildren() {
        if (this.isLightweight) {
            return;
        }
        AccessibleControlListener[] listeners = this.getControlListeners();
        if (listeners.length == 0) {
            return;
        }
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getChildren(event);
        }
        if (event.children != null && event.children.length > 0) {
            AccessibleObject object;
            int i;
            Vector<LONG> idsToKeep = new Vector<LONG>(this.children.size());
            if (event.children[0] instanceof Integer) {
                int parentType = AccessibleFactory.getDefaultParentType();
                for (i = 0; i < event.children.length; ++i) {
                    object = this.getChildByIndex(i);
                    if (object == null) {
                        int childType = AccessibleFactory.getChildType(this.accessible, i);
                        object = new AccessibleObject(childType, 0, this.accessible, parentType, true);
                        AccessibleObjects.put(new LONG(object.handle), object);
                        this.addChild(object);
                        object.index = i;
                    }
                    try {
                        object.id = (Integer)event.children[i];
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                    idsToKeep.addElement(new LONG(object.handle));
                }
            } else {
                int childIndex = 0;
                for (i = 0; i < event.children.length; ++i) {
                    object = null;
                    try {
                        object = ((Accessible)event.children[i]).accessibleObject;
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                    if (object == null) continue;
                    object.index = childIndex++;
                    idsToKeep.addElement(new LONG(object.handle));
                }
            }
            Enumeration ids = this.children.keys();
            while (ids.hasMoreElements()) {
                LONG id = (LONG)ids.nextElement();
                if (idsToKeep.contains(id)) continue;
                object = (AccessibleObject)this.children.get(id);
                this.removeChild(object, true);
            }
        }
    }
}

