/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectFactoryClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.GInterfaceInfo;
import org.eclipse.swt.internal.accessibility.gtk.GObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.GTypeInfo;
import org.eclipse.swt.internal.accessibility.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.LONG;
import org.eclipse.swt.internal.gtk.OS;

class AccessibleFactory {
    int handle;
    int objectParentType;
    int widgetTypeName;
    Callback atkObjectFactoryCB_create_accessible;
    Callback gTypeInfo_base_init_factory;
    Hashtable accessibles = new Hashtable(9);
    static final Hashtable Types = new Hashtable(9);
    static final Hashtable Factories = new Hashtable(9);
    static final int DefaultParentType = ATK.g_type_from_name((byte[])Converter.wcsToMbcs(null, "GtkAccessible", true));
    static final byte[] FACTORY_PARENTTYPENAME = Converter.wcsToMbcs(null, "AtkObjectFactory", true);
    static final byte[] SWT_TYPE_PREFIX = Converter.wcsToMbcs(null, "SWT", false);
    static final byte[] CHILD_TYPENAME = Converter.wcsToMbcs(null, "Child", false);
    static final byte[] FACTORY_TYPENAME = Converter.wcsToMbcs(null, "SWTFactory", true);
    static final int[] actionRoles = new int[]{44, 46, 30, 12, 43, 45};
    static final int[] hypertextRoles = new int[]{30};
    static final int[] selectionRoles = new int[]{33, 60, 24, 35};
    static final int[] textRoles = new int[]{46, 30, 41, 42};
    static final Callback AtkActionCB_get_keybinding = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkAction_get_keybinding", 2);
    static final Callback AtkActionCB_get_name = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkAction_get_name", 2);
    static final Callback AtkComponentCB_get_extents = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkComponent_get_extents", 6);
    static final Callback AtkComponentCB_get_position = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkComponent_get_position", 4);
    static final Callback AtkComponentCB_get_size = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkComponent_get_size", 4);
    static final Callback AtkComponentCB_ref_accessible_at_point = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkComponent_ref_accessible_at_point", 4);
    static final Callback AtkHypertextCB_get_link = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkHypertext_get_link", 2);
    static final Callback AtkHypertextCB_get_n_links = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkHypertext_get_n_links", 1);
    static final Callback AtkHypertextCB_get_link_index = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkHypertext_get_link_index", 2);
    static final Callback AtkObjectCB_get_description;
    static final Callback AtkObjectCB_get_index_in_parent;
    static final Callback AtkObjectCB_get_n_children;
    static final Callback AtkObjectCB_get_name;
    static final Callback AtkObjectCB_get_parent;
    static final Callback AtkObjectCB_get_role;
    static final Callback AtkObjectCB_ref_child;
    static final Callback AtkObjectCB_ref_state_set;
    static final Callback AtkSelectionCB_is_child_selected;
    static final Callback AtkSelectionCB_ref_selection;
    static final Callback AtkTextCB_get_caret_offset;
    static final Callback AtkTextCB_get_n_selections;
    static final Callback AtkTextCB_get_selection;
    static final Callback AtkTextCB_get_text;
    static final Callback AtkTextCB_get_text_after_offset;
    static final Callback AtkTextCB_get_text_at_offset;
    static final Callback AtkTextCB_get_text_before_offset;
    static final Callback AtkTextCB_get_character_at_offset;
    static final Callback AtkTextCB_get_character_count;
    static final Callback GObjectClass_finalize;
    static final Callback InitActionIfaceCB;
    static final Callback InitComponentIfaceCB;
    static final Callback InitHypertextIfaceCB;
    static final Callback GTypeInfo_base_init_type;
    static final Callback InitSelectionIfaceCB;
    static final Callback InitTextIfaceCB;
    static int ObjectIfaceDefinition;
    static final int ActionIfaceDefinition;
    static final int ComponentIfaceDefinition;
    static final int HypertextIfaceDefinition;
    static final int SelectionIfaceDefinition;
    static final int TextIfaceDefinition;
    static /* synthetic */ Class class$org$eclipse$swt$accessibility$AccessibleObject;
    static /* synthetic */ Class class$org$eclipse$swt$accessibility$AccessibleFactory;

    private AccessibleFactory(int widgetType) {
        if (DefaultParentType == 0) {
            return;
        }
        this.widgetTypeName = ATK.g_type_name((int)widgetType);
        int widgetTypeNameLength = OS.strlen((int)this.widgetTypeName) + 1;
        byte[] buffer = new byte[widgetTypeNameLength];
        OS.memmove((byte[])buffer, (int)this.widgetTypeName, (int)widgetTypeNameLength);
        byte[] factoryName = new byte[FACTORY_TYPENAME.length + widgetTypeNameLength];
        System.arraycopy(FACTORY_TYPENAME, 0, factoryName, 0, FACTORY_TYPENAME.length);
        System.arraycopy(buffer, 0, factoryName, FACTORY_TYPENAME.length, widgetTypeNameLength);
        if (ATK.g_type_from_name((byte[])factoryName) == 0) {
            int registry = ATK.atk_get_default_registry();
            int previousFactory = ATK.atk_registry_get_factory((int)registry, (int)widgetType);
            this.objectParentType = ATK.atk_object_factory_get_accessible_type((int)previousFactory);
            if (this.objectParentType == 0) {
                this.objectParentType = DefaultParentType;
            }
            int factoryParentType = ATK.g_type_from_name((byte[])FACTORY_PARENTTYPENAME);
            this.gTypeInfo_base_init_factory = new Callback(this, "gTypeInfo_base_init_factory", 1);
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = this.gTypeInfo_base_init_factory.getAddress();
            typeInfo.class_size = (short)ATK.AtkObjectFactoryClass_sizeof();
            typeInfo.instance_size = (short)ATK.AtkObjectFactory_sizeof();
            this.handle = OS.g_malloc((int)GTypeInfo.sizeof);
            ATK.memmove((int)this.handle, (GTypeInfo)typeInfo, (int)GTypeInfo.sizeof);
            int swtFactory = ATK.g_type_register_static((int)factoryParentType, (byte[])factoryName, (int)this.handle, (int)0);
            ATK.atk_registry_set_factory_type((int)registry, (int)widgetType, (int)swtFactory);
        }
    }

    void addAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        this.accessibles.put(new LONG(controlHandle), accessible);
    }

    int atkObjectFactory_create_accessible(int widget) {
        AccessibleObject object;
        Accessible accessible = (Accessible)this.accessibles.get(new LONG(widget));
        if (accessible == null) {
            int result = ATK.g_object_new((int)this.objectParentType, (int)0);
            ATK.atk_object_initialize((int)result, (int)widget);
            return result;
        }
        int typeNameLength = OS.strlen((int)this.widgetTypeName);
        byte[] buffer = new byte[typeNameLength];
        OS.memmove((byte[])buffer, (int)this.widgetTypeName, (int)typeNameLength);
        int type = AccessibleFactory.getType(buffer, accessible, this.objectParentType, -1);
        accessible.accessibleObject = object = new AccessibleObject(type, widget, accessible, this.objectParentType, false);
        return object.handle;
    }

    static int getChildType(Accessible accessible, int childIndex) {
        return AccessibleFactory.getType(CHILD_TYPENAME, accessible, DefaultParentType, childIndex);
    }

    static int getDefaultParentType() {
        return DefaultParentType;
    }

    static int getType(byte[] widgetTypeName, Accessible accessible, int parentType, int childId) {
        AccessibleControlEvent event = new AccessibleControlEvent(accessible);
        event.childID = childId;
        AccessibleControlListener[] listeners = accessible.getControlListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].getRole(event);
        }
        boolean action = false;
        boolean hypertext = false;
        boolean selection = false;
        boolean text = false;
        if (event.detail != 0) {
            int i;
            for (i = 0; i < actionRoles.length; ++i) {
                if (event.detail != actionRoles[i]) continue;
                action = true;
                break;
            }
            for (i = 0; i < hypertextRoles.length; ++i) {
                if (event.detail != hypertextRoles[i]) continue;
                hypertext = true;
                break;
            }
            for (i = 0; i < selectionRoles.length; ++i) {
                if (event.detail != selectionRoles[i]) continue;
                selection = true;
                break;
            }
            for (i = 0; i < textRoles.length; ++i) {
                if (event.detail != textRoles[i]) continue;
                text = true;
                break;
            }
        } else {
            text = true;
            selection = true;
            hypertext = true;
            action = true;
        }
        String swtTypeName = new String(SWT_TYPE_PREFIX);
        swtTypeName = swtTypeName + new String(widgetTypeName);
        if (action) {
            swtTypeName = swtTypeName + "Action";
        }
        if (hypertext) {
            swtTypeName = swtTypeName + "Hypertext";
        }
        if (selection) {
            swtTypeName = swtTypeName + "Selection";
        }
        if (text) {
            swtTypeName = swtTypeName + "Text";
        }
        int type = 0;
        LONG typeInt = (LONG)Types.get(swtTypeName);
        if (typeInt != null) {
            type = typeInt.value;
        } else {
            int queryPtr = OS.g_malloc((int)GTypeQuery.sizeof);
            ATK.g_type_query((int)parentType, (int)queryPtr);
            GTypeQuery query = new GTypeQuery();
            ATK.memmove((GTypeQuery)query, (int)queryPtr, (int)GTypeQuery.sizeof);
            OS.g_free((int)queryPtr);
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = GTypeInfo_base_init_type.getAddress();
            typeInfo.class_size = (short)query.class_size;
            typeInfo.instance_size = (short)query.instance_size;
            ObjectIfaceDefinition = OS.g_malloc((int)GTypeInfo.sizeof);
            ATK.memmove((int)ObjectIfaceDefinition, (GTypeInfo)typeInfo, (int)GTypeInfo.sizeof);
            byte[] nameBytes = new byte[swtTypeName.length() + 1];
            System.arraycopy(swtTypeName.getBytes(), 0, nameBytes, 0, swtTypeName.length());
            type = ATK.g_type_register_static((int)parentType, (byte[])nameBytes, (int)ObjectIfaceDefinition, (int)0);
            ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_COMPONENT_TYPE, (int)ComponentIfaceDefinition);
            if (action) {
                ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_ACTION_TYPE, (int)ActionIfaceDefinition);
            }
            if (hypertext) {
                ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_HYPERTEXT_TYPE, (int)HypertextIfaceDefinition);
            }
            if (selection) {
                ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_SELECTION_TYPE, (int)SelectionIfaceDefinition);
            }
            if (text) {
                ATK.g_type_add_interface_static((int)type, (int)AccessibleObject.ATK_TEXT_TYPE, (int)TextIfaceDefinition);
            }
            Types.put(swtTypeName, new LONG(type));
        }
        return type;
    }

    int gTypeInfo_base_init_factory(int klass) {
        int atkObjectFactoryClass = ATK.ATK_OBJECT_FACTORY_CLASS((int)klass);
        AtkObjectFactoryClass objectFactoryClassStruct = new AtkObjectFactoryClass();
        ATK.memmove((AtkObjectFactoryClass)objectFactoryClassStruct, (int)atkObjectFactoryClass);
        this.atkObjectFactoryCB_create_accessible = new Callback(this, "atkObjectFactory_create_accessible", 1);
        objectFactoryClassStruct.create_accessible = this.atkObjectFactoryCB_create_accessible.getAddress();
        ATK.memmove((int)atkObjectFactoryClass, (AtkObjectFactoryClass)objectFactoryClassStruct);
        return 0;
    }

    static int gTypeInfo_base_init_type(int klass) {
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)objectClass, (int)klass);
        objectClass.get_name = AtkObjectCB_get_name.getAddress();
        objectClass.get_description = AtkObjectCB_get_description.getAddress();
        objectClass.get_n_children = AtkObjectCB_get_n_children.getAddress();
        objectClass.get_role = AtkObjectCB_get_role.getAddress();
        objectClass.get_parent = AtkObjectCB_get_parent.getAddress();
        objectClass.ref_state_set = AtkObjectCB_ref_state_set.getAddress();
        objectClass.get_index_in_parent = AtkObjectCB_get_index_in_parent.getAddress();
        objectClass.ref_child = AtkObjectCB_ref_child.getAddress();
        int gObjectClass = ATK.G_OBJECT_CLASS((int)klass);
        GObjectClass objectClassStruct = new GObjectClass();
        ATK.memmove((GObjectClass)objectClassStruct, (int)gObjectClass);
        objectClassStruct.finalize = GObjectClass_finalize.getAddress();
        ATK.memmove((int)gObjectClass, (GObjectClass)objectClassStruct);
        ATK.memmove((int)klass, (AtkObjectClass)objectClass);
        return 0;
    }

    static int initActionIfaceCB(int iface) {
        AtkActionIface actionIface = new AtkActionIface();
        ATK.memmove((AtkActionIface)actionIface, (int)iface);
        actionIface.get_keybinding = AtkActionCB_get_keybinding.getAddress();
        actionIface.get_name = AtkActionCB_get_name.getAddress();
        ATK.memmove((int)iface, (AtkActionIface)actionIface);
        return 0;
    }

    static int initComponentIfaceCB(int iface) {
        AtkComponentIface componentIface = new AtkComponentIface();
        ATK.memmove((AtkComponentIface)componentIface, (int)iface);
        componentIface.get_extents = AtkComponentCB_get_extents.getAddress();
        componentIface.get_position = AtkComponentCB_get_position.getAddress();
        componentIface.get_size = AtkComponentCB_get_size.getAddress();
        componentIface.ref_accessible_at_point = AtkComponentCB_ref_accessible_at_point.getAddress();
        ATK.memmove((int)iface, (AtkComponentIface)componentIface);
        return 0;
    }

    static int initHypertextIfaceCB(int iface) {
        AtkHypertextIface hypertextIface = new AtkHypertextIface();
        ATK.memmove((AtkHypertextIface)hypertextIface, (int)iface);
        hypertextIface.get_link = AtkHypertextCB_get_link.getAddress();
        hypertextIface.get_link_index = AtkHypertextCB_get_link_index.getAddress();
        hypertextIface.get_n_links = AtkHypertextCB_get_n_links.getAddress();
        ATK.memmove((int)iface, (AtkHypertextIface)hypertextIface);
        return 0;
    }

    static int initSelectionIfaceCB(int iface) {
        AtkSelectionIface selectionIface = new AtkSelectionIface();
        ATK.memmove((AtkSelectionIface)selectionIface, (int)iface);
        selectionIface.is_child_selected = AtkSelectionCB_is_child_selected.getAddress();
        selectionIface.ref_selection = AtkSelectionCB_ref_selection.getAddress();
        ATK.memmove((int)iface, (AtkSelectionIface)selectionIface);
        return 0;
    }

    static int initTextIfaceCB(int iface) {
        AtkTextIface textInterface = new AtkTextIface();
        ATK.memmove((AtkTextIface)textInterface, (int)iface);
        textInterface.get_caret_offset = AtkTextCB_get_caret_offset.getAddress();
        textInterface.get_character_at_offset = AtkTextCB_get_character_at_offset.getAddress();
        textInterface.get_character_count = AtkTextCB_get_character_count.getAddress();
        textInterface.get_n_selections = AtkTextCB_get_n_selections.getAddress();
        textInterface.get_selection = AtkTextCB_get_selection.getAddress();
        textInterface.get_text = AtkTextCB_get_text.getAddress();
        textInterface.get_text_after_offset = AtkTextCB_get_text_after_offset.getAddress();
        textInterface.get_text_at_offset = AtkTextCB_get_text_at_offset.getAddress();
        textInterface.get_text_before_offset = AtkTextCB_get_text_before_offset.getAddress();
        ATK.memmove((int)iface, (AtkTextIface)textInterface);
        return 0;
    }

    static void registerAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        int widgetType = ATK.G_TYPE_FROM_INSTANCE((int)controlHandle);
        AccessibleFactory factory = (AccessibleFactory)Factories.get(new LONG(widgetType));
        if (factory == null) {
            factory = new AccessibleFactory(widgetType);
            Factories.put(new LONG(widgetType), factory);
        }
        factory.addAccessible(accessible);
    }

    void removeAccessible(Accessible accessible) {
        this.accessibles.remove(new LONG(accessible.getControlHandle()));
    }

    static void unregisterAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        int widgetType = ATK.G_TYPE_FROM_INSTANCE((int)controlHandle);
        AccessibleFactory factory = (AccessibleFactory)Factories.get(new LONG(widgetType));
        if (factory != null) {
            factory.removeAccessible(accessible);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AtkObjectCB_get_name = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_name", 1);
        AtkObjectCB_get_description = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_description", 1);
        AtkObjectCB_get_n_children = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_n_children", 1);
        AtkObjectCB_get_role = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_role", 1);
        AtkObjectCB_get_parent = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_parent", 1);
        AtkObjectCB_ref_state_set = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_ref_state_set", 1);
        AtkObjectCB_get_index_in_parent = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_get_index_in_parent", 1);
        AtkObjectCB_ref_child = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkObject_ref_child", 2);
        AtkSelectionCB_is_child_selected = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkSelection_is_child_selected", 2);
        AtkSelectionCB_ref_selection = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkSelection_ref_selection", 2);
        AtkTextCB_get_caret_offset = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_caret_offset", 1);
        AtkTextCB_get_n_selections = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_n_selections", 1);
        AtkTextCB_get_selection = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_selection", 4);
        AtkTextCB_get_text = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_text", 3);
        AtkTextCB_get_text_after_offset = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_text_after_offset", 5);
        AtkTextCB_get_text_at_offset = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_text_at_offset", 5);
        AtkTextCB_get_text_before_offset = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_text_before_offset", 5);
        AtkTextCB_get_character_at_offset = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_character_at_offset", 2);
        AtkTextCB_get_character_count = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "atkText_get_character_count", 1);
        GObjectClass_finalize = new Callback(class$org$eclipse$swt$accessibility$AccessibleObject == null ? (class$org$eclipse$swt$accessibility$AccessibleObject = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleObject")) : class$org$eclipse$swt$accessibility$AccessibleObject, "gObjectClass_finalize", 1);
        GTypeInfo_base_init_type = new Callback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "gTypeInfo_base_init_type", 1);
        InitActionIfaceCB = new Callback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initActionIfaceCB", 1);
        GInterfaceInfo interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitActionIfaceCB.getAddress();
        ActionIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)ActionIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
        InitComponentIfaceCB = new Callback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initComponentIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitComponentIfaceCB.getAddress();
        ComponentIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)ComponentIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
        InitHypertextIfaceCB = new Callback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initHypertextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitHypertextIfaceCB.getAddress();
        HypertextIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)HypertextIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
        InitSelectionIfaceCB = new Callback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initSelectionIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitSelectionIfaceCB.getAddress();
        SelectionIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)SelectionIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
        InitTextIfaceCB = new Callback(class$org$eclipse$swt$accessibility$AccessibleFactory == null ? (class$org$eclipse$swt$accessibility$AccessibleFactory = AccessibleFactory.class$("org.eclipse.swt.accessibility.AccessibleFactory")) : class$org$eclipse$swt$accessibility$AccessibleFactory, "initTextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitTextIfaceCB.getAddress();
        TextIfaceDefinition = OS.g_malloc((int)GInterfaceInfo.sizeof);
        ATK.memmove((int)TextIfaceDefinition, (GInterfaceInfo)interfaceInfo, (int)GInterfaceInfo.sizeof);
    }
}

