/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.util.Util;

class JavaProjectElementInfo
extends OpenableElementInfo {
    private Object[] nonJavaResources = null;
    public IPackageFragmentRoot[] allPkgFragmentRootsCache;
    private HashMap allPkgFragmentsCache;

    private Object[] computeNonJavaResources(JavaProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        boolean binIsProject = false;
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = null;
        IClasspathEntry[] classpath = null;
        IPath projectOutput = null;
        try {
            classpath = project.getResolvedClasspath(true, false, false);
            for (int i = 0; i < classpath.length; ++i) {
                IClasspathEntry entry = classpath[i];
                if (!projectPath.equals(entry.getPath())) continue;
                srcIsProject = true;
                inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                break;
            }
            projectOutput = project.getOutputLocation();
            binIsProject = projectPath.equals(projectOutput);
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        Object[] resources = new IResource[5];
        int resourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int max = members.length;
            block9: for (int i = 0; i < max; ++i) {
                IResource res = members[i];
                switch (res.getType()) {
                    case 1: {
                        IPath resFullPath = res.getFullPath();
                        String resName = res.getName();
                        if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(resName) && this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput) || srcIsProject && Util.isValidCompilationUnitName(resName) && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) || binIsProject && Util.isValidClassFileName(resName)) continue block9;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                        continue block9;
                    }
                    case 2: {
                        IPath resFullPath = res.getFullPath();
                        if (srcIsProject && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) && Util.isValidFolderNameForPackage(res.getName()) || this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput)) continue block9;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                    }
                }
            }
            if (resources.length != resourcesCounter) {
                Object[] objectArray = resources;
                resources = new IResource[resourcesCounter];
                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
            }
        }
        catch (CoreException e) {
            resources = NO_NON_JAVA_RESOURCES;
            resourcesCounter = 0;
        }
        return resources;
    }

    IPackageFragmentRoot[] getAllPackageFragmentRoots(JavaProject project) {
        if (this.allPkgFragmentRootsCache == null) {
            try {
                this.allPkgFragmentRootsCache = project.getAllPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return this.allPkgFragmentRootsCache;
    }

    HashMap getAllPackageFragments(JavaProject project) {
        if (this.allPkgFragmentsCache == null) {
            HashMap<String, IPackageFragment[]> cache = new HashMap<String, IPackageFragment[]>();
            IPackageFragmentRoot[] roots = this.getAllPackageFragmentRoots(project);
            IPackageFragment[] frags = this.getPackageFragmentsInRoots(roots, project);
            for (int i = 0; i < frags.length; ++i) {
                IPackageFragment fragment = frags[i];
                IPackageFragment[] entry = (IPackageFragment[])cache.get(fragment.getElementName());
                if (entry == null) {
                    entry = new IPackageFragment[]{fragment};
                    cache.put(fragment.getElementName(), entry);
                    continue;
                }
                IPackageFragment[] copy = new IPackageFragment[entry.length + 1];
                System.arraycopy(entry, 0, copy, 0, entry.length);
                copy[entry.length] = fragment;
                cache.put(fragment.getElementName(), copy);
            }
            this.allPkgFragmentsCache = cache;
        }
        return this.allPkgFragmentsCache;
    }

    Object[] getNonJavaResources(JavaProject project) {
        if (this.nonJavaResources == null) {
            this.nonJavaResources = this.computeNonJavaResources(project);
        }
        return this.nonJavaResources;
    }

    private IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots, IJavaProject project) {
        ArrayList<IJavaElement> frags = new ArrayList<IJavaElement>();
        for (int i = 0; i < roots.length; ++i) {
            IPackageFragmentRoot root = roots[i];
            try {
                int j;
                IJavaElement[] pkgs = root.getChildren();
                int length = pkgs.length;
                if (length == 0) continue;
                if (pkgs[0].getParent().getParent().equals(project)) {
                    for (j = 0; j < length; ++j) {
                        frags.add(pkgs[j]);
                    }
                    continue;
                }
                for (j = 0; j < length; ++j) {
                    frags.add(root.getPackageFragment(pkgs[j].getElementName()));
                }
                continue;
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    private boolean isClasspathEntryOrOutputLocation(IPath path, IClasspathEntry[] resolvedClasspath, IPath projectOutput) {
        if (projectOutput.equals(path)) {
            return true;
        }
        int length = resolvedClasspath.length;
        for (int i = 0; i < length; ++i) {
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals(path)) {
                return true;
            }
            IPath output = entry.getOutputLocation();
            if (output == null || !output.equals(path)) continue;
            return true;
        }
        return false;
    }

    void resetCaches() {
        this.allPkgFragmentRootsCache = null;
        this.allPkgFragmentsCache = null;
    }

    void setNonJavaResources(Object[] resources) {
        this.nonJavaResources = resources;
    }
}

