/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.DefaultCommentMapper;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class CompilationUnit
extends ASTNode {
    public static final ChildPropertyDescriptor PACKAGE_PROPERTY = new ChildPropertyDescriptor(class$org$eclipse$jdt$core$dom$CompilationUnit == null ? (class$org$eclipse$jdt$core$dom$CompilationUnit = CompilationUnit.class$("org.eclipse.jdt.core.dom.CompilationUnit")) : class$org$eclipse$jdt$core$dom$CompilationUnit, "package", class$org$eclipse$jdt$core$dom$PackageDeclaration == null ? (class$org$eclipse$jdt$core$dom$PackageDeclaration = CompilationUnit.class$("org.eclipse.jdt.core.dom.PackageDeclaration")) : class$org$eclipse$jdt$core$dom$PackageDeclaration, OPTIONAL, NO_CYCLE_RISK);
    public static final ChildListPropertyDescriptor IMPORTS_PROPERTY = new ChildListPropertyDescriptor(class$org$eclipse$jdt$core$dom$CompilationUnit == null ? (class$org$eclipse$jdt$core$dom$CompilationUnit = CompilationUnit.class$("org.eclipse.jdt.core.dom.CompilationUnit")) : class$org$eclipse$jdt$core$dom$CompilationUnit, "imports", class$org$eclipse$jdt$core$dom$ImportDeclaration == null ? (class$org$eclipse$jdt$core$dom$ImportDeclaration = CompilationUnit.class$("org.eclipse.jdt.core.dom.ImportDeclaration")) : class$org$eclipse$jdt$core$dom$ImportDeclaration, NO_CYCLE_RISK);
    public static final ChildListPropertyDescriptor TYPES_PROPERTY = new ChildListPropertyDescriptor(class$org$eclipse$jdt$core$dom$CompilationUnit == null ? (class$org$eclipse$jdt$core$dom$CompilationUnit = CompilationUnit.class$("org.eclipse.jdt.core.dom.CompilationUnit")) : class$org$eclipse$jdt$core$dom$CompilationUnit, "types", class$org$eclipse$jdt$core$dom$AbstractTypeDeclaration == null ? (class$org$eclipse$jdt$core$dom$AbstractTypeDeclaration = CompilationUnit.class$("org.eclipse.jdt.core.dom.AbstractTypeDeclaration")) : class$org$eclipse$jdt$core$dom$AbstractTypeDeclaration, CYCLE_RISK);
    private static final List PROPERTY_DESCRIPTORS;
    Comment[] optionalCommentTable = null;
    private List optionalCommentList = null;
    private PackageDeclaration optionalPackageDeclaration = null;
    private ASTNode.NodeList imports = new ASTNode.NodeList(IMPORTS_PROPERTY);
    private ASTNode.NodeList types = new ASTNode.NodeList(TYPES_PROPERTY);
    private int[] lineEndTable = new int[0];
    private static final Message[] EMPTY_MESSAGES;
    private static final IProblem[] EMPTY_PROBLEMS;
    private Message[] messages;
    private IProblem[] problems = EMPTY_PROBLEMS;
    private DefaultCommentMapper commentMapper = null;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$CompilationUnit;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$PackageDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$ImportDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$AbstractTypeDeclaration;

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    void setLineEndTable(int[] lineEndTable) {
        if (lineEndTable == null) {
            throw new NullPointerException();
        }
        this.checkModifiable();
        this.lineEndTable = lineEndTable;
    }

    CompilationUnit(AST ast) {
        super(ast);
    }

    final List internalStructuralPropertiesForType(int apiLevel) {
        return CompilationUnit.propertyDescriptors(apiLevel);
    }

    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == PACKAGE_PROPERTY) {
            if (get) {
                return this.getPackage();
            }
            this.setPackage((PackageDeclaration)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == IMPORTS_PROPERTY) {
            return this.imports();
        }
        if (property == TYPES_PROPERTY) {
            return this.types();
        }
        return super.internalGetChildListProperty(property);
    }

    final int getNodeType0() {
        return 15;
    }

    ASTNode clone0(AST target) {
        CompilationUnit result = new CompilationUnit(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setPackage((PackageDeclaration)ASTNode.copySubtree(target, this.getPackage()));
        result.imports().addAll(ASTNode.copySubtrees(target, this.imports()));
        result.types().addAll(ASTNode.copySubtrees(target, this.types()));
        return result;
    }

    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getPackage());
            this.acceptChildren(visitor, this.imports);
            this.acceptChildren(visitor, this.types);
        }
        visitor.endVisit(this);
    }

    public PackageDeclaration getPackage() {
        return this.optionalPackageDeclaration;
    }

    public void setPackage(PackageDeclaration pkgDecl) {
        PackageDeclaration oldChild = this.optionalPackageDeclaration;
        this.preReplaceChild(oldChild, pkgDecl, PACKAGE_PROPERTY);
        this.optionalPackageDeclaration = pkgDecl;
        this.postReplaceChild(oldChild, pkgDecl, PACKAGE_PROPERTY);
    }

    public List imports() {
        return this.imports;
    }

    public List types() {
        return this.types;
    }

    public ASTNode findDeclaringNode(IBinding binding) {
        return this.ast.getBindingResolver().findDeclaringNode(binding);
    }

    public ASTNode findDeclaringNode(String key) {
        return this.ast.getBindingResolver().findDeclaringNode(key);
    }

    DefaultCommentMapper getCommentMapper() {
        return this.commentMapper;
    }

    void initCommentMapper(Scanner scanner) {
        this.commentMapper = new DefaultCommentMapper(this.optionalCommentTable);
        this.commentMapper.initialize(this, scanner);
    }

    public int getExtendedStartPosition(ASTNode node) {
        if (this.commentMapper == null) {
            return -1;
        }
        return this.commentMapper.getExtendedStartPosition(node);
    }

    public int getExtendedLength(ASTNode node) {
        if (this.commentMapper == null) {
            return 0;
        }
        return this.commentMapper.getExtendedLength(node);
    }

    public int lineNumber(int position) {
        int length = this.lineEndTable.length;
        if (length == 0) {
            return 1;
        }
        int low = 0;
        if (position <= this.lineEndTable[low]) {
            return 1;
        }
        int hi = length - 1;
        if (position > this.lineEndTable[hi]) {
            if (position >= this.getStartPosition() + this.getLength()) {
                return 1;
            }
            return length + 1;
        }
        while (low + 1 != hi) {
            int mid = (low + hi) / 2;
            if (position <= this.lineEndTable[mid]) {
                hi = mid;
                continue;
            }
            low = mid;
        }
        return low + 2;
    }

    public Message[] getMessages() {
        if (this.messages == null) {
            int problemLength = this.problems.length;
            if (problemLength == 0) {
                this.messages = EMPTY_MESSAGES;
            } else {
                this.messages = new Message[problemLength];
                for (int i = 0; i < problemLength; ++i) {
                    IProblem problem = this.problems[i];
                    int start = problem.getSourceStart();
                    int end = problem.getSourceEnd();
                    this.messages[i] = new Message(problem.getMessage(), start, end - start + 1);
                }
            }
        }
        return this.messages;
    }

    public IProblem[] getProblems() {
        return this.problems;
    }

    void setProblems(IProblem[] problems) {
        if (problems == null) {
            throw new IllegalArgumentException();
        }
        this.problems = problems;
    }

    public List getCommentList() {
        return this.optionalCommentList;
    }

    void setCommentTable(Comment[] commentTable) {
        if (commentTable == null) {
            this.optionalCommentList = null;
            this.optionalCommentTable = null;
        } else {
            int nextAvailablePosition = 0;
            for (int i = 0; i < commentTable.length; ++i) {
                Comment comment = commentTable[i];
                if (comment == null) {
                    throw new IllegalArgumentException();
                }
                int start = comment.getStartPosition();
                int length = comment.getLength();
                if (start < 0 || length < 0 || start < nextAvailablePosition) {
                    throw new IllegalArgumentException();
                }
                nextAvailablePosition = comment.getStartPosition() + comment.getLength();
            }
            this.optionalCommentTable = commentTable;
            List<Comment> commentList = Arrays.asList(commentTable);
            this.optionalCommentList = Collections.unmodifiableList(commentList);
        }
    }

    void appendDebugString(StringBuffer buffer) {
        buffer.append("CompilationUnit");
        buffer.append("[");
        Iterator it = this.types().iterator();
        while (it.hasNext()) {
            AbstractTypeDeclaration d = (AbstractTypeDeclaration)it.next();
            buffer.append(d.getName().getIdentifier());
            if (!it.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append("]");
    }

    int memSize() {
        int size = 72;
        if (this.lineEndTable != null) {
            size += 12 + 4 * this.lineEndTable.length;
        }
        if (this.optionalCommentTable != null) {
            size += 12 + 4 * this.optionalCommentTable.length;
        }
        return size;
    }

    int treeSize() {
        int size = this.memSize();
        if (this.optionalPackageDeclaration != null) {
            size += this.getPackage().treeSize();
        }
        size += this.imports.listSize();
        size += this.types.listSize();
        if (this.optionalCommentList != null) {
            for (int i = 0; i < this.optionalCommentList.size(); ++i) {
                Comment comment = (Comment)this.optionalCommentList.get(i);
                if (comment == null || comment.getParent() != null) continue;
                size += comment.treeSize();
            }
        }
        return size;
    }

    public void recordModifications() {
        this.getAST().recordModifications(this);
    }

    public TextEdit rewrite(IDocument document, Map options) {
        return this.getAST().rewrite(document, options);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList properyList = new ArrayList(4);
        CompilationUnit.createPropertyList(class$org$eclipse$jdt$core$dom$CompilationUnit == null ? (class$org$eclipse$jdt$core$dom$CompilationUnit = CompilationUnit.class$("org.eclipse.jdt.core.dom.CompilationUnit")) : class$org$eclipse$jdt$core$dom$CompilationUnit, properyList);
        CompilationUnit.addProperty(PACKAGE_PROPERTY, properyList);
        CompilationUnit.addProperty(IMPORTS_PROPERTY, properyList);
        CompilationUnit.addProperty(TYPES_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = CompilationUnit.reapPropertyList(properyList);
        EMPTY_MESSAGES = new Message[0];
        EMPTY_PROBLEMS = new IProblem[0];
    }
}

