/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class NavigatorDragAdapter
extends DragSourceAdapter {
    private static final String CHECK_MOVE_TITLE = ResourceNavigatorMessages.getString("DragAdapter.title");
    private static final String CHECK_DELETE_MESSAGE = ResourceNavigatorMessages.getString("DragAdapter.checkDeleteMessage");
    ISelectionProvider selectionProvider;
    private TransferData lastDataType;

    public NavigatorDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void dragFinished(DragSourceEvent event) {
        block11: {
            block10: {
                LocalSelectionTransfer.getInstance().setSelection(null);
                if (!event.doit) {
                    return;
                }
                int typeMask = 3;
                if (event.detail != 2) break block10;
                if (this.lastDataType != null && FileTransfer.getInstance().isSupportedType(this.lastDataType)) {
                    return;
                }
                IResource[] resources = this.getSelectedResources(3);
                DragSource dragSource = (DragSource)event.widget;
                Control control = dragSource.getControl();
                Shell shell = control.getShell();
                if (resources == null || resources.length == 0) {
                    return;
                }
                ReadOnlyStateChecker checker = new ReadOnlyStateChecker(shell, CHECK_MOVE_TITLE, CHECK_DELETE_MESSAGE);
                resources = checker.checkReadOnlyResources(resources);
                for (int i = 0; i < resources.length; ++i) {
                    try {
                        resources[i].delete(3, null);
                        continue;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                break block11;
            }
            if (event.detail != 8) break block11;
            IResource[] resources = this.getSelectedResources(3);
            if (resources == null) {
                return;
            }
            for (int i = 0; i < resources.length; ++i) {
                try {
                    resources[i].refreshLocal(2, null);
                    continue;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        int typeMask = 3;
        IResource[] resources = this.getSelectedResources(3);
        if (resources == null || resources.length == 0) {
            return;
        }
        this.lastDataType = event.dataType;
        if (LocalSelectionTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = LocalSelectionTransfer.getInstance().getSelection();
            return;
        }
        if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = resources;
            return;
        }
        if (!FileTransfer.getInstance().isSupportedType(event.dataType)) {
            return;
        }
        int length = resources.length;
        int actualLength = 0;
        String[] fileNames = new String[length];
        for (int i = 0; i < length; ++i) {
            IPath location = resources[i].getLocation();
            if (location == null) continue;
            fileNames[actualLength++] = location.toOSString();
        }
        if (actualLength == 0) {
            return;
        }
        if (actualLength < length) {
            String[] tempFileNames = fileNames;
            fileNames = new String[actualLength];
            for (int i = 0; i < actualLength; ++i) {
                fileNames[i] = tempFileNames[i];
            }
        }
        event.data = fileNames;
    }

    public void dragStart(DragSourceEvent event) {
        this.lastDataType = null;
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof IFile || next instanceof IFolder) continue;
            event.doit = false;
            return;
        }
        if (selection.isEmpty()) {
            event.doit = false;
            return;
        }
        LocalSelectionTransfer.getInstance().setSelection((ISelection)selection);
        event.doit = true;
    }

    private IResource[] getSelectedResources(int resourceTypes) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] result = new IResource[]{};
        ISelection selection = this.selectionProvider.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection == null) {
            return null;
        }
        Iterator iterator = structuredSelection.iterator();
        while (iterator.hasNext()) {
            IResource res;
            Object obj = iterator.next();
            if (!(obj instanceof IResource) || ((res = (IResource)obj).getType() & resourceTypes) != res.getType()) continue;
            resources.add(res);
        }
        result = new IResource[resources.size()];
        resources.toArray(result);
        return result;
    }
}

