/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractOverlayIcon
extends CompositeImageDescriptor {
    static final int DEFAULT_WIDTH = 16;
    static final int DEFAULT_HEIGHT = 16;
    private Point fSize = null;
    private ImageDescriptor[][] fOverlays;

    public AbstractOverlayIcon(ImageDescriptor[][] overlays) {
        this(overlays, null);
    }

    public AbstractOverlayIcon(ImageDescriptor[][] overlays, Point size) {
        this.fOverlays = overlays;
        this.fSize = size != null ? size : new Point(16, 16);
    }

    protected void drawBottomLeft(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = 0;
        for (int i = 0; i < 3; ++i) {
            if (i >= length || overlays[i] == null) continue;
            ImageData id = overlays[i].getImageData();
            this.drawImage(id, x, this.getSize().y - id.height);
            x += id.width;
        }
    }

    protected void drawBottomRight(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = this.getSize().x;
        for (int i = 2; i >= 0; --i) {
            if (i >= length || overlays[i] == null) continue;
            ImageData id = overlays[i].getImageData();
            this.drawImage(id, x -= id.width, this.getSize().y - id.height);
        }
    }

    protected abstract ImageData getBaseImageData();

    protected void drawCompositeImage(int width, int height) {
        ImageData base = this.getBaseImageData();
        this.drawImage(base, 0, 0);
        if (this.fOverlays != null) {
            if (this.fOverlays.length > 0) {
                this.drawTopRight(this.fOverlays[0]);
            }
            if (this.fOverlays.length > 1) {
                this.drawBottomRight(this.fOverlays[1]);
            }
            if (this.fOverlays.length > 2) {
                this.drawBottomLeft(this.fOverlays[2]);
            }
            if (this.fOverlays.length > 3) {
                this.drawTopLeft(this.fOverlays[3]);
            }
        }
    }

    protected void drawTopLeft(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = 0;
        for (int i = 0; i < 3; ++i) {
            if (i >= length || overlays[i] == null) continue;
            ImageData id = overlays[i].getImageData();
            this.drawImage(id, x, 0);
            x += id.width;
        }
    }

    protected void drawTopRight(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = this.getSize().x;
        for (int i = 2; i >= 0; --i) {
            if (i >= length || overlays[i] == null) continue;
            ImageData id = overlays[i].getImageData();
            this.drawImage(id, x -= id.width, 0);
        }
    }

    protected Point getSize() {
        return this.fSize;
    }
}

