/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BinaryRelQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -5690656271650491000L;
    private int relOp;
    private ValueExp exp1;
    private ValueExp exp2;

    BinaryRelQueryExp(int operation, ValueExp exp1, ValueExp exp2) {
        this.relOp = operation;
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    public void setMBeanServer(MBeanServer server) {
        super.setMBeanServer(server);
        if (this.exp1 != null) {
            this.exp1.setMBeanServer(server);
        }
        if (this.exp2 != null) {
            this.exp2.setMBeanServer(server);
        }
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (this.exp1 == null && this.exp2 == null && (this.relOp == 4 || this.relOp == 2 || this.relOp == 3)) {
            return true;
        }
        if (this.exp1 != null && this.exp2 != null) {
            ValueExp val1 = this.exp1.apply(name);
            ValueExp val2 = this.exp2.apply(name);
            if (val1 instanceof NumericValueExp && val2 instanceof NumericValueExp) {
                NumericValueExp num1 = (NumericValueExp)val1;
                NumericValueExp num2 = (NumericValueExp)val2;
                if (num1.isDouble() || num2.isDouble()) {
                    return this.compare(new Double(num1.doubleValue()), new Double(num2.doubleValue()));
                }
                return this.compare(new Long(num1.longValue()), new Long(num2.longValue()));
            }
            if (val1 instanceof BooleanValueExp && val2 instanceof BooleanValueExp) {
                boolean b1 = ((BooleanValueExp)val1).booleanValue();
                boolean b2 = ((BooleanValueExp)val2).booleanValue();
                return this.compare(new Long(b1 ? 1L : 0L), new Long(b2 ? 1L : 0L));
            }
            if (val1 instanceof StringValueExp && val2 instanceof StringValueExp) {
                String s1 = ((StringValueExp)val1).getValue();
                String s2 = ((StringValueExp)val2).getValue();
                return this.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
            }
        }
        return false;
    }

    private boolean compare(Comparable c1, Comparable c2) {
        switch (this.relOp) {
            case 4: {
                if (c1 == null && c2 == null) {
                    return true;
                }
                if (c1 == null || c2 == null) {
                    return false;
                }
                return c1.equals(c2);
            }
            case 2: {
                if (c1 == null && c2 == null) {
                    return true;
                }
                if (c1 == null && c2 != null) {
                    return false;
                }
                if (c1 != null && c2 == null) {
                    return true;
                }
                return c1.compareTo(c2) >= 0;
            }
            case 3: {
                if (c1 == null && c2 == null) {
                    return true;
                }
                if (c1 == null && c2 != null) {
                    return true;
                }
                if (c1 != null && c2 == null) {
                    return false;
                }
                return c1.compareTo(c2) <= 0;
            }
            case 0: {
                if (c1 == null && c2 == null) {
                    return false;
                }
                if (c1 == null && c2 != null) {
                    return false;
                }
                if (c1 != null && c2 == null) {
                    return true;
                }
                return c1.compareTo(c2) > 0;
            }
            case 1: {
                if (c1 == null && c2 == null) {
                    return false;
                }
                if (c1 == null && c2 != null) {
                    return true;
                }
                if (c1 != null && c2 == null) {
                    return false;
                }
                return c1.compareTo(c2) < 0;
            }
        }
        return false;
    }
}

