/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSListener;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.AddToVersionControlDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.IRepositoryListener;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.ReleaseCommentDialog;
import org.eclipse.team.internal.ccvs.ui.XMLWriter;
import org.eclipse.team.internal.ccvs.ui.repo.CommentHistoryContentHandler;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesViewContentHandler;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.ui.IWorkingSet;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryManager {
    private static final String STATE_FILE = ".repositoryManagerState";
    private static final int STATE_FILE_VERSION_1 = -1;
    private static final String REPOSITORIES_VIEW_FILE = "repositoriesView.xml";
    private static final String COMMENT_HIST_FILE = "commitCommentHistory.xml";
    static final String ELEMENT_COMMIT_COMMENT = "CommitComment";
    static final String ELEMENT_COMMIT_HISTORY = "CommitComments";
    private Map repositoryRoots = new HashMap();
    List listeners = new ArrayList();
    static String[] previousComments = new String[0];
    public static boolean notifyRepoView = true;
    private int notificationLevel = 0;
    private Map changedRepositories = new HashMap();
    static final int MAX_COMMENTS = 10;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public ICVSRepositoryLocation[] getKnownRepositoryLocations() {
        return KnownRepositories.getInstance().getRepositories();
    }

    private RepositoryRoot[] getRepositoryRoots(ICVSRepositoryLocation[] locations) {
        ArrayList<RepositoryRoot> roots = new ArrayList<RepositoryRoot>();
        for (int i = 0; i < locations.length; ++i) {
            ICVSRepositoryLocation location = locations[i];
            RepositoryRoot root = this.getRepositoryRootFor(location);
            if (root == null) continue;
            roots.add(root);
        }
        return roots.toArray(new RepositoryRoot[roots.size()]);
    }

    public RepositoryRoot[] getKnownRepositoryRoots() {
        return this.getRepositoryRoots(this.getKnownRepositoryLocations());
    }

    public CVSTag[] getKnownTags(ICVSFolder project, int tagType) {
        try {
            CVSTag[] tags = this.getKnownTags(project);
            HashSet<CVSTag> result = new HashSet<CVSTag>();
            for (int i = 0; i < tags.length; ++i) {
                CVSTag tag = tags[i];
                if (tag.getType() != tagType) continue;
                result.add(tag);
            }
            return result.toArray(new CVSTag[result.size()]);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return new CVSTag[0];
        }
    }

    public CVSTag[] getKnownTags(ICVSRepositoryLocation location, int tagType) {
        HashSet<CVSTag> result = new HashSet<CVSTag>();
        RepositoryRoot root = (RepositoryRoot)((Object)this.repositoryRoots.get(location.getLocation()));
        if (root != null) {
            String[] paths = root.getKnownRemotePaths();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                CVSTag[] tags = root.getAllKnownTags(path);
                for (int j = 0; j < tags.length; ++j) {
                    CVSTag tag = tags[j];
                    if (tag.getType() != tagType) continue;
                    result.add(tag);
                }
            }
        }
        return result.toArray(new CVSTag[0]);
    }

    public CVSTag[] getKnownTags(ICVSRepositoryLocation repository, IWorkingSet set, int tagType, IProgressMonitor monitor) throws CVSException {
        if (set == null) {
            return this.getKnownTags(repository, tagType);
        }
        ICVSRemoteResource[] folders = this.getFoldersForTag(repository, CVSTag.DEFAULT, monitor);
        folders = this.filterResources(set, folders);
        HashSet<CVSTag> tags = new HashSet<CVSTag>();
        for (int i = 0; i < folders.length; ++i) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)folders[i];
            tags.addAll(Arrays.asList(this.getKnownTags((ICVSFolder)folder, tagType)));
        }
        return tags.toArray(new CVSTag[tags.size()]);
    }

    public CVSTag[] getKnownTags(ICVSFolder project) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        return root.getAllKnownTags(remotePath);
    }

    public Map getKnownProjectsAndVersions(ICVSRepositoryLocation location) {
        HashMap knownTags = new HashMap();
        RepositoryRoot root = this.getRepositoryRootFor(location);
        String[] paths = root.getKnownRemotePaths();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            HashSet<CVSTag> result = new HashSet<CVSTag>();
            result.addAll(Arrays.asList(root.getAllKnownTags(path)));
            knownTags.put(path, result);
        }
        return knownTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICVSRemoteResource[] getFoldersForTag(ICVSRepositoryLocation location, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Policy.bind("RepositoryManager.fetchingRemoteFolders", tag.getName()), 100);
            if (tag.getType() == 0) {
                ICVSRemoteResource[] resources = location.members(tag, false, Policy.subMonitorFor(monitor, 60));
                RepositoryRoot root = this.getRepositoryRootFor(location);
                ICVSRemoteResource[] modules = root.getDefinedModules(tag, Policy.subMonitorFor(monitor, 40));
                ICVSRemoteResource[] result = new ICVSRemoteResource[resources.length + modules.length];
                System.arraycopy(resources, 0, result, 0, resources.length);
                System.arraycopy(modules, 0, result, resources.length, modules.length);
                ICVSRemoteResource[] iCVSRemoteResourceArray = result;
                return iCVSRemoteResourceArray;
            }
            if (tag.getType() == 3) {
                ICVSRemoteResource[] resources = location.members(tag, false, Policy.subMonitorFor(monitor, 60));
                RepositoryRoot root = this.getRepositoryRootFor(location);
                ICVSRemoteResource[] modules = root.getDefinedModules(tag, Policy.subMonitorFor(monitor, 40));
                ICVSRemoteResource[] result = new ICVSRemoteResource[resources.length + modules.length];
                System.arraycopy(resources, 0, result, 0, resources.length);
                System.arraycopy(modules, 0, result, resources.length, modules.length);
                ICVSRemoteResource[] iCVSRemoteResourceArray = result;
                return iCVSRemoteResourceArray;
            }
            HashSet<ICVSRemoteFolder> result = new HashSet<ICVSRemoteFolder>();
            RepositoryRoot root = this.getRepositoryRootFor(location);
            String[] paths = root.getKnownRemotePaths();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                List<CVSTag> tags = Arrays.asList(root.getAllKnownTags(path));
                if (!tags.contains(tag)) continue;
                ICVSRemoteFolder remote = root.getRemoteFolder(path, tag, Policy.subMonitorFor(monitor, 100));
                result.add(remote);
            }
            ICVSRemoteResource[] iCVSRemoteResourceArray = result.toArray(new ICVSRemoteResource[result.size()]);
            return iCVSRemoteResourceArray;
        }
        finally {
            monitor.done();
        }
    }

    public void refreshDefinedTags(ICVSFolder project, boolean replace, boolean notify, IProgressMonitor monitor) throws TeamException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        root.refreshDefinedTags(remotePath, replace, monitor);
        if (notify) {
            this.broadcastRepositoryChange(root);
        }
    }

    public void rootAdded(ICVSRepositoryLocation root) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            IRepositoryListener listener = (IRepositoryListener)it.next();
            listener.repositoryAdded(root);
        }
    }

    public void rootRemoved(ICVSRepositoryLocation root) {
        RepositoryRoot repoRoot = (RepositoryRoot)((Object)this.repositoryRoots.remove(root.getLocation()));
        if (repoRoot != null) {
            this.broadcastRepositoryChange(repoRoot);
        }
    }

    public void addTags(ICVSResource resource, CVSTag[] tags) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor(resource);
        String remotePath = RepositoryRoot.getRemotePathFor(resource);
        root.addTags(remotePath, tags);
        this.broadcastRepositoryChange(root);
    }

    public void addDateTag(ICVSRepositoryLocation location, CVSTag tag) {
        if (tag == null) {
            return;
        }
        RepositoryRoot root = this.getRepositoryRootFor(location);
        root.addDateTag(tag);
        this.broadcastRepositoryChange(root);
    }

    public void removeDateTag(ICVSRepositoryLocation location, CVSTag tag) {
        RepositoryRoot root = this.getRepositoryRootFor(location);
        root.removeDateTag(tag);
        this.broadcastRepositoryChange(root);
    }

    public void setAutoRefreshFiles(ICVSFolder project, String[] filePaths) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        root.setAutoRefreshFiles(remotePath, filePaths);
    }

    public void removeAutoRefreshFiles(ICVSFolder project, String[] relativeFilePaths) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(root.getAutoRefreshFiles(remotePath)));
        set.removeAll(Arrays.asList(relativeFilePaths));
        root.setAutoRefreshFiles(remotePath, set.toArray(new String[set.size()]));
    }

    public String[] getAutoRefreshFiles(ICVSFolder project) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        return root.getAutoRefreshFiles(remotePath);
    }

    public void removeTags(ICVSFolder project, CVSTag[] tags) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        root.removeTags(remotePath, tags);
        this.broadcastRepositoryChange(root);
    }

    public void startup() throws TeamException {
        this.loadState();
        this.loadCommentHistory();
        CVSProviderPlugin.getPlugin().addRepositoryListener(new ICVSListener(){

            public void repositoryAdded(ICVSRepositoryLocation root) {
                RepositoryManager.this.rootAdded(root);
            }

            public void repositoryRemoved(ICVSRepositoryLocation root) {
                RepositoryManager.this.rootRemoved(root);
            }
        });
    }

    public void shutdown() throws TeamException {
        this.saveState();
        this.saveCommentHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadState() throws TeamException {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation().append(REPOSITORIES_VIEW_FILE);
        File file = pluginStateLocation.toFile();
        if (file.exists()) {
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                try {
                    this.readState(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                CVSUIPlugin.log(4, Policy.bind("RepositoryManager.ioException"), e);
            }
            catch (TeamException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        } else {
            IPath oldPluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation().append(STATE_FILE);
            file = oldPluginStateLocation.toFile();
            if (file.exists()) {
                try {
                    DataInputStream dis = new DataInputStream(new FileInputStream(file));
                    try {
                        this.readOldState(dis);
                    }
                    finally {
                        dis.close();
                    }
                    this.saveState();
                    file.delete();
                }
                catch (IOException e) {
                    CVSUIPlugin.log(4, Policy.bind("RepositoryManager.ioException"), e);
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCommentHistory() throws TeamException {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation().append(COMMENT_HIST_FILE);
        File file = pluginStateLocation.toFile();
        if (!file.exists()) {
            return;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                this.readCommentHistory(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            CVSUIPlugin.log(4, Policy.bind("RepositoryManager.ioException"), e);
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveState() throws TeamException {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append("repositoriesView.xml.tmp").toFile();
        File stateFile = pluginStateLocation.append(REPOSITORIES_VIEW_FILE).toFile();
        try {
            boolean renamed;
            XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(tempFile)));
            try {
                this.writeState(writer);
            }
            finally {
                writer.close();
            }
            if (stateFile.exists()) {
                stateFile.delete();
            }
            if (!(renamed = tempFile.renameTo(stateFile))) {
                throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, Policy.bind("RepositoryManager.rename", tempFile.getAbsolutePath()), null));
            }
        }
        catch (IOException e) {
            throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, Policy.bind("RepositoryManager.save", stateFile.getAbsolutePath()), (Throwable)e));
        }
    }

    private void writeState(XMLWriter writer) throws IOException, CVSException {
        writer.startTag("repositories-view", null, true);
        List<ICVSRepositoryLocation> repos = Arrays.asList(this.getKnownRepositoryLocations());
        Iterator it = repos.iterator();
        while (it.hasNext()) {
            CVSRepositoryLocation location = (CVSRepositoryLocation)it.next();
            RepositoryRoot root = this.getRepositoryRootFor((ICVSRepositoryLocation)location);
            root.writeState(writer);
        }
        writer.endTag("repositories-view");
    }

    private void readState(InputStream stream) throws IOException, TeamException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(stream), (DefaultHandler)new RepositoriesViewContentHandler(this));
        }
        catch (SAXException ex) {
            throw new CVSException(Policy.bind("RepositoryManager.parsingProblem", REPOSITORIES_VIEW_FILE), (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new CVSException(Policy.bind("RepositoryManager.parsingProblem", REPOSITORIES_VIEW_FILE), (Throwable)ex);
        }
    }

    private void readCommentHistory(InputStream stream) throws IOException, TeamException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(stream), (DefaultHandler)new CommentHistoryContentHandler());
        }
        catch (SAXException ex) {
            throw new CVSException(Policy.bind("RepositoryManager.parsingProblem", COMMENT_HIST_FILE), (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new CVSException(Policy.bind("RepositoryManager.parsingProblem", COMMENT_HIST_FILE), (Throwable)ex);
        }
    }

    private void readOldState(DataInputStream dis) throws IOException, TeamException {
        int repoSize = dis.readInt();
        boolean version1 = false;
        if (repoSize == -1) {
            version1 = true;
            repoSize = dis.readInt();
        }
        for (int i = 0; i < repoSize; ++i) {
            ICVSRepositoryLocation root = KnownRepositories.getInstance().getRepository(dis.readUTF());
            RepositoryRoot repoRoot = this.getRepositoryRootFor(root);
            int tagsSize = dis.readInt();
            CVSTag[] branchTags = new CVSTag[tagsSize];
            for (int j = 0; j < tagsSize; ++j) {
                String tagName = dis.readUTF();
                int tagType = dis.readInt();
                branchTags[j] = new CVSTag(tagName, tagType);
            }
            int projSize = dis.readInt();
            if (projSize > 0) {
                for (int j = 0; j < projSize; ++j) {
                    String name = dis.readUTF();
                    HashSet<CVSTag> tagSet = new HashSet<CVSTag>();
                    int numTags = dis.readInt();
                    for (int k = 0; k < numTags; ++k) {
                        tagSet.add(new CVSTag(dis.readUTF(), 2));
                    }
                    CVSTag[] tags = tagSet.toArray(new CVSTag[tagSet.size()]);
                    repoRoot.addTags(name, tags);
                }
            }
            if (version1) {
                try {
                    projSize = dis.readInt();
                    if (projSize > 0) {
                        for (int j = 0; j < projSize; ++j) {
                            String name = dis.readUTF();
                            HashSet<String> filenames = new HashSet<String>();
                            int numFilenames = dis.readInt();
                            for (int k = 0; k < numFilenames; ++k) {
                                filenames.add(name + "/" + dis.readUTF());
                            }
                            repoRoot.setAutoRefreshFiles(name, filenames.toArray(new String[filenames.size()]));
                        }
                    }
                }
                catch (EOFException e) {
                    // empty catch block
                }
            }
            this.broadcastRepositoryChange(repoRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCommentHistory() throws TeamException {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append("commitCommentHistory.xml.tmp").toFile();
        File histFile = pluginStateLocation.append(COMMENT_HIST_FILE).toFile();
        try {
            boolean renamed;
            XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(tempFile)));
            try {
                this.writeCommentHistory(writer);
            }
            finally {
                writer.close();
            }
            if (histFile.exists()) {
                histFile.delete();
            }
            if (!(renamed = tempFile.renameTo(histFile))) {
                throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, Policy.bind("RepositoryManager.rename", tempFile.getAbsolutePath()), null));
            }
        }
        catch (IOException e) {
            throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, Policy.bind("RepositoryManager.save", histFile.getAbsolutePath()), (Throwable)e));
        }
    }

    private void writeCommentHistory(XMLWriter writer) throws IOException, CVSException {
        writer.startTag(ELEMENT_COMMIT_HISTORY, null, false);
        for (int i = 0; i < previousComments.length && i < 10; ++i) {
            writer.printSimpleTag(ELEMENT_COMMIT_COMMENT, previousComments[i]);
        }
        writer.endTag(ELEMENT_COMMIT_HISTORY);
    }

    public void addRepositoryListener(IRepositoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeRepositoryListener(IRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    private String getCurrentComment() {
        if (previousComments.length == 0) {
            return "";
        }
        return previousComments[0];
    }

    public String promptForComment(Shell shell, IResource[] resourcesToCommit) {
        final int[] result = new int[1];
        final ReleaseCommentDialog dialog = new ReleaseCommentDialog(shell, resourcesToCommit, 2);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = dialog.open();
                if (result[0] != 0) {
                    return;
                }
            }
        });
        if (result[0] != 0) {
            return null;
        }
        return dialog.getComment();
    }

    public IResource[] promptForResourcesToBeAdded(Shell shell, IResource[] unadded) {
        if (unadded == null) {
            return new IResource[0];
        }
        if (unadded.length == 0) {
            return unadded;
        }
        final IResource[][] result = new IResource[1][0];
        result[0] = null;
        final AddToVersionControlDialog dialog = new AddToVersionControlDialog(shell, unadded);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                int code = dialog.open();
                if (code == 2) {
                    result[0] = dialog.getResourcesToAdd();
                } else if (code == 3) {
                    result[0] = new IResource[0];
                }
            }
        });
        return result[0];
    }

    public ICVSRepositoryLocation getRepositoryLocationFor(ICVSResource resource) {
        try {
            return this.internalGetRepositoryLocationFor(resource);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    private ICVSRepositoryLocation internalGetRepositoryLocationFor(ICVSResource resource) throws CVSException {
        ICVSFolder folder = resource.isFolder() ? (ICVSFolder)resource : resource.getParent();
        if (folder.isCVSFolder()) {
            ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(folder.getFolderSyncInfo().getRoot());
            return location;
        }
        return null;
    }

    private RepositoryRoot getRepositoryRootFor(ICVSResource resource) throws CVSException {
        ICVSRepositoryLocation location = this.internalGetRepositoryLocationFor(resource);
        if (location == null) {
            return null;
        }
        return this.getRepositoryRootFor(location);
    }

    public RepositoryRoot getRepositoryRootFor(ICVSRepositoryLocation location) {
        RepositoryRoot root = (RepositoryRoot)((Object)this.repositoryRoots.get(location.getLocation()));
        if (root == null) {
            root = new RepositoryRoot(location);
            this.add(root);
        }
        return root;
    }

    public void add(RepositoryRoot root) {
        this.repositoryRoots.put(root.getRoot().getLocation(), root);
        this.broadcastRepositoryChange(root);
    }

    private void broadcastRepositoryChange(RepositoryRoot root) {
        if (this.notificationLevel == 0) {
            this.broadcastRepositoriesChanged(new ICVSRepositoryLocation[]{root.getRoot()});
        } else {
            this.changedRepositories.put(root.getRoot().getLocation(), root.getRoot());
        }
    }

    private void broadcastRepositoriesChanged(ICVSRepositoryLocation[] roots) {
        if (roots.length == 0) {
            return;
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            IRepositoryListener listener = (IRepositoryListener)it.next();
            listener.repositoriesChanged(roots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IRunnableWithProgress runnable, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ++this.notificationLevel;
            runnable.run(monitor);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.notificationLevel = Math.max(0, this.notificationLevel - 1);
            if (this.notificationLevel == 0) {
                try {
                    Collection roots = this.changedRepositories.values();
                    this.broadcastRepositoriesChanged(roots.toArray(new ICVSRepositoryLocation[roots.size()]));
                }
                finally {
                    this.changedRepositories.clear();
                }
            }
            throw throwable;
        }
        this.notificationLevel = Math.max(0, this.notificationLevel - 1);
        if (this.notificationLevel == 0) {
            try {
                Collection roots = this.changedRepositories.values();
                this.broadcastRepositoriesChanged(roots.toArray(new ICVSRepositoryLocation[roots.size()]));
            }
            finally {
                this.changedRepositories.clear();
            }
        }
    }

    public boolean isDisplayingProjectVersions(ICVSRepositoryLocation repository) {
        return true;
    }

    public ICVSRemoteResource[] filterResources(IWorkingSet workingSet, ICVSRemoteResource[] resources) {
        if (workingSet == null) {
            return resources;
        }
        IAdaptable[] adaptables = workingSet.getElements();
        HashSet<IProject> projects = new HashSet<IProject>();
        for (int i = 0; i < adaptables.length; ++i) {
            IAdaptable adaptable = adaptables[i];
            Object adapted = adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? RepositoryManager.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
            if (adapted == null) continue;
            IProject project = ((IResource)adapted).getProject();
            projects.add(project);
        }
        ArrayList<ICVSRemoteResource> result = new ArrayList<ICVSRemoteResource>();
        block1: for (int i = 0; i < resources.length; ++i) {
            ICVSRemoteResource resource = resources[i];
            Iterator iter = projects.iterator();
            while (iter.hasNext()) {
                IProject project = (IProject)iter.next();
                if (!project.getName().equals(resource.getName())) continue;
                result.add(resource);
                continue block1;
            }
        }
        return result.toArray(new ICVSRemoteResource[result.size()]);
    }

    public void setLabel(CVSRepositoryLocation location, String label) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSRepositoryLocation)location);
        String oldLabel = root.getName();
        if (oldLabel == null) {
            if (label == null) {
                return;
            }
            root.setName(label);
        } else if (label == null) {
            root.setName(label);
        } else {
            if (label.equals(oldLabel)) {
                return;
            }
            root.setName(label);
        }
        this.broadcastRepositoryChange(root);
    }

    public void replaceRepositoryLocation(final ICVSRepositoryLocation oldLocation, final CVSRepositoryLocation newLocation) {
        try {
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    RepositoryRoot root = RepositoryManager.this.getRepositoryRootFor(oldLocation);
                    KnownRepositories.getInstance().disposeRepository(oldLocation);
                    boolean isNew = !KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation());
                    root.setRepositoryLocation(KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)newLocation, isNew));
                    RepositoryManager.this.add(root);
                }
            }, Policy.monitorFor(null));
        }
        catch (InvocationTargetException e) {
            CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void purgeCache() {
        Iterator iter = this.repositoryRoots.values().iterator();
        while (iter.hasNext()) {
            RepositoryRoot root = (RepositoryRoot)((Object)iter.next());
            root.clearCache();
        }
    }

    public String[] getPreviousComments() {
        return previousComments;
    }

    public void addComment(String comment) {
        if (this.containsComment(comment)) {
            return;
        }
        String[] newComments = new String[Math.min(previousComments.length + 1, 10)];
        newComments[0] = comment;
        for (int i = 1; i < newComments.length; ++i) {
            newComments[i] = previousComments[i - 1];
        }
        previousComments = newComments;
    }

    private boolean containsComment(String comment) {
        for (int i = 0; i < previousComments.length; ++i) {
            if (!previousComments[i].equals(comment)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

