/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.GroupEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteStackEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.TemplateEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.swt.events.KeyEvent;

public class PaletteViewerKeyHandler
extends GraphicalViewerKeyHandler {
    public PaletteViewerKeyHandler(PaletteViewer viewer) {
        super(viewer);
    }

    private boolean acceptCollapseDrawer(KeyEvent event) {
        return event.keyCode == 0x1000003 && this.isExpandedDrawer(this.getFocusEditPart());
    }

    private boolean acceptExpandDrawer(KeyEvent event) {
        return event.keyCode == 0x1000004 && this.isCollapsedDrawer(this.getFocusEditPart());
    }

    private boolean acceptIntoExpandedDrawer(KeyEvent event) {
        return (event.keyCode == 0x1000002 || event.keyCode == 0x1000004) && this.isExpandedDrawer(this.getFocusEditPart());
    }

    private boolean acceptOpenContextMenu(KeyEvent event) {
        return event.keyCode == 0x1000002 && (event.stateMask & 0x10000) > 0 && this.isContextMenu(this.getFocusEditPart());
    }

    private boolean acceptSetFocusOnDrawer(KeyEvent event) {
        return (event.keyCode == 0x1000003 || event.keyCode == 0x1000001) && (this.getFocusEditPart().getParent() instanceof PaletteStackEditPart && this.getFocusEditPart().getParent().getParent() instanceof DrawerEditPart || this.getFocusEditPart().getParent() instanceof DrawerEditPart);
    }

    private boolean acceptNextContainer(KeyEvent event) {
        return event.keyCode == 0x1000002;
    }

    private void buildNavigationList(EditPart palettePart, EditPart exclusion, ArrayList navList, EditPart stackPart) {
        if (palettePart != exclusion) {
            if (this.isCollapsedDrawer(palettePart)) {
                navList.add(palettePart);
                return;
            }
            if (stackPart instanceof PaletteStackEditPart && stackPart.getChildren().contains(palettePart)) {
                if (((PaletteStack)((PaletteStackEditPart)stackPart).getModel()).getActiveEntry().equals(palettePart.getModel())) {
                    navList.add(palettePart);
                }
            } else if (palettePart instanceof ToolEntryEditPart || palettePart instanceof DrawerEditPart || palettePart instanceof TemplateEditPart) {
                navList.add(palettePart);
            }
        }
        int k = 0;
        while (k < palettePart.getChildren().size()) {
            EditPart ep = (EditPart)palettePart.getChildren().get(k);
            if (ep instanceof PaletteStackEditPart) {
                stackPart = ep;
            }
            this.buildNavigationList(ep, exclusion, navList, stackPart);
            ++k;
        }
    }

    private void collapseDrawer() {
        DrawerEditPart drawer = (DrawerEditPart)this.getFocusEditPart();
        drawer.setExpanded(false);
    }

    private void expandDrawer() {
        DrawerEditPart drawer = (DrawerEditPart)this.getFocusEditPart();
        drawer.setExpanded(true);
    }

    protected Point getNavigationPoint(IFigure figure) {
        return figure.getBounds().getTopLeft();
    }

    protected List getNavigationSiblings() {
        ArrayList<GraphicalEditPart> siblingsList = new ArrayList<GraphicalEditPart>();
        GraphicalEditPart focusPart = this.getFocusEditPart();
        EditPart parent = focusPart.getParent();
        if (parent == null) {
            siblingsList.add(focusPart);
            return siblingsList;
        }
        if (parent instanceof GroupEditPart || parent instanceof PaletteStackEditPart) {
            EditPart grandParent = parent.getParent();
            this.buildNavigationList(grandParent, grandParent, siblingsList, grandParent);
        } else {
            this.buildNavigationList(parent, parent, siblingsList, parent);
        }
        return siblingsList;
    }

    boolean isCollapsedDrawer(EditPart part) {
        return part instanceof DrawerEditPart && !((DrawerEditPart)part).isExpanded();
    }

    boolean isExpandedDrawer(EditPart part) {
        return part instanceof DrawerEditPart && ((DrawerEditPart)part).isExpanded();
    }

    boolean isContextMenu(EditPart part) {
        return part.getParent() instanceof PaletteStackEditPart;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.acceptExpandDrawer(event)) {
            this.expandDrawer();
            return true;
        }
        if (this.acceptCollapseDrawer(event)) {
            this.collapseDrawer();
            return true;
        }
        if (this.acceptOpenContextMenu(event)) {
            this.openContextMenu();
            return true;
        }
        if (this.acceptIntoExpandedDrawer(event) && this.navigateIntoExpandedDrawer(event)) {
            return true;
        }
        if (super.keyPressed(event)) {
            return true;
        }
        if (this.acceptSetFocusOnDrawer(event) && this.navigateToDrawer(event)) {
            return true;
        }
        return this.acceptNextContainer(event) && this.navigateToNextContainer(event);
    }

    private boolean navigateIntoExpandedDrawer(KeyEvent event) {
        ArrayList potentials = new ArrayList();
        this.buildNavigationList(this.getFocusEditPart(), this.getFocusEditPart(), potentials, this.getFocusEditPart());
        if (!potentials.isEmpty()) {
            this.navigateTo((EditPart)potentials.get(0), event);
            return true;
        }
        return false;
    }

    protected void navigateTo(EditPart part, KeyEvent event) {
        if (part == null) {
            return;
        }
        this.getViewer().select(part);
        this.getViewer().reveal(part);
    }

    private boolean navigateToDrawer(KeyEvent event) {
        boolean found = false;
        EditPart parent = this.getFocusEditPart().getParent();
        while (parent != null && !found) {
            if (parent instanceof DrawerEditPart) {
                this.navigateTo(parent, event);
                found = true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private boolean navigateToNextContainer(KeyEvent event) {
        EditPart current = this.getFocusEditPart();
        while (current != null) {
            if (current instanceof DrawerEditPart || current instanceof GroupEditPart) {
                List siblings = current.getParent().getChildren();
                int index = siblings.indexOf(current);
                if (index != -1 && siblings.size() > index + 1) {
                    EditPart part = (EditPart)siblings.get(index + 1);
                    if (part instanceof GroupEditPart && part.getChildren().size() > 0) {
                        EditPart child = (EditPart)part.getChildren().get(0);
                        this.navigateTo(child, event);
                    } else {
                        this.navigateTo(part, event);
                    }
                    return true;
                }
                return false;
            }
            current = current.getParent();
        }
        return false;
    }

    private void openContextMenu() {
        ((PaletteStackEditPart)this.getFocusEditPart().getParent()).openMenu();
    }
}

