/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.rose2ecore;

import java.util.List;
import org.eclipse.emf.codegen.ecore.rose2ecore.RoseUtil;
import org.eclipse.emf.codegen.ecore.rose2ecore.TableObject;
import org.eclipse.emf.codegen.ecore.rose2ecore.UnitTreeNode;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseNode;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.Util;

public class UnitTreeBuilder {
    protected UnitTreeNode topNode;
    protected RoseUtil roseUtil;

    public UnitTreeBuilder(RoseUtil roseUtil) {
        this.roseUtil = roseUtil;
    }

    public void traverse(String qualifier, RoseNode tree, UnitTreeNode unitNode) throws Exception {
        this.topNode = unitNode;
        List nodes = tree.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            RoseNode node = (RoseNode)nodes.get(i);
            if (node.getRoseNodeType() == 2) {
                this.traverseObject(qualifier, node, unitNode);
            } else if (node.getRoseNodeType() == 3) {
                this.traverseList(qualifier, node, unitNode);
            }
            ++i;
        }
    }

    private void traverseObject(String qualifier, RoseNode tree, UnitTreeNode unitNode) throws Exception {
        String objKey = tree.getKey();
        String objType = Util.getType(tree.getValue());
        String objName = Util.getName(tree.getValue());
        if (objKey.equals("root_category") && objType.equals("Class_Category")) {
            String quid = unitNode.getQUID();
            if (quid.equals("")) {
                quid = tree.getRoseId();
                quid = quid != null ? quid.substring(1, quid.length() - 1) : "";
            }
            if (!quid.equals("")) {
                unitNode.setQUID(quid);
            }
            unitNode.setRoseNode(tree);
            this.traverse(qualifier, tree, unitNode);
        } else if (objKey.equals("") && objType.equals("Class_Category")) {
            RoseNode loadingNode = tree.findNodeWithKey("is_loaded");
            String quid = tree.getRoseId();
            if (quid != null) {
                quid = quid.substring(1, quid.length() - 1);
            }
            if (loadingNode != null) {
                RoseNode fileNameNode = tree.findNodeWithKey("file_name");
                String fileNameNodeValue = fileNameNode.getValue();
                String fileName = this.roseUtil.resolveFileName(fileNameNodeValue);
                UnitTreeNode unitTreeNode = new UnitTreeNode(objName, quid, fileName);
                unitNode.addNode(unitTreeNode);
                this.roseUtil.createRoseUnitTreeAndTable(fileNameNodeValue, unitTreeNode);
            } else {
                String qualifiedName = objName;
                if (qualifier != null) {
                    qualifiedName = String.valueOf(qualifier) + "." + objName;
                }
                TableObject obj = new TableObject(qualifiedName, quid, this.topNode);
                this.roseUtil.quidTable.put(quid, obj);
                if (qualifier != null) {
                    this.roseUtil.nameTable.put(qualifiedName, obj);
                }
                this.roseUtil.nameTable.put(objName, obj);
                unitNode.setRoseNode(tree);
                this.traverse(qualifiedName, tree, unitNode);
            }
        } else if (objType.equals("Class")) {
            String quid = tree.getRoseId();
            if (quid != null) {
                quid = quid.substring(1, quid.length() - 1);
            }
            String qualifiedName = objName;
            if (qualifier != null) {
                qualifiedName = String.valueOf(qualifier) + "." + objName;
            }
            TableObject obj = new TableObject(qualifiedName, quid, this.topNode);
            this.roseUtil.quidTable.put(quid, obj);
            this.roseUtil.nameTable.put(objName, obj);
            if (qualifiedName != null) {
                this.roseUtil.nameTable.put(qualifiedName, obj);
            }
            this.traverse(qualifiedName, tree, unitNode);
        } else if (objType.equals("Operation") || objType.equals("ClassAttribute") || objType.equals("Inheritance_Relationship") || objType.equals("Association") || objType.equals("Role") || objType.equals("Visibility_Relationship") || objType.equals("Uses_Relationship")) {
            this.traverse(qualifier, tree, unitNode);
        }
    }

    private void traverseList(String qualifier, RoseNode tree, UnitTreeNode unitNode) throws Exception {
        this.traverse(qualifier, tree, unitNode);
    }
}

