<?php

require_once 'Horde.php';

/**
 * The Text_Filter_emoticons:: class finds emoticon strings ( :), etc.) in a
 * block of text and turns them into image links.
 *
 * Parameters:
 * <pre>
 * entities -- If true the html entity versions of the patterns will be used.
 * </pre>
 *
 * $Horde: framework/Text_Filter/Filter/emoticons.php,v 1.17.10.2 2005/01/11 20:44:48 chuck Exp $
 *
 * Copyright 2003-2005 Marko Djukic <marko@oblo.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you did not
 * receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Marko Djukic <marko@oblo.com>
 * @package Horde_Text
 */
class Text_Filter_emoticons extends Text_Filter {

    /**
     * Filter parameters.
     *
     * @var array $_params
     */
    var $_params = array('entities' => false);

    /**
     * Returns a hash with replace patterns.
     *
     * @return array  Patterns hash.
     */
    function getPatterns()
    {
        $regexp = array();
        $iconpath = $GLOBALS['registry']->getImageDir('horde') . '/emoticons';

        /* Loop through possible string emoticons and convert to graphics. */
        foreach ($this->getIcons() as $string => $icon) {
            if ($this->_params['entities']) {
                $string = htmlspecialchars($string);
            }

            /* Check for a smiley either immediately at the start of a line or
             * following a space. Use {} as the preg delimiters as this is not
             * found in any smiley. */
            $regexp['{(^|\s)' . preg_quote($string) . '}'] = ' ' . Horde::img($icon . '.png', $string, 'align="middle"', $iconpath);
        }

        return array('regexp' => $regexp);
    }

    /**
     * Returns a hash with emoticons and names.
     *
     * @return array  Patterns hash.
     */
    function getIcons()
    {
        /* List complex strings before simpler ones, otherwise for example :((
         * would be matched against :( before :(( is found. */
        return array(
            ':/' => 'frustrated', ':-/' => 'frustrated',
            // ':*>' => 'blush',
            ':e' => 'disappointed',
            '=:)$' => 'mrt',
            '#|' => 'hangover', '#-|' => 'hangover',
            ':-@' => 'shout',
            ':((' => 'bigfrown', ':C' => 'bigfrown',
            ':S' => 'dazed', ':-S' => 'dazed',
            'X@' => 'angry',
            'X(' => 'mad',
            // '>:)' => 'devil', '>:-)' => 'devil',
            // '>:p' => 'deviltongue', '>:-p' => 'deviltongue',
            // '>:p' => 'raspberry', '>:P' => 'raspberry',
            // '&)' => 'punk',
            // '&p' => 'punktongue',
            // '=&)' => 'punkmohawk',
            ':]' => 'grin',
            '#[' => 'hurt', '#(' => 'hurt', '#-[' => 'hurt', '#-(' => 'hurt',
            ':O' => 'embarrassed', ':-O' => 'embarrassed',
            ':[' => 'sad',
            // '>:@' => 'enraged',
            // ':&' => 'annoyed',
            '=(' => 'worried', '=-(' => 'worried',
            ':|=' => 'vampire',
            ':-(' => 'frown',
            ':D' => 'biggrin',
            '8)' => 'cool',
            '8p' => 'cooltongue', // '8' => 'cooltongue',
            '8D' => 'coolgrin',
            ':p' => 'tongueout', ':P' => 'tongueout', // ':' => 'tongueout',
            '?:(' => 'confused', '%-(' => 'confused',
            // ':)&' => 'love',
            'O;-)' => 'angelwink',
            ';]' => 'winkgrin',
            ';p' => 'winktongue', ';P' => 'winktongue', // ';' => 'winktongue',
            ':|' => 'indifferent', ':-|' => 'indifferent',
            '!|' => 'tired', '!-I' => 'tired',
            '|I' => 'asleep', '|-I' => 'asleep',
            'O:)' => 'angel', 'O:-)' => 'angel',
            'O;)' => 'angelwink',
            ';-)' => 'wink',
            ':#)' => 'clown', ':o)' => 'clown',
            ':)' => 'smile',
            ';)' => 'wink',
            ':-)' => 'smile',
            ':@' => 'shout',
            ':(' => 'frown',
        );
    }

}
