#
# This script is (C) Tenable Network Security
#
#




if(description)
{
 script_id(14836);
 script_bugtraq_id(11268);
 script_version ("$Revision: 1.2 $");

 name["english"] = "WordPress XSS";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running WordPress, a new page/weblogs PHP generation
tool.

The remote version of this software is vulnerable to a cross-site-scripting
issue due to a failure of the application to properly sanitize user-supplied 
URI input.

As a result of this vulnerability, it is possible for a remote attacker
to create a malicious link containing script code that will be executed 
in the browser of an unsuspecting user when followed. 

This may facilitate the theft of cookie-based authentication credentials 
as well as other attacks.


Solution : Upgrade to the latest version of this software
Risk factor : Medium";




 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of WordPress";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security",
		francais:"Ce script est Copyright (C) 2004 Tenable Network Security");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);



function check(loc)
{
 req = http_get(item:string(loc, "/wp-login.php?redirect_to=<script>foo</script>"),
 		port:port);			
 r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( r == NULL )exit(0);
 if( "<script>foo</script>" >< r &&
     '<form name="login" id="loginform" action="wp-login.php" method="post">' >< r )
 {
 	security_warning(port);
	exit(0);
 }
}




foreach dir ( cgi_dirs() )
{
 check(loc:dir);
}
