#TRUSTED 4bac3173da913ae5bae414334114b93ca748941de93443a40d555c37973dced323dc95206e008c78d873fbdd67ba5ca88cfdc142e83d9ec28c0ebf426b3e111a576070bd69f8682999a1366646a237a5107e79406562c36912adf58180f659c8e6652c2e592596cf2408a076c38880dddcfe4470637afe7ec05b8245ce193fedb3f0b5cb0d454549a9cc11c21d0989edc40a5a0f1b44937f9d3fce4e39b44fe0c237d7d05f8ba6d1577dfab4631ef536769489e035269727922e3e0d37cd084f9388f6a3a18d0e886769c2712bc938f86fceae40d9aa894b948f201dcb0d6a82c9a39877bf386099041eea8b8983c37245bfb00d5c6050ae75d082a5ac1233ae09266ac362f9f8472c2689eca83b6fbf44530ed6a629639bf68263fdc26f340fd2cc212672d23ac034f3951fa1fbe7ec1d01ae849d7b067e883d6aab11bdcef0e1babb06bad03c2776ea11eb2472e3659359649a5316d666f0592ad52a3099f8bec39ebc8df25f707fc90988bbd10ab44a8d14454379394f61462399dcff5ccecd22d2fef9f4ed03d8d0592e4cab2696e1e548b24d44206b16bb6f7911107451b76eca504f7e43036ae13db06dcbde7638df07acbece81245b3c04ec12967ce271988043bfe5494b3c0c8be0bd98e5cdfa645e71304df6aab1ad676e0d27ad872ea8c13b656534cd0c1796baa57be050f62f3df7399f6911669cbfb72e35e88d
#
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12634);
 script_version ("1.18");
 name["english"] = "Enable local security checks";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
This scripts logs into the remote host using SSH or local commands
and extracts the list of installed packages. To work properly, this 
script requires that you configure it with a valid SSH public key to use and
eventually an SSH passphrase if the SSH public key is passphrase-protected or
that you run it against localhost.";


 script_description(english:desc["english"]);
 
 summary["english"] = "Obtains the remote OS name and installed packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "General";
 script_family(english:family["english"]);
 
 script_dependencies("find_service.nes", "ssh_settings.nasl");
 script_require_keys("Secret/SSH/login");
 script_require_ports(22, "Services/ssh");
 exit(0);
}


include("ssh_func.inc");

 __gs_opt = get_kb_item("global_settings/report_verbosity");
 if (__gs_opt)
        {
        if ("Verbose" >< __gs_opt) report_verbosity = 2;
        else if ("Normal" >< __gs_opt) report_verbosity = 1;
        else if ("Quiet" >< __gs_opt) report_verbosity = 0;
        }


report = "";

if ( ! islocalhost() )
{
port = kb_ssh_transport();
sock = ssh_login_or_reuse_connection();
if ( ! sock ) 
{
  if ( report_verbosity > 1 )
  {
   report = 'It was not possible to log into the remote host.'; 
   err = get_ssh_error();
   if (err)
    report += ' Nessus report the following error :\n' + err + '\n';
   security_note(port:port, data:report);
  }
  exit(0);
}


if ( private_key )
	report = "It was possible to log into the remote host using the supplied asymetric keys"; 
else
	report = "It was possible to log into the remote host using the supplied password"; 


# Determine the remote operating system type

buf = ssh_cmd(socket:sock,cmd:"cmd /C ver");
}

#------------------------------[ WINDOWS ]-----------------------------------------------#
if ( buf && ("Microsoft Windows" >< buf))
{
  winver = buf;
  fname = "nessus-registry-" + rand() + "-";
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '1.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Updates"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '2.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\HotFix"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "1.txt " + fname + "2.txt");
  # Store the entries in the KB 
  reg = egrep(pattern:"^\[HKEY_LOCAL_MACHINE.*\]", string:buf);
  flag = 0;
  foreach entry (split(reg))
  { 
  entry = chomp(entry);
  entry = ereg_replace(pattern:"^\[HKEY_LOCAL_MACHINE\\(.*)\]", string:entry, replace:"\1");
  entry = str_replace(find:"\", replace:"/", string:entry);
  name = "SMB/Registry/HKLM/" + entry;
  set_kb_item(name:name, value:TRUE);
  flag ++;
  }

  if ( flag )  set_kb_item(name:"SMB/Registry/Enumerated", value:TRUE);
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "1.txt " + fname + "2.txt");

  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '3.txt "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\ProductOptions"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "3.txt");
  reg = egrep(pattern:"^.ProductType.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"ProductType"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Control/ProductOptions", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "3.txt");
  
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '4.txt "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\W3SVC"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "4.txt");
  reg = egrep(pattern:"^.ImagePath.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"ImagePath"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Services/W3SVC/ImagePath", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "4.txt");

 
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '5.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\DataAccess"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "5.txt");
  reg = egrep(pattern:"^.Version.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"Version"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SOFTWARE/Microsoft/DataAccess/Version", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "5.txt");

  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '6.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Exchange\\Setup"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "6.txt");
  reg = egrep(pattern:"^.ServicePackBuild.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"ServicePackBuild"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SOFTWARE/Microsoft/Exchange/Setup/ServicePackBuild", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "6.txt");
 
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '7.txt "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "7.txt");
  reg = egrep(pattern:"^.CurrentVersion.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"CurrentVersion"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/WindowsVersion", value:value);
   nt_version = value;
  }
  reg = egrep(pattern:"^.CSDVersion.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"CSDVersion"="(.*)"', string:chomp(reg), replace:"\1");
   if ( nt_version == "4.0" ) set_kb_item(name:"SMB/WinNT4/ServicePack", value:value);
   if ( nt_version == "5.0" ) set_kb_item(name:"SMB/Win2K/ServicePack", value:value);
   if ( nt_version == "5.1" ) set_kb_item(name:"SMB/WinXP/ServicePack", value:value);
   set_kb_item(name:"SMB/RegOverSSH", value:TRUE);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "7.txt");
  buf = ssh_cmd(socket:sock,cmd:"cmd /C regedit /E/A " + fname + '8.txt "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\WINS"');
  buf = ssh_cmd(socket:sock,cmd:"cmd /C type " + fname + "8.txt");
  reg = egrep(pattern:"^.DisplayName.=.*", string:buf);
  if ( reg )
  {
   value = ereg_replace(pattern:'^"DisplayName"="(.*)"', string:chomp(reg), replace:"\1");
   set_kb_item(name:"SMB/Registry/HKLM/SYSTEM/CurrentControlSet/Services/WINS/DisplayName", value:value);
  }
  buf = ssh_cmd(socket:sock,cmd:"cmd /C del " + fname + "8.txt");

  report += '\nThe remote system is Microsoft Windows :' + winver + '\nHotfixes will be checked over SSH instead of SMB whenever possible';
  security_note(port:port, data:report);
  exit(0);
}

if ( islocalhost() )
	buf = pread(cmd:"uname", argv:make_list("uname", "-a"));
else
	buf = ssh_cmd(socket:sock,cmd:"uname -a");

if ( buf ) set_kb_item(name:"Host/uname", value:buf);
else {
	report += 
'\nHowever the execution of the command "uname -a" failed, so local security
checks have not been enabled';

	if ( ! islocalhost() )
	{
         error = ssh_cmd_error();
         if (strlen(error) > 0)
          report += '\n\nNessus return the following error message :\n' + error;
	}

	security_note(port:port, data:report);
	exit(0);
     }


report += '\nThe output of "uname -a" is :\n' + buf;


############################# FreeBSD ###########################################
if ( "FreeBSD" >< buf )
{
  release = ereg_replace(pattern:".*FreeBSD ([0-9]\.[^ ]*).*", replace:"\1", string:buf);
 items = split(release, sep:"-", keep:0);
 if ( "p" >< items[2] ) items[2] = ereg_replace(pattern:"p", replace:"_", string:items[2]);
 release = "FreeBSD-" + items[0] + items[2];
 set_kb_item(name:"Host/FreeBSD/release", value:release); 
  if ( islocalhost )
	buf = pread(cmd:"pkg_info", argv:make_list("pkg_info"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"/usr/sbin/pkg_info", timeout:60);

  if ( ! buf )  {
	report += 
'\nThe command "pkg_info" did not return any result, therefore
FreeBSD local security checks have not been enabled for
this test';
	security_note(port:port, data:report);
	}
  else {
        set_kb_item(name:"Host/FreeBSD/pkg_info", value:buf);
        report += '\nLocal security checks have been enabled for this host.';
	security_note(port:port, data:report);
	exit(0);
	}
}
######################## RedHat Linux ###########################################
else if ("Linux" >< buf )
{
  if ( islocalhost() )
	buf = pread(cmd:"cat", argv:make_list("cat", "/etc/redhat-release"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"cat /etc/redhat-release");

  if ( egrep(pattern:"Red Hat.*(Enterprise|Advanced).*release (3|2\.1)", string:buf) ||
       egrep(pattern:"Fedora Core.*", string:buf) )
  {
   if ( "Red Hat" >< buf ) report += '\nThe remote Red Hat system is :\n' + buf;
   else if ("Fedora" >< buf ) report += '\nThe remote Fedora system is :\n' + buf;
   set_kb_item(name:"Host/RedHat/release", value:buf);
   if ( islocalhost() )
	buf = pread(cmd:"rpm", argv:make_list("rpm", "-qa", "--qf", "'%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'"));
   else
   	buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'", timeout:120);

   if ( ! buf )
   {
     report += 
'\nThe command "rpm -qa" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/RedHat/rpm-list", value:buf);
   security_note(port:port, data:report);
   exit(0);
  }
#####################   Mandrake ####################################################
#Mandrake Linux release 9.1 (Bamboo) for i586
  else
  {
  #buf = ssh_cmd(socket:sock, cmd:"cat /etc/redhat-release");
  if ("Mandrake Linux" >< buf && "Mandrake Linux Corporate" >!< buf )
  {
   if ( "Mandrake" >< buf ) report += '\nThe remote Mandrake system is :\n' + buf;
   version = ereg_replace(pattern:"Mandrake Linux release ([0-9]\.[0-9]) .*", string:egrep(string:buf, pattern:"Mandrake"), replace:"\1");
   set_kb_item(name:"Host/Mandrake/release", value:"MDK" + version);
   
   #report += '\ndebug:\n' + version;
   
   if ( islocalhost() )
	buf = pread(cmd:"rpm", argv:make_list("rpm", "-qa", "--qf", "'%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'"));
   else
   	buf = ssh_cmd(socket:sock, cmd:"rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'", timeout:60);

   if ( ! buf )
   {
     report +=
'\nThe command "rpm -qa" did not produce any result, therefore local security
checks have been disabled';
    security_note(port:port, data:report);
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/Mandrake/rpm-list", value:buf);
   security_note(port:port, data:report);
   exit(0);
  }
  }

###################### SuSE ###############################################################
  if ( islocalhost() )
	buf = pread(cmd:"cat", argv:make_list("cat", "/etc/SuSE-release"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"cat /etc/SuSE-release");
  if ( buf && "SuSE" >< buf )
  {
   	if ( "SuSE Linux" >< buf ) report += '\nThe remote SuSE system is :\n' + egrep(pattern:"^SuSE", string:buf);

	version = ereg_replace(pattern:"SuSE Linux ([0-9]\.[0-9]) .*", string:egrep(string:buf, pattern:"SuSE"), replace:"\1");
  	
   	set_kb_item(name:"Host/SuSE/release", value:"SUSE" + version);
 	if ( islocalhost() )
		buf = pread(cmd:"rpm", argv:make_list("rpm", "-qa", "--qf", "'%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'"));
	else
   		buf = ssh_cmd(socket:sock, cmd:"rpm -qa --qf '%{NAME}-%{VERSION}-%{RELEASE}|%{EPOCH}\n'", timeout:60);

   if ( ! buf )
   {
     report += 
'\nThe command "rpm -qa" did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    exit(0);
   }

   report += '\nLocal security checks have been enabled for this host.';
   set_kb_item(name:"Host/SuSE/rpm-list", value:buf);
   security_note(port:port, data:report);
   exit(0);
  }
  
###################### Gentoo ###############################################
  if ( islocalhost() ) 
	buf = pread(cmd:"cat", argv:make_list("cat", "/etc/gentoo-release"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"cat /etc/gentoo-release");

  if ( buf && "Gentoo" >< buf )
  {
    if ( "Gentoo" >< buf )
      report += '\nThe remote Gentoo system is :\n' + egrep(pattern:"^Gentoo", string:buf);
    version = ereg_replace(pattern:"Gentoo Base System version ([0-9]\.[0-9]) .*",
                             string:egrep(string:buf, pattern:"Gentoo"), replace:"\1");
    # Release does not make much sense on Gentoo
    set_kb_item(name:"Host/Gentoo/release", value: version);

    if ( islocalhost() )
	buf = pread(cmd:"egrep", argv:make_list("egrep", '"ARCH="', "/etc/make.profile/make.defaults"));
    else
    	buf = ssh_cmd(socket: sock, timeout: 60, cmd: 'egrep "ARCH=" /etc/make.profile/make.defaults');

    buf = ereg_replace(string: buf, pattern: 'ARCH="(.*)"', replace: "\1");
    set_kb_item(name: "Host/Gentoo/arch", value: buf);

    # A great idea from David Maciejak: 
    # 1. app-portage/gentoolkit is not necessarily installed 
    # 2. and this find is quicker than "qpkg -v -I -nc"
    if ( islocalhost() )
	buf = pread(cmd:"find", argv:make_list("find", "/var/db/pkg/", "-mindepth", "2", "-maxdepth", "2", "-printf", '"%P\\n"'));
    else
    	buf = ssh_cmd(socket:sock, timeout:60, cmd:'find /var/db/pkg/ -mindepth 2 -maxdepth 2 -printf "%P\\n"');
    if (buf)
    {
      report += '\nLocal security checks have been enabled for this host.';
      set_kb_item(name:"Host/Gentoo/qpkg-list", value:buf);
      security_note(port:port, data:report);
    }
    else
    {
      report += 
'For any reason, find did not produce any result, therefore local security 
checks have been disabled';
     security_note(port:port, data:report);
    }
    exit(0);
    }

###################### Debian ###############################################
  if ( islocalhost()  )
  	buf = pread(cmd:"cat", argv:make_list("cat", "/etc/debian_version"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"cat /etc/debian_version");

  if ( buf && egrep(string:buf, pattern:'^[0-9.]+[ \t\r\n]*$'))
  {
    report += '\nThe remote Debian system is :\n' + buf;
    set_kb_item(name:"Host/Debian/release", value: chomp(buf));

    if ( islocalhost() )
	buf = pread(cmd:"dpkg", argv:make_list("dpkg", "-l") );
    else
    	buf = ssh_cmd(socket:sock, timeout:60, cmd:'COLUMNS=160 dpkg -l');

    if (buf)
    {
      report += '\nLocal security checks have been enabled for this host.';
      set_kb_item(name:"Host/Debian/dpkg-l", value:buf);
      security_note(port:port, data:report);
    }
    else
    {
      report += 
'For any reason, dpkg did not produce any result, therefore local security 
checks have been disabled';
    security_note(port:port, data:report);
    }
    exit(0);
  }

  report += 
'\nThe remote Linux distribution is not supported, therefore local security checks have not been enabled';
  security_note(port:port, data:report);
  exit(0);
}
######################## MacOS X ###########################################
else if ("Darwin" >< buf )
 {
  operating_system = ereg_replace(pattern:"^.*Darwin Kernel Version ([0-9]+\.[0-9]+\.[0-9]+):.*$", string:buf, replace:"\1");

  num = split(operating_system, sep:".", keep:FALSE);
  version = "Mac OS X 10." + string(int(num[0]) - 4) + "." + int(num[1]);


  if ( islocalhost() )
	buf = pread(cmd:"ls", argv:make_list("ls", "/private/etc/sysctl-macosxserver.conf"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"ls /private/etc/sysctl-macosxserver.conf");
  if ( strlen(buf) ) version = version + " Server";
  set_kb_item(name:"Host/MacOSX/Version", value:version);

  if ( islocalhost() )
	buf = pread(cmd:"ls", argv:make_list("ls", "/Library/Receipts"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"ls /Library/Receipts");

  if ( ! buf )
  {
   report += 
'\nIt was not possible to get the list of installed package on the 
remote MacOS X system, therefore local security checks have
been disabled';
   security_note(port:port, data:report);
   exit(0);
  }
  set_kb_item(name:"Host/MacOSX/packages", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  security_note(port:port, data:report);
 }
######################## Solaris ###########################################
else if ( egrep(pattern:"SunOS.*", string:buf) )
{
 if ( islocalhost() )
  	buf = pread(cmd:"showrev", argv:make_list("showrev", "-a"));
 else
 	buf = ssh_cmd(socket:sock, cmd:"showrev -a", timeout:60);

 if ( ! buf )
 {
  report += 
'\nIt was not possible to gather the list of installed packages on the
remote Solaris system, therefore local security checks have been disabled.';
  security_note(port:port, data:report);
  exit(0);
 }

 set_kb_item(name:"Host/Solaris/showrev", value:buf);

 buf = egrep(pattern:"^Release: ", string:buf);
 buf -= "Release: ";
 set_kb_item(name:"Host/Solaris/Version", value:buf);

 if ( islocalhost() )
 	buf = pread(cmd:"pkginfo", argv:make_list("pkginfo"));
 else
 	buf = ssh_cmd(socket:sock, cmd:"/usr/bin/pkginfo", timeout:120);

 if ( ! buf ) {
report = '\nIt was not possible to gather the list of installed packages on the
remote Solaris system, therefore local security checks have been disabled.';
  security_note(port:port, data:report);
  exit(0);
 }

  set_kb_item(name:"Host/Solaris/pkginfo", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  security_note(port:port, data:report);
}
############################# AIX ##############################################
else if ( "AIX" >< buf )
{
  release = ereg_replace(pattern:".*AIX[ ]+.*[ ]+([0-9]+[ ]+[0-9]+)[ ]+.*", replace:"\1", string:buf);
  items = split(release, sep:" ", keep:0);
  release = "AIX-" + items[1] + "." + items[0];
  set_kb_item(name:"Host/AIX/version", value:release); 

  if ( islocalhost()) 
	buf = pread(cmd:"oslevel", argv:make_list("oslevel", "-r"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"oslevel -r", timeout:60);

  if ( buf )  set_kb_item(name:"Host/AIX/oslevel", value:buf);

  if ( islocalhost() )
	buf = pread(cmd:"lslpp", argv:make_list("lslpp", "-Lc"));
  else
  	buf = ssh_cmd(socket:sock, cmd:"lslpp -Lc", timeout:60);

  if ( ! buf ) {
    report += 
'\nThe command "lslpp -Lc" did not return any result, therefore
AIX local security checks have not been enabled for
this test';
    security_note(port:port, data:report);
    exit(0);
  }
  set_kb_item(name:"Host/AIX/lslpp", value:buf);
  report += '\nLocal security checks have been enabled for this host.';
  security_note(port:port, data:report);
  exit(0);
}



#------------------------------------------------------------------------#
# Misc calls (all Unixes)						 #
#------------------------------------------------------------------------#

# cfengine version 

if( sock )
{
ver = ssh_cmd(socket:sock, cmd:"/usr/sbin/cfservd --help | grep ^cfengine | cut -d '-' -f 2", timeout:60);
if ( ver )
 {
 ver = chomp(ver);
 set_kb_item(name:string("cfengine/version"), value:ver);
 }
}



ssh_close_connection();
