#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15573);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id(11553);
 script_cve_id("CAN-2004-0988");
 name["english"] = "Quicktime < 6.5.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote Mac OS X host is running a version of Quicktime which is older
than Quicktime 6.5.2.

There is an integer overflow vulnerability in the remote version of this
software which may allow an attacker to execute arbitrary code on the remote
host. To exploit this flaw, an attacker would need to send a malformed
media file to a victim on the remote host, or set up a rogue web site and
lure a user on the remote host into visiting it.

Solution : http://docs.info.apple.com/article.html?artnum=61798
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Quicktime 6.5.2";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);

if ( ! egrep(pattern:"^QuickTime652\.pkg", string:packages) &&
       egrep(pattern:"^QuickTime\.pkg") )	
		security_hole ( port );
